/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets.table;

import docking.DockingWindowManager;
import docking.widgets.table.CombinedTableFilter;
import docking.widgets.table.GTable;
import docking.widgets.table.GTableHeaderRenderer;
import docking.widgets.table.RowObjectFilterModel;
import docking.widgets.table.TableFilter;
import docking.widgets.table.VariableColumnTableModel;
import docking.widgets.table.columnfilter.ColumnBasedTableFilter;
import ghidra.util.HTMLUtilities;
import ghidra.util.HelpLocation;
import help.HelpService;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.ToolTipManager;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import resources.ResourceManager;

public class GTableHeader
extends JTableHeader {
    private static final Cursor HAND_CURSOR = Cursor.getPredefinedCursor(12);
    private static final Cursor RESIZE_CURSOR = Cursor.getPredefinedCursor(11);
    private static final int HELP_ICON_HEIGHT = 8;
    private static final Icon HELP_ICON = ResourceManager.getScaledIcon((Icon)ResourceManager.loadImage((String)"images/info_small.png"), (int)8, (int)8);
    private static final Icon HELP_HOVERED_ICON = ResourceManager.getScaledIcon((Icon)ResourceManager.loadImage((String)"images/info_small_hover.png"), (int)8, (int)8);
    private final GTable gTable;
    private boolean isOverHelpIcon = false;
    private int hoveredColumnIndex = -1;

    GTableHeader(GTable table) {
        super(table.getColumnModel());
        this.gTable = table;
        ToolTipManager.sharedInstance().registerComponent(this);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
                if (!GTableHeader.this.isHelpEnabled()) {
                    return;
                }
                GTableHeader.this.restoreCursor();
                GTableHeader.this.hoveredColumnIndex = -1;
                GTableHeader.this.repaint();
            }
        });
        this.addMouseMotionListener(new MouseMotionListener(){

            @Override
            public void mouseDragged(MouseEvent e) {
            }

            @Override
            public void mouseMoved(MouseEvent e) {
                if (!GTableHeader.this.isHelpEnabled()) {
                    return;
                }
                GTableHeader.this.restoreCursor();
                int columnIndex = GTableHeader.this.columnAtPoint(e.getPoint());
                if (columnIndex < 0) {
                    return;
                }
                GTableHeader.this.hoveredColumnIndex = columnIndex;
                GTableHeader.this.isOverHelpIcon = GTableHeader.this.isMouseOverHelpIcon(e.getPoint(), columnIndex);
                if (GTableHeader.this.isOverHelpIcon) {
                    GTableHeader.this.installCursor();
                }
                GTableHeader.this.repaint();
            }
        });
        HelpLocation helpLocation = new HelpLocation("Tables", "GhidraTableHeaders");
        DockingWindowManager.getHelpService().registerHelp((Object)this, helpLocation);
    }

    private boolean isHelpEnabled() {
        return this.gTable.isColumnHeaderPopupEnabled();
    }

    private void installCursor() {
        if (!this.isHelpEnabled()) {
            return;
        }
        Cursor currentCursor = this.getCursor();
        if (currentCursor != RESIZE_CURSOR) {
            this.setCursor(HAND_CURSOR);
        }
    }

    private void restoreCursor() {
        if (!this.isHelpEnabled()) {
            return;
        }
        Cursor currentCursor = this.getCursor();
        if (currentCursor == HAND_CURSOR) {
            this.setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    private boolean isMouseOverHelpIcon(Point point, int columnIndex) {
        int paddedHeight;
        if (!this.canFindHelp()) {
            return false;
        }
        Rectangle headerRect = this.getHeaderRect(columnIndex);
        int padding = 2;
        int borderWidthTop = 2;
        int borderWidthRight = 4;
        int paddedWidth = paddedHeight = 8 + padding;
        int headerEndX = headerRect.x + headerRect.width;
        int helpIconStartX = headerEndX - (paddedWidth + borderWidthRight);
        int hoverWidth = headerEndX - helpIconStartX;
        int hoverHeight = paddedHeight + borderWidthTop;
        Rectangle helpIconRect = new Rectangle(helpIconStartX, 0, hoverWidth, hoverHeight);
        return helpIconRect.contains(point);
    }

    boolean isMouseOverHelpIcon() {
        return this.isOverHelpIcon;
    }

    int getHoveredHeaderColumnIndex() {
        return this.hoveredColumnIndex;
    }

    Icon getHelpIcon() {
        if (!this.canFindHelp()) {
            return null;
        }
        if (!this.isHelpEnabled()) {
            return null;
        }
        if (this.isOverHelpIcon) {
            return HELP_HOVERED_ICON;
        }
        return HELP_ICON;
    }

    private boolean canFindHelp() {
        HelpService helpService = DockingWindowManager.getHelpService();
        return helpService.helpExists();
    }

    @Override
    public String getToolTipText(MouseEvent e) {
        GTableHeaderRenderer gthr;
        String description;
        int columnIndex = this.columnAtPoint(e.getPoint());
        if (columnIndex < 0) {
            return null;
        }
        if (this.isOverHelpIcon) {
            return "Click here for table header help";
        }
        StringBuilder ttBuilder = new StringBuilder();
        TableColumn column = this.getColumnModel().getColumn(columnIndex);
        TableModel model = this.gTable.getModel();
        int realIndex = this.gTable.convertColumnIndexToModel(columnIndex);
        String columnFilterToolTip = this.getColumnFilterToolTip(model, realIndex);
        VariableColumnTableModel variableModel = VariableColumnTableModel.from(model);
        if (variableModel != null && (description = variableModel.getColumnDescription(realIndex)) != null) {
            ttBuilder.append(description);
        }
        if (columnFilterToolTip != null) {
            ttBuilder.append("<br><b>Filters: </b");
            ttBuilder.append(columnFilterToolTip);
        }
        if (ttBuilder.length() != 0) {
            return HTMLUtilities.wrapAsHTML((String)ttBuilder.toString());
        }
        TableCellRenderer headerRenderer = column.getHeaderRenderer();
        Component component = headerRenderer.getTableCellRendererComponent(this.getTable(), column.getHeaderValue(), false, false, 0, 0);
        int prefWidth = component.getPreferredSize().width;
        int cellWidth = this.getHeaderRect((int)columnIndex).width;
        if (prefWidth > cellWidth) {
            return column.getHeaderValue().toString();
        }
        if (component instanceof GTableHeaderRenderer && (gthr = (GTableHeaderRenderer)component).isTextOccluded()) {
            return column.getHeaderValue().toString();
        }
        if (component instanceof JComponent) {
            JComponent jComponent = (JComponent)component;
            return jComponent.getToolTipText();
        }
        return null;
    }

    private String getColumnFilterToolTip(TableModel model, int columnIndex) {
        ColumnBasedTableFilter<?> columnTableFilter = this.getColumnTableFilter(model);
        if (columnTableFilter == null) {
            return null;
        }
        return columnTableFilter.getToolTip(columnIndex);
    }

    private ColumnBasedTableFilter<?> getColumnTableFilter(TableModel model) {
        if (!(model instanceof RowObjectFilterModel)) {
            return null;
        }
        RowObjectFilterModel filterModel = (RowObjectFilterModel)model;
        TableFilter tableFilter = filterModel.getTableFilter();
        if (tableFilter == null) {
            return null;
        }
        if (tableFilter instanceof ColumnBasedTableFilter) {
            return (ColumnBasedTableFilter)tableFilter;
        }
        if (!(tableFilter instanceof CombinedTableFilter)) {
            return null;
        }
        CombinedTableFilter combinedFilter = (CombinedTableFilter)tableFilter;
        for (int i = 0; i < combinedFilter.getFilterCount(); ++i) {
            TableFilter<?> filter = combinedFilter.getFilter(i);
            if (!(filter instanceof ColumnBasedTableFilter)) continue;
            return (ColumnBasedTableFilter)filter;
        }
        return null;
    }

    @Override
    public TableColumn getDraggedColumn() {
        if (this.draggedColumn == null) {
            return null;
        }
        for (int column = 0; column < this.columnModel.getColumnCount(); ++column) {
            TableColumn modelsColumn = this.columnModel.getColumn(column);
            if (modelsColumn != this.draggedColumn) continue;
            return this.draggedColumn;
        }
        return null;
    }
}

