/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets.table;

import docking.widgets.table.AbstractDynamicTableColumn;
import docking.widgets.table.GDynamicColumnTableModel;
import docking.widgets.table.TableColumnDescriptor;
import ghidra.docking.settings.Settings;
import ghidra.framework.plugintool.ServiceProvider;
import ghidra.framework.plugintool.ServiceProviderStub;
import ghidra.util.Msg;
import ghidra.util.SystemUtilities;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

public class AnyObjectTableModel<T>
extends GDynamicColumnTableModel<T, Object> {
    private List<T> data;
    private String name;

    public AnyObjectTableModel(String modelName, Class<T> dataClass, String ... methodNames) {
        this(modelName, new ArrayList(), dataClass, Arrays.asList(methodNames));
    }

    public AnyObjectTableModel(String modelName, Method ... methods) {
        this(modelName, new ArrayList(), Arrays.asList(methods));
    }

    public AnyObjectTableModel(String modelName, List<Method> methods) {
        this(modelName, new ArrayList(), methods);
    }

    public AnyObjectTableModel(String modelName, Class<T> dataClass, List<String> methodNames) {
        this(modelName, new ArrayList(), dataClass, methodNames);
    }

    public AnyObjectTableModel(String modelName, List<T> data, Class<T> dataClass, List<String> methodNames) {
        super((ServiceProvider)new ServiceProviderStub());
        this.data = data;
        this.name = modelName;
        Objects.requireNonNull(methodNames);
        SystemUtilities.assertTrue((!methodNames.isEmpty() ? 1 : 0) != 0, (String)"Method names must be provided");
        for (String methodName : methodNames) {
            this.addTableColumn(new MethodColumn(dataClass, methodName));
        }
    }

    public AnyObjectTableModel(String modelName, List<T> data, List<Method> methods) {
        super((ServiceProvider)new ServiceProviderStub());
        this.data = data;
        this.name = modelName;
        Objects.requireNonNull(methods);
        SystemUtilities.assertTrue((!methods.isEmpty() ? 1 : 0) != 0, (String)"Methods must be provided");
        for (Method method : methods) {
            this.addTableColumn(new MethodColumn(method));
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isSortable(int columnIndex) {
        return true;
    }

    @Override
    public List<T> getModelData() {
        return this.data;
    }

    public void setModelData(List<T> data) {
        this.data = data;
        this.fireTableDataChanged();
    }

    @Override
    protected TableColumnDescriptor<T> createTableColumnDescriptor() {
        return new TableColumnDescriptor();
    }

    @Override
    public Object getDataSource() {
        return null;
    }

    private static String fromCamelCase(String text) {
        StringBuilder buffy = new StringBuilder();
        text.chars().mapToObj(i -> Character.valueOf((char)i)).forEach(c -> {
            if (c.charValue() == '_') {
                buffy.append(' ');
            } else if (Character.isUpperCase(c.charValue())) {
                if (buffy.length() > 1) {
                    buffy.append(' ');
                }
                buffy.append(c);
            } else {
                boolean wasSpace = AnyObjectTableModel.isLastCharASpace(buffy);
                char C = AnyObjectTableModel.maybeToUpperCase(c.charValue(), wasSpace);
                buffy.append(C);
            }
        });
        buffy.replace(0, 1, buffy.substring(0, 1).toUpperCase());
        return buffy.toString();
    }

    private static boolean isLastCharASpace(StringBuilder buffy) {
        if (buffy.length() == 0) {
            return false;
        }
        return buffy.charAt(buffy.length() - 1) == ' ';
    }

    private static char maybeToUpperCase(char c, boolean shouldBeUpper) {
        if (shouldBeUpper) {
            return Character.toUpperCase(c);
        }
        return c;
    }

    private class MethodColumn
    extends AbstractDynamicTableColumn<T, Object, Object> {
        private String name;
        private Method method;
        private Class<?> returnType;

        public MethodColumn(Class<T> dataClass, String methodName) {
            try {
                Method m = dataClass.getMethod(methodName, new Class[0]);
                this.init(m);
            }
            catch (NoSuchMethodException | SecurityException e) {
                this.name = "No method: " + methodName;
            }
        }

        public MethodColumn(Method method) {
            this.init(method);
        }

        @Override
        public String getColumnDescription() {
            return null;
        }

        private void init(Method m) {
            this.method = m;
            this.name = this.method.getName();
            if (this.name.startsWith("get")) {
                this.name = this.name.substring(3);
            }
            this.name = AnyObjectTableModel.fromCamelCase(this.name);
            this.returnType = this.method.getReturnType();
        }

        @Override
        public Class<Object> getColumnClass() {
            return this.returnType;
        }

        @Override
        public String getColumnName() {
            return this.name;
        }

        @Override
        public Object getValue(T rowObject, Settings settings, Object dataSource, ServiceProvider sp) throws IllegalArgumentException {
            if (this.method == null) {
                Msg.error((Object)this, (Object)("No method '" + this.name + "' on class" + rowObject.getClass().getSimpleName()));
                return null;
            }
            try {
                return this.method.invoke(rowObject, new Object[0]);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                Msg.debug((Object)this, (Object)("Problem invoking method: " + this.method.getName() + " on " + this.method.getDeclaringClass().getSimpleName() + ". See nested exception"), (Throwable)e);
                return null;
            }
        }
    }
}

