/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets.imagepanel.actions;

import docking.ActionContext;
import docking.action.MenuData;
import docking.action.ToolBarData;
import docking.widgets.filechooser.GhidraFileChooser;
import docking.widgets.filechooser.GhidraFileChooserMode;
import docking.widgets.imagepanel.ImagePanel;
import docking.widgets.imagepanel.actions.ImagePanelDockingAction;
import generic.util.image.ImageUtils;
import ghidra.util.Msg;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import resources.ResourceManager;

public class SaveImageAction
extends ImagePanelDockingAction {
    public SaveImageAction(String owner, ImagePanel imagePanel) {
        super("Export Image", owner, imagePanel);
        this.setPopupMenuData(new MenuData(new String[]{"Export Image As..."}, "io"));
        this.setToolBarData(new ToolBarData(ResourceManager.loadImage((String)"images/disk_save_as.png")));
    }

    private static File getExportFile() {
        GhidraFileChooser chooser = new GhidraFileChooser(null);
        chooser.setTitle("Export Image As...");
        chooser.setApproveButtonText("Save As");
        chooser.setFileSelectionMode(GhidraFileChooserMode.FILES_ONLY);
        chooser.setMultiSelectionEnabled(false);
        File selected = chooser.getSelectedFile(true);
        if (chooser.wasCancelled()) {
            return null;
        }
        return selected;
    }

    private static String getExtensionFromFile(File file) {
        String name = file.getName();
        int extPos = name.lastIndexOf(46);
        if (extPos < 0) {
            return "png";
        }
        return name.substring(extPos);
    }

    private void exportImage(Image image, File file) throws IOException {
        BufferedImage buffered = ImageUtils.getBufferedImage((Image)image);
        String extension = switch (extension = SaveImageAction.getExtensionFromFile(file).toLowerCase()) {
            case "png", "gif", "jpg" -> {
            }
            default -> "png";
        };
        ImageIO.write((RenderedImage)buffered, extension, file);
        Msg.info((Object)this, (Object)("Saved image to '" + file.getCanonicalPath() + "' in " + extension.toUpperCase() + " format"));
    }

    @Override
    public void actionPerformed(ActionContext context) {
        File file = null;
        Image image = this.imagePanel.getImage();
        file = SaveImageAction.getExportFile();
        if (file == null) {
            return;
        }
        try {
            this.exportImage(image, file);
        }
        catch (IOException ioe) {
            Msg.error((Object)this, (Object)("Unable to save image to '" + file.getName() + "': " + ioe.getMessage()), (Throwable)ioe);
        }
    }
}

