/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets.filechooser;

import docking.event.mouse.GMouseListenerAdapter;
import docking.widgets.AutoLookup;
import docking.widgets.GenericDateCellRenderer;
import docking.widgets.filechooser.DirectoryTableModel;
import docking.widgets.filechooser.FileEditor;
import docking.widgets.filechooser.FileTableCellRenderer;
import docking.widgets.filechooser.GhidraFileChooser;
import docking.widgets.filechooser.GhidraFileChooserDirectoryModelIf;
import docking.widgets.table.GTable;
import docking.widgets.table.GTableAutoLookup;
import docking.widgets.table.GTableCellRenderer;
import docking.widgets.table.GTableCellRenderingData;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.ArrayList;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.table.TableColumn;
import utilities.util.FileUtilities;

class DirectoryTable
extends GTable
implements GhidraFileChooserDirectoryModelIf {
    private GhidraFileChooser chooser;
    private DirectoryTableModel model;
    private int rowToEdit = -1;
    private FileEditor editor;

    DirectoryTable(GhidraFileChooser chooser, DirectoryTableModel model) {
        super(model);
        this.chooser = chooser;
        this.model = model;
        this.build();
    }

    private void build() {
        this.setAutoLookupColumn(0);
        this.setSelectionMode(0);
        this.setShowGrid(false);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                DirectoryTable.this.editingCanceled(null);
                DirectoryTable.this.requestFocus();
            }
        });
        this.addMouseListener(new GMouseListenerAdapter(){

            @Override
            public boolean shouldConsume(MouseEvent e) {
                return e.isPopupTrigger() && DirectoryTable.this.isEditing();
            }

            @Override
            public void popupTriggered(MouseEvent e) {
                DirectoryTable.this.maybeSelectItem(e);
            }

            @Override
            public void doubleClickTriggered(MouseEvent e) {
                DirectoryTable.this.handleDoubleClick();
            }
        });
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() != 10) {
                    return;
                }
                e.consume();
                int[] selectedRows = DirectoryTable.this.getSelectedRows();
                if (selectedRows.length == 0) {
                    DirectoryTable.this.chooser.okCallback();
                    return;
                }
                if (selectedRows.length > 1) {
                    DirectoryTable.this.chooser.okCallback();
                    return;
                }
                File file = DirectoryTable.this.model.getFile(selectedRows[0]);
                if (DirectoryTable.this.chooser.getModel().isDirectory(file)) {
                    DirectoryTable.this.chooser.setCurrentDirectory(file);
                } else {
                    DirectoryTable.this.chooser.userChoseFile(file);
                }
            }
        });
        this.getSelectionModel().addListSelectionListener(e -> {
            if (e.getValueIsAdjusting()) {
                return;
            }
            this.updateChooserForSelection();
        });
        this.editor = new FileEditor(this.chooser, this, this.model);
        TableColumn column = this.columnModel.getColumn(0);
        column.setCellRenderer(new FileTableCellRenderer(this.chooser));
        column.setCellEditor(this.editor);
        column = this.columnModel.getColumn(1);
        column.setCellRenderer(new FileSizeRenderer());
        column = this.columnModel.getColumn(2);
        column.setCellRenderer(new GenericDateCellRenderer());
    }

    @Override
    protected AutoLookup createAutoLookup() {
        return new GTableAutoLookup(this){

            @Override
            protected boolean canBinarySearchColumn(int column) {
                if (column == 0) {
                    return false;
                }
                return super.canBinarySearchColumn(column);
            }
        };
    }

    private void maybeSelectItem(MouseEvent e) {
        Point point = e.getPoint();
        int row = this.rowAtPoint(point);
        if (row < 0) {
            return;
        }
        this.selectRow(row);
    }

    private void updateChooserForSelection() {
        int[] selectedRows;
        ArrayList<File> selectedFiles = new ArrayList<File>();
        for (int i : selectedRows = this.getSelectedRows()) {
            selectedFiles.add(this.model.getFile(i));
        }
        this.chooser.userSelectedFiles(selectedFiles);
    }

    private void handleDoubleClick() {
        int[] selectedRows;
        ArrayList<File> selectedFiles = new ArrayList<File>();
        for (int i : selectedRows = this.getSelectedRows()) {
            selectedFiles.add(this.model.getFile(i));
        }
        if (selectedFiles.size() == 0 || selectedFiles.size() > 1) {
            return;
        }
        File file = (File)selectedFiles.get(0);
        if (this.chooser.getModel().isDirectory(file)) {
            this.chooser.setCurrentDirectory(file);
        } else {
            this.chooser.userChoseFile(file);
        }
    }

    void setRowToEdit(int rowToEdit) {
        this.rowToEdit = rowToEdit;
    }

    @Override
    public File getSelectedFile() {
        int row = this.getSelectedRow();
        if (row < 0) {
            return null;
        }
        return this.model.getFile(row);
    }

    @Override
    public File getFile(int row) {
        return this.model.getFile(row);
    }

    @Override
    public void edit() {
        int row = this.getSelectedRow();
        this.setRowToEdit(row);
        this.editCellAt(row, 0);
    }

    @Override
    public void setSelectedFile(File file) {
        File selectedFile;
        int[] selectedIndices = this.getSelectedRows();
        if (selectedIndices.length == 1 && (selectedFile = this.model.getFile(selectedIndices[0])).equals(file)) {
            return;
        }
        for (int i = 0; i < this.model.getRowCount(); ++i) {
            File aFile = this.model.getFile(i);
            if (aFile == null || !aFile.equals(file)) continue;
            this.setRowSelectionInterval(i, i);
            Rectangle rect = this.getCellRect(i, 0, true);
            this.scrollRectToVisible(rect);
            return;
        }
    }

    @Override
    public boolean editCellAt(int row, int column) {
        boolean edit = super.editCellAt(row, column);
        this.repaint();
        return edit;
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        return row == this.rowToEdit && column == 0;
    }

    @Override
    public void editingCanceled(ChangeEvent e) {
        this.rowToEdit = -1;
        super.editingCanceled(e);
    }

    @Override
    public void editingStopped(ChangeEvent e) {
        super.editingStopped(e);
        Object source = e.getSource();
        FileEditor fileCellEditor = (FileEditor)source;
        SwingUtilities.invokeLater(() -> {
            File newFile = (File)fileCellEditor.getCellEditorValue();
            this.chooser.setSelectedFileAndUpdateDisplay(newFile);
            this.rowToEdit = -1;
        });
    }

    private class FileSizeRenderer
    extends GTableCellRenderer {
        private FileSizeRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(GTableCellRenderingData data) {
            JLabel label = (JLabel)super.getTableCellRendererComponent(data);
            Object sz = data.getValue();
            if (sz == null) {
                return label;
            }
            Long size = (Long)sz;
            this.setText(FileUtilities.formatLength((long)size));
            return label;
        }
    }
}

