/*
 * Decompiled with CFR 0.152.
 */
package docking.framework;

import generic.jar.ResourceFile;
import ghidra.framework.ApplicationProperties;
import ghidra.util.SystemUtilities;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import util.CollectionUtils;
import utility.application.ApplicationLayout;
import utility.application.ApplicationUtilities;
import utility.module.ModuleUtilities;

public class DockingApplicationLayout
extends ApplicationLayout {
    private static final String NO_RELEASE_NAME = "NO_RELEASE";

    public DockingApplicationLayout(String name, String version) throws FileNotFoundException {
        this(new ApplicationProperties(name, version, NO_RELEASE_NAME));
    }

    public DockingApplicationLayout(ApplicationProperties applicationProperties) throws FileNotFoundException {
        this(DockingApplicationLayout.getDefaultApplicationRootDirs(), applicationProperties);
    }

    public DockingApplicationLayout(Collection<ResourceFile> applicationRootDirs, ApplicationProperties applicationProperties) throws FileNotFoundException {
        this.applicationProperties = Objects.requireNonNull(applicationProperties);
        this.applicationRootDirs = applicationRootDirs;
        this.applicationInstallationDir = applicationRootDirs.iterator().next().getParentFile();
        if (SystemUtilities.isInDevelopmentMode()) {
            this.applicationInstallationDir = this.applicationInstallationDir.getParentFile();
        }
        this.modules = SystemUtilities.isInDevelopmentMode() ? ModuleUtilities.findModules(applicationRootDirs, (Collection)ModuleUtilities.findModuleRootDirectories(applicationRootDirs, new ArrayList())) : ModuleUtilities.findModules(applicationRootDirs, applicationRootDirs);
        this.userTempDir = ApplicationUtilities.getDefaultUserTempDir((ApplicationProperties)applicationProperties);
        this.userSettingsDir = ApplicationUtilities.getDefaultUserSettingsDir((ApplicationProperties)applicationProperties, (ResourceFile)this.applicationInstallationDir);
    }

    public static Collection<ResourceFile> getDefaultApplicationRootDirs() {
        if (SystemUtilities.isInDevelopmentMode()) {
            return ApplicationUtilities.findDefaultApplicationRootDirs();
        }
        return CollectionUtils.asList((Object[])new ResourceFile[]{new ResourceFile(System.getProperty("user.dir"))});
    }
}

