/*
 * Decompiled with CFR 0.152.
 */
package docking.action;

import docking.ActionContext;
import docking.ComponentProvider;
import docking.DialogComponentProvider;
import docking.DockingDialog;
import docking.DockingKeyBindingAction;
import docking.DockingWindowManager;
import docking.ExecutableAction;
import docking.KeyBindingPrecedence;
import docking.MultiActionDialog;
import docking.Tool;
import docking.action.ComponentBasedDockingAction;
import docking.action.DockingActionIf;
import docking.actions.KeyBindingUtils;
import generic.util.WindowUtilities;
import ghidra.util.Swing;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.swing.KeyStroke;
import javax.swing.MenuSelectionManager;

public class MultipleKeyAction
extends DockingKeyBindingAction {
    private List<ActionData> actions = new ArrayList<ActionData>();
    private MultiActionDialog dialog;

    public MultipleKeyAction(Tool tool, ComponentProvider provider, DockingActionIf action, KeyStroke keyStroke) {
        super(tool, action, keyStroke);
        this.addAction(provider, action);
    }

    public boolean isEmpty() {
        return this.actions.isEmpty();
    }

    public void addAction(ComponentProvider provider, DockingActionIf action) {
        for (ActionData actionData : this.actions) {
            if (!actionData.action.equals(action)) continue;
            return;
        }
        KeyStroke keyBinding = action.getKeyBinding();
        if (!this.keyStroke.equals(keyBinding)) {
            throw new IllegalArgumentException("KeyStrokes don't match - was: " + this.keyStroke + " new: " + keyBinding);
        }
        this.actions.add(new ActionData(action, provider));
    }

    public void removeAction(DockingActionIf action) {
        Iterator<ActionData> iterator = this.actions.iterator();
        while (iterator.hasNext()) {
            ActionData actionData = iterator.next();
            if (actionData.action != action) continue;
            iterator.remove();
            return;
        }
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    @Override
    public synchronized void setEnabled(boolean newValue) {
        if (newValue != this.enabled) {
            boolean oldValue = this.enabled;
            this.enabled = newValue;
            this.firePropertyChange("enabled", oldValue, newValue);
        }
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        List<ExecutableAction> list = this.getActionsForCurrentOrDefaultContext(event.getSource());
        if (this.ignoreActionWhileMenuShowing()) {
            return;
        }
        if (list.size() > 1) {
            if (this.dialog == null) {
                this.dialog = new MultiActionDialog(KeyBindingUtils.parseKeyStroke(this.keyStroke), list);
            } else {
                this.dialog.setActionList(list);
            }
            Swing.runLater(() -> DockingWindowManager.showDialog(this.dialog));
        } else if (list.size() == 1) {
            ExecutableAction actionProxy = list.get(0);
            this.tool.setStatusInfo("");
            actionProxy.execute();
        } else {
            String name = (String)this.getValue("Name");
            this.tool.setStatusInfo("Action (" + name + ") not valid in this context!", true);
        }
    }

    private boolean ignoreActionWhileMenuShowing() {
        if (this.getKeyBindingPrecedence() == KeyBindingPrecedence.ReservedActionsLevel) {
            return false;
        }
        MenuSelectionManager menuManager = MenuSelectionManager.defaultManager();
        return menuManager.getSelectedPath().length != 0;
    }

    private List<ExecutableAction> getValidContextActions(ActionContext localContext, ActionContext globalContext) {
        ArrayList<ExecutableAction> list = new ArrayList<ExecutableAction>();
        boolean hasLocalActionsForKeyBinding = false;
        for (ActionData actionData : this.actions) {
            if (!actionData.isMyProvider(localContext)) continue;
            hasLocalActionsForKeyBinding = true;
            if (!this.isValidAndEnabled(actionData, localContext)) continue;
            list.add(new ExecutableAction(actionData.action, localContext));
        }
        if (hasLocalActionsForKeyBinding) {
            return list;
        }
        for (ActionData actionData : this.actions) {
            ComponentBasedDockingAction componentAction;
            if (!(actionData.action instanceof ComponentBasedDockingAction) || !(componentAction = (ComponentBasedDockingAction)actionData.action).isValidComponentContext(localContext)) continue;
            hasLocalActionsForKeyBinding = true;
            if (!this.isValidAndEnabled(actionData, localContext)) continue;
            list.add(new ExecutableAction(actionData.action, localContext));
        }
        if (hasLocalActionsForKeyBinding) {
            return list;
        }
        for (ActionData actionData : this.actions) {
            if (!actionData.isGlobalAction()) continue;
            if (this.isValidAndEnabled(actionData, localContext)) {
                list.add(new ExecutableAction(actionData.action, localContext));
                continue;
            }
            if (!this.isValidAndEnabledGlobally(actionData, globalContext)) continue;
            list.add(new ExecutableAction(actionData.action, globalContext));
        }
        return list;
    }

    private boolean isValidAndEnabled(ActionData actionData, ActionContext context) {
        DockingActionIf a = actionData.action;
        return a.isValidContext(context) && a.isEnabledForContext(context);
    }

    private boolean isValidAndEnabledGlobally(ActionData actionData, ActionContext context) {
        if (context == null) {
            return false;
        }
        return actionData.supportsDefaultToolContext() && this.isValidAndEnabled(actionData, context);
    }

    @Override
    public boolean isReservedKeybindingPrecedence() {
        return false;
    }

    @Override
    public KeyBindingPrecedence getKeyBindingPrecedence() {
        return this.geValidKeyBindingPrecedence(null);
    }

    public KeyBindingPrecedence geValidKeyBindingPrecedence(Component source) {
        List<ExecutableAction> validActions = this.getActionsForCurrentOrDefaultContext(source);
        if (validActions.isEmpty()) {
            return null;
        }
        if (validActions.size() != 1) {
            return KeyBindingPrecedence.DefaultLevel;
        }
        ExecutableAction actionProxy = validActions.get(0);
        DockingActionIf action = actionProxy.getAction();
        return action.getKeyBindingData().getKeyBindingPrecedence();
    }

    private List<ExecutableAction> getActionsForCurrentOrDefaultContext(Object eventSource) {
        DockingWindowManager dwm = this.tool.getWindowManager();
        Window window = this.getWindow(dwm, eventSource);
        if (window instanceof DockingDialog) {
            return this.getDialogActions(window);
        }
        ComponentProvider localProvider = this.getProvider(dwm, eventSource);
        ActionContext localContext = this.getLocalContext(localProvider);
        localContext.setSourceObject(eventSource);
        ActionContext globalContext = this.tool.getDefaultToolContext();
        List<ExecutableAction> validActions = this.getValidContextActions(localContext, globalContext);
        return validActions;
    }

    private List<ExecutableAction> getDialogActions(Window window) {
        DockingDialog dockingDialog = (DockingDialog)window;
        DialogComponentProvider provider = dockingDialog.getDialogComponent();
        if (provider == null) {
            return Collections.emptyList();
        }
        ActionContext context = provider.getActionContext(null);
        List<ExecutableAction> validActions = this.getValidContextActions(context, null);
        return validActions;
    }

    private ComponentProvider getProvider(DockingWindowManager dwm, Object eventSource) {
        if (eventSource instanceof Component) {
            return dwm.getProvider((Component)eventSource);
        }
        return dwm.getActiveComponentProvider();
    }

    private Window getWindow(DockingWindowManager dwm, Object eventSource) {
        if (eventSource instanceof Component) {
            return WindowUtilities.windowForComponent((Component)((Component)eventSource));
        }
        return dwm.getActiveWindow();
    }

    public List<DockingActionIf> getActions() {
        ArrayList<DockingActionIf> list = new ArrayList<DockingActionIf>(this.actions.size());
        for (ActionData actionData : this.actions) {
            list.add(actionData.action);
        }
        return list;
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [\n\t" + this.getKeyBindingsAsString() + "\n]";
    }

    private String getKeyBindingsAsString() {
        StringBuilder buildy = new StringBuilder();
        for (ActionData data : this.actions) {
            buildy.append(data.action.toString()).append("\n\t");
        }
        if (this.actions.size() > 0) {
            buildy.delete(buildy.length() - 2, buildy.length());
        }
        return buildy.toString();
    }

    private class ActionData {
        DockingActionIf action;
        ComponentProvider provider;

        ActionData(DockingActionIf action, ComponentProvider provider) {
            this.action = action;
            this.provider = provider;
        }

        boolean isGlobalAction() {
            return this.provider == null;
        }

        boolean isMyProvider(ActionContext localContext) {
            ComponentProvider otherProvider = localContext.getComponentProvider();
            return this.provider == otherProvider;
        }

        boolean supportsDefaultToolContext() {
            return this.action.supportsDefaultToolContext();
        }

        public String toString() {
            String providerString = this.provider == null ? "" : this.provider.toString() + " - ";
            return providerString + this.action;
        }
    }
}

