/*
 * Decompiled with CFR 0.152.
 */
package docking;

import docking.ComponentProvider;
import docking.DockingWindowManager;
import docking.Tool;
import java.awt.Component;
import java.awt.event.MouseEvent;

public class ActionContext {
    private ComponentProvider provider;
    private MouseEvent mouseEvent;
    private Object contextObject;
    private Object sourceObject;
    private int eventClickModifiers;
    private ActionContext globalContext;
    private Component sourceComponent;

    public ActionContext() {
        this(null, null);
    }

    public ActionContext(ComponentProvider cp) {
        this(cp, null);
    }

    public ActionContext(ComponentProvider provider, Component sourceComponent) {
        this(provider, sourceComponent, sourceComponent);
    }

    public ActionContext(ComponentProvider provider, Object contextObject, Component sourceComponent) {
        this.provider = provider;
        this.contextObject = contextObject;
        this.sourceObject = sourceComponent;
        this.sourceComponent = sourceComponent;
    }

    private void lazyDeriveSourceComponent() {
        if (this.sourceComponent != null) {
            return;
        }
        if (this.sourceObject instanceof Component) {
            this.sourceComponent = (Component)this.sourceObject;
            return;
        }
        if (this.mouseEvent != null) {
            this.sourceComponent = this.mouseEvent.getComponent();
            return;
        }
        if (this.contextObject instanceof Component) {
            this.sourceComponent = (Component)this.contextObject;
        }
    }

    public ComponentProvider getComponentProvider() {
        return this.provider;
    }

    public Object getContextObject() {
        if (this.contextObject != null) {
            return this.contextObject;
        }
        return this;
    }

    public ActionContext setContextObject(Object contextObject) {
        this.contextObject = contextObject;
        return this;
    }

    public Object getSourceObject() {
        return this.sourceObject;
    }

    public void setEventClickModifiers(int modifiers) {
        this.eventClickModifiers = modifiers;
    }

    public int getEventClickModifiers() {
        return this.eventClickModifiers;
    }

    public boolean hasAnyEventClickModifiers(int modifiersMask) {
        return (this.eventClickModifiers & modifiersMask) != 0;
    }

    public ActionContext setSourceObject(Object sourceObject) {
        this.sourceObject = sourceObject;
        return this;
    }

    public ActionContext setMouseEvent(MouseEvent e) {
        if (e != null) {
            this.mouseEvent = e;
            this.eventClickModifiers = e.getModifiersEx();
        }
        return this;
    }

    public MouseEvent getMouseEvent() {
        return this.mouseEvent;
    }

    public Component getSourceComponent() {
        this.lazyDeriveSourceComponent();
        return this.sourceComponent;
    }

    public String toString() {
        return "{\n\tprovider: " + this.provider + ",\n\tcontextObject: " + this.contextObject + ",\n\tsourceObject: " + this.sourceObject + ",\n\tsourceComponent: " + this.sourceComponent + ",\n\tmouseEvent: " + this.mouseEvent + "\n}";
    }

    public ActionContext getGlobalContext() {
        if (this.globalContext == null) {
            Tool tool = this.getTool();
            this.globalContext = tool == null ? new ActionContext() : tool.getDefaultToolContext();
        }
        return this.globalContext;
    }

    private Tool getTool() {
        if (this.provider != null) {
            return this.provider.getTool();
        }
        DockingWindowManager manager = DockingWindowManager.getActiveInstance();
        if (manager != null) {
            return manager.getTool();
        }
        return null;
    }
}

