/*
 * Decompiled with CFR 0.152.
 */
package agent.frida.model.impl;

import agent.frida.frida.FridaClient;
import agent.frida.manager.FridaCause;
import agent.frida.manager.FridaProcess;
import agent.frida.manager.FridaSession;
import agent.frida.model.iface1.FridaModelTargetConfigurable;
import agent.frida.model.iface2.FridaModelTargetProcess;
import agent.frida.model.iface2.FridaModelTargetProcessContainer;
import agent.frida.model.impl.FridaModelTargetObjectImpl;
import agent.frida.model.impl.FridaModelTargetProcessImpl;
import agent.frida.model.impl.FridaModelTargetSessionImpl;
import ghidra.async.AsyncUtils;
import ghidra.dbg.DebuggerModelListener;
import ghidra.dbg.error.DebuggerIllegalArgumentException;
import ghidra.dbg.target.TargetEventScope;
import ghidra.dbg.target.TargetObject;
import ghidra.dbg.target.schema.TargetAttributeType;
import ghidra.dbg.target.schema.TargetElementType;
import ghidra.dbg.target.schema.TargetObjectSchemaInfo;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;

@TargetObjectSchemaInfo(name="ProcessContainer", elements={@TargetElementType(type=FridaModelTargetProcessImpl.class)}, attributes={@TargetAttributeType(name="_base", type=Integer.class), @TargetAttributeType(type=Void.class)}, canonicalContainer=true)
public class FridaModelTargetProcessContainerImpl
extends FridaModelTargetObjectImpl
implements FridaModelTargetProcessContainer,
FridaModelTargetConfigurable {
    private FridaModelTargetSessionImpl session;

    public FridaModelTargetProcessContainerImpl(FridaModelTargetSessionImpl session) {
        super(session.getModel(), (TargetObject)session, "Processes", "ProcessContainer");
        this.session = session;
        this.changeAttributes(List.of(), Map.of("_base", 16), "Initialized");
        this.getManager().addEventsListener(this);
    }

    @Override
    public void processAdded(FridaProcess proc, FridaCause cause) {
        FridaSession parentSession = (FridaSession)this.session.getModelObject();
        FridaSession procSession = proc.getSession();
        if (!FridaClient.getId(parentSession).equals(FridaClient.getId(procSession))) {
            return;
        }
        this.session.setAccessible(true);
        FridaModelTargetProcess process = this.getTargetProcess(proc);
        this.changeElements(List.of(), List.of(process), Map.of(), "Added");
        process.processStarted(proc);
        ((DebuggerModelListener)this.getListeners().fire).event((TargetObject)this.getProxy(), null, TargetEventScope.TargetEventType.PROCESS_CREATED, "Process " + FridaClient.getId(proc) + " started " + process.getName(), List.of(process));
    }

    @Override
    public void processReplaced(FridaProcess proc, FridaCause cause) {
        this.session.setAccessible(true);
        FridaModelTargetProcess process = this.getTargetProcess(proc);
        this.changeElements(List.of(), List.of(process), Map.of(), "Added");
    }

    @Override
    public void processStarted(FridaProcess proc, FridaCause cause) {
        FridaModelTargetProcess process = this.getTargetProcess(proc);
        process.processStarted(proc);
    }

    @Override
    public void processRemoved(String processId, FridaCause cause) {
        this.changeElements(List.of(processId), List.of(), Map.of(), "Removed");
    }

    public CompletableFuture<Void> requestElements(boolean refresh) {
        return this.getManager().listProcesses(this.session.getSession()).thenAccept(byIID -> {
            List processes;
            FridaModelTargetProcessContainerImpl fridaModelTargetProcessContainerImpl = this;
            synchronized (fridaModelTargetProcessContainerImpl) {
                processes = byIID.values().stream().map(this::getTargetProcess).collect(Collectors.toList());
            }
            this.setElements(processes, Map.of(), "Refreshed");
        });
    }

    @Override
    public synchronized FridaModelTargetProcess getTargetProcess(FridaProcess process) {
        TargetObject targetObject = this.getMapObject(process);
        if (targetObject != null) {
            FridaModelTargetProcess targetProcess = (FridaModelTargetProcess)targetObject;
            targetProcess.setModelObject(process);
            return targetProcess;
        }
        return new FridaModelTargetProcessImpl(this, process);
    }

    public CompletableFuture<Void> writeConfigurationOption(String key, Object value) {
        switch (key) {
            case "_base": {
                if (value instanceof Integer) {
                    this.changeAttributes(List.of(), Map.of("_base", value), "Modified");
                    for (TargetObject child : this.getCachedElements().values()) {
                        if (!(child instanceof FridaModelTargetProcessImpl)) continue;
                        FridaModelTargetProcessImpl targetProcess = (FridaModelTargetProcessImpl)child;
                        targetProcess.setBase(value);
                    }
                    break;
                }
                throw new DebuggerIllegalArgumentException("Base should be numeric");
            }
        }
        return AsyncUtils.NIL;
    }
}

