/*
 * Decompiled with CFR 0.152.
 */
package agent.frida.model.impl;

import agent.frida.model.iface1.FridaModelTargetConfigurable;
import agent.frida.model.iface2.FridaModelTargetAvailableProcess;
import agent.frida.model.iface2.FridaModelTargetAvailableProcessesContainer;
import agent.frida.model.iface2.FridaModelTargetRoot;
import agent.frida.model.impl.FridaModelTargetAvailableProcessImpl;
import agent.frida.model.impl.FridaModelTargetObjectImpl;
import ghidra.async.AsyncUtils;
import ghidra.dbg.error.DebuggerIllegalArgumentException;
import ghidra.dbg.target.TargetObject;
import ghidra.dbg.target.schema.TargetAttributeType;
import ghidra.dbg.target.schema.TargetElementType;
import ghidra.dbg.target.schema.TargetObjectSchema;
import ghidra.dbg.target.schema.TargetObjectSchemaInfo;
import ghidra.util.datastruct.WeakValueHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;

@TargetObjectSchemaInfo(name="AvailableProcessesContainer", elements={@TargetElementType(type=FridaModelTargetAvailableProcessImpl.class)}, elementResync=TargetObjectSchema.ResyncMode.ALWAYS, attributes={@TargetAttributeType(name="_base", type=Integer.class), @TargetAttributeType(type=Void.class)}, canonicalContainer=true)
public class FridaModelTargetAvailableProcessesContainerImpl
extends FridaModelTargetObjectImpl
implements FridaModelTargetAvailableProcessesContainer,
FridaModelTargetConfigurable {
    protected final Map<String, FridaModelTargetAvailableProcess> attachablesById = new WeakValueHashMap();

    public FridaModelTargetAvailableProcessesContainerImpl(FridaModelTargetRoot root) {
        super(root.getModel(), (TargetObject)root, "AvailableProcesses", "AvailableProcessContainer");
        this.changeAttributes(List.of(), Map.of("_base", 16), "Initialized");
    }

    public CompletableFuture<Void> requestElements(boolean refresh) {
        return this.getManager().listAvailableProcesses().thenAccept(list -> {
            List available;
            FridaModelTargetAvailableProcessesContainerImpl fridaModelTargetAvailableProcessesContainerImpl = this;
            synchronized (fridaModelTargetAvailableProcessesContainerImpl) {
                available = list.stream().map(this::getTargetAttachableEx).collect(Collectors.toList());
            }
            this.setElements(available, Map.of(), "Refreshed");
        });
    }

    public synchronized FridaModelTargetAvailableProcess getTargetAttachableEx(Pair<String, String> pair) {
        return this.attachablesById.computeIfAbsent((String)pair.getLeft(), i -> new FridaModelTargetAvailableProcessImpl(this, (String)pair.getLeft(), (String)pair.getRight()));
    }

    @Override
    public synchronized FridaModelTargetAvailableProcess getTargetAttachable(String pid) {
        return this.attachablesById.computeIfAbsent(pid, i -> new FridaModelTargetAvailableProcessImpl(this, pid));
    }

    public CompletableFuture<Void> writeConfigurationOption(String key, Object value) {
        switch (key) {
            case "_base": {
                if (value instanceof Integer) {
                    this.changeAttributes(List.of(), Map.of("_base", value), "Modified");
                    for (FridaModelTargetAvailableProcess child : this.attachablesById.values()) {
                        child.setBase(value);
                    }
                    break;
                }
                throw new DebuggerIllegalArgumentException("Base should be numeric");
            }
        }
        return AsyncUtils.NIL;
    }
}

