/*
 * Decompiled with CFR 0.152.
 */
package agent.frida.manager.cmd;

import agent.frida.frida.FridaClient;
import agent.frida.manager.FridaCause;
import agent.frida.manager.FridaError;
import agent.frida.manager.FridaEventsListener;
import agent.frida.manager.FridaProcess;
import agent.frida.manager.FridaSession;
import agent.frida.manager.FridaThread;
import agent.frida.manager.cmd.AbstractFridaCommand;
import agent.frida.manager.cmd.FridaPendingCommand;
import agent.frida.manager.impl.FridaManagerImpl;
import ghidra.util.Msg;
import java.util.ArrayList;
import java.util.Map;

public class FridaDetachCommand
extends AbstractFridaCommand<Void> {
    private final FridaSession session;

    public FridaDetachCommand(FridaManagerImpl manager, FridaSession session) {
        super(manager);
        this.session = session;
    }

    @Override
    public Void complete(FridaPendingCommand<?> pending) {
        FridaProcess process = this.session.getProcess();
        String pid = FridaClient.getId(process);
        Map<String, FridaThread> threads = this.manager.getKnownThreads(process);
        ArrayList<FridaThread> list = new ArrayList<FridaThread>();
        list.addAll(threads.values());
        for (FridaThread thread : list) {
            this.manager.removeThread(pid, FridaClient.getId(thread));
        }
        ((FridaEventsListener)this.manager.getEventListeners().fire).processRemoved(pid, FridaCause.Causes.UNCLAIMED);
        return null;
    }

    @Override
    public void invoke() {
        FridaError res = this.session.detach();
        if (!res.success()) {
            Msg.error((Object)this, (Object)res.getDescription());
        }
    }
}

