/*
 * Decompiled with CFR 0.152.
 */
package ghidra.async;

import ghidra.async.SwingExecutorService;
import ghidra.async.TypeSpec;
import ghidra.async.loop.AsyncLoop;
import ghidra.async.loop.AsyncLoopFirstActionConsumesAndProduces;
import ghidra.async.loop.AsyncLoopFirstActionProduces;
import ghidra.async.loop.AsyncLoopOnlyActionRuns;
import ghidra.async.loop.AsyncLoopSecondActionConsumes;
import ghidra.async.seq.AsyncSequenceWithoutTemp;
import ghidra.util.Msg;
import java.lang.ref.Cleaner;
import java.nio.channels.CompletionHandler;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.BiFunction;
import org.apache.commons.lang3.exception.ExceptionUtils;

public interface AsyncUtils<T> {
    public static final Cleaner CLEANER = Cleaner.create();
    public static final ExecutorService FRAMEWORK_EXECUTOR = Executors.newWorkStealingPool();
    public static final ExecutorService SWING_EXECUTOR = SwingExecutorService.LATER;
    public static final CompletableFuture<Void> NIL = CompletableFuture.completedFuture(null);

    public static <T> CompletableFuture<T> nil() {
        return NIL;
    }

    public static <T, U> CompletableFuture<T> loop(TypeSpec<T> loopType, AsyncLoopFirstActionProduces<T, U> producer, TypeSpec<U> iterateType, AsyncLoopSecondActionConsumes<T, ? super U> consumer) {
        AsyncLoop<T, U> loop = new AsyncLoop<T, U>(producer, iterateType, consumer);
        loop.begin();
        return loop;
    }

    public static <T> CompletableFuture<T> loop(TypeSpec<T> loopType, AsyncLoopOnlyActionRuns<T> action) {
        return AsyncUtils.loop(loopType, handler -> handler.consume(null, null), TypeSpec.VOID, (v, handler) -> action.accept(handler));
    }

    public static <T, E, U> CompletableFuture<T> each(TypeSpec<T> loopType, Iterator<E> it, AsyncLoopFirstActionConsumesAndProduces<T, E, U> producer, TypeSpec<U> iterateType, AsyncLoopSecondActionConsumes<T, U> consumer) {
        return AsyncUtils.loop(loopType, handler -> {
            if (it.hasNext()) {
                Object elem;
                try {
                    elem = it.next();
                }
                catch (Throwable exc) {
                    handler.exit(null, exc);
                    return;
                }
                producer.accept(elem, handler);
            } else {
                handler.exit(null, null);
            }
        }, iterateType, consumer);
    }

    public static <T, E> CompletableFuture<T> each(TypeSpec<T> loopType, Iterator<E> it, AsyncLoopSecondActionConsumes<T, E> action) {
        return AsyncUtils.each(loopType, it, (e, loop) -> loop.consume(e, null), TypeSpec.obj(null), action);
    }

    public static <R> AsyncSequenceWithoutTemp<R> sequence(TypeSpec<R> type) {
        return AsyncUtils.sequence(new CompletableFuture());
    }

    public static <R> AsyncSequenceWithoutTemp<R> sequence(CompletableFuture<R> on) {
        return new AsyncSequenceWithoutTemp<R>(on, NIL);
    }

    public static <T, A> CompletableFuture<T> completable(TypeSpec<T> type, TakesCompletionHandlerArity0<T> func) {
        FutureCompletionHandler handler = new FutureCompletionHandler();
        func.launch(null, handler);
        return handler.future;
    }

    public static <T, P0, A> CompletableFuture<T> completable(TypeSpec<T> type, TakesCompletionHandlerArity1<T, P0> func, P0 arg0) {
        FutureCompletionHandler handler = new FutureCompletionHandler();
        func.launch(arg0, null, handler);
        return handler.future;
    }

    public static <T, P0, P1, A> CompletableFuture<T> completable(TypeSpec<T> type, TakesCompletionHandlerArity2<T, P0, P1> func, P0 arg0, P1 arg1) {
        FutureCompletionHandler handler = new FutureCompletionHandler();
        func.launch(arg0, arg1, null, handler);
        return handler.future;
    }

    public static <T, P0, P1, P2, A> CompletableFuture<T> completable(TypeSpec<T> type, TakesCompletionHandlerArity3<T, P0, P1, P2> func, P0 arg0, P1 arg1, P2 arg2) {
        FutureCompletionHandler handler = new FutureCompletionHandler();
        func.launch(arg0, arg1, arg2, null, handler);
        return handler.future;
    }

    public static <T, P0, P1, P2, P3, A> CompletableFuture<T> completable(TypeSpec<T> type, TakesCompletionHandlerArity4<T, P0, P1, P2, P3> func, P0 arg0, P1 arg1, P2 arg2, P3 arg3) {
        FutureCompletionHandler handler = new FutureCompletionHandler();
        func.launch(arg0, arg1, arg2, arg3, null, handler);
        return handler.future;
    }

    public static <T, A> void handle(CompletableFuture<T> future, A attachment, CompletionHandler<T, ? super A> handler) {
        future.handle((result, exc) -> {
            if (exc != null) {
                handler.failed((Throwable)exc, (Object)attachment);
            } else {
                handler.completed((Object)result, (Object)attachment);
            }
            return null;
        });
    }

    public static void defensive(TemperamentalRunnable cb) {
        try {
            cb.run();
        }
        catch (Throwable e) {
            Msg.error((Object)cb, (Object)"Error in callback", (Throwable)e);
        }
    }

    public static Throwable unwrapThrowable(Throwable e) {
        Throwable exc = e;
        while (exc instanceof CompletionException || exc instanceof ExecutionException) {
            exc = exc.getCause();
        }
        return exc;
    }

    public static <T> BiFunction<T, Throwable, T> copyTo(CompletableFuture<T> dest) {
        return (t, ex) -> {
            if (ex != null) {
                dest.completeExceptionally((Throwable)ex);
                return ExceptionUtils.rethrow((Throwable)ex);
            }
            dest.complete(t);
            return t;
        };
    }

    public static class FutureCompletionHandler<T, A>
    implements CompletionHandler<T, A> {
        CompletableFuture<T> future = new CompletableFuture();

        @Override
        public void completed(T result, A attachment) {
            this.future.complete(result);
        }

        @Override
        public void failed(Throwable exc, A attachment) {
            this.future.completeExceptionally(exc);
        }
    }

    public static interface TakesCompletionHandlerArity0<T> {
        public <A> void launch(A var1, CompletionHandler<T, ? super A> var2);
    }

    public static interface TakesCompletionHandlerArity1<T, P0> {
        public <A> void launch(P0 var1, A var2, CompletionHandler<T, ? super A> var3);
    }

    public static interface TakesCompletionHandlerArity2<T, P0, P1> {
        public <A> void launch(P0 var1, P1 var2, A var3, CompletionHandler<T, ? super A> var4);
    }

    public static interface TakesCompletionHandlerArity3<T, P0, P1, P2> {
        public <A> void launch(P0 var1, P1 var2, P2 var3, A var4, CompletionHandler<T, ? super A> var5);
    }

    public static interface TakesCompletionHandlerArity4<T, P0, P1, P2, P3> {
        public <A> void launch(P0 var1, P1 var2, P2 var3, P3 var4, A var5, CompletionHandler<T, ? super A> var6);
    }

    public static interface TemperamentalRunnable {
        public void run() throws Throwable;
    }

    public static interface TemperamentalSupplier<T> {
        public T get() throws Throwable;
    }
}

