/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util.datastruct;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.RemovalCause;
import com.google.common.cache.RemovalNotification;
import ghidra.util.Msg;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.atomic.AtomicReference;

public class ListenerMap<K, P, V extends P> {
    public static final Executor CALLING_THREAD = new Executor(){

        @Override
        public void execute(Runnable command) {
            command.run();
        }
    };
    protected static final AtomicReference<Throwable> firstExc = new AtomicReference();
    private final Object lock = new Object();
    private final Class<P> iface;
    private final Executor executor;
    private Map<K, V> map = this.createMap();
    private Set<ListenerMap<?, ? extends P, ?>> chained = new LinkedHashSet();
    public final P fire;
    protected final Map<Class<? extends P>, P> extFires = new HashMap<Class<? extends P>, P>();

    protected static void reportError(Object listener, Throwable e) {
        if (e instanceof RejectedExecutionException) {
            Msg.trace((Object)listener, (Object)("Listener invocation rejected: " + e));
        } else {
            Msg.error((Object)listener, (Object)("Listener " + listener + " caused unexpected exception"), (Throwable)e);
            firstExc.accumulateAndGet(e, (o, n) -> o == null ? n : o);
        }
    }

    public static void clearErr() {
        firstExc.set(null);
    }

    public static void checkErr() {
        Throwable exc = firstExc.getAndSet(null);
        if (exc != null) {
            throw new AssertionError("Listener caused an exception", exc);
        }
    }

    public ListenerMap(Class<P> iface) {
        this(iface, CALLING_THREAD);
    }

    public ListenerMap(Class<P> iface, Executor executor) {
        this.iface = Objects.requireNonNull(iface);
        this.executor = executor;
        this.fire = iface.cast(Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{iface}, new ListenerHandler<P>(iface)));
    }

    public String toString() {
        return this.map.toString();
    }

    protected Map<K, V> createMap() {
        CacheBuilder builder = CacheBuilder.newBuilder().removalListener(this::notifyRemoved).weakValues().concurrencyLevel(1);
        return builder.build().asMap();
    }

    protected void notifyRemoved(RemovalNotification<K, V> rn) {
        if (rn.getCause() == RemovalCause.COLLECTED) {
            Msg.warn((Object)this, (Object)("Listener garbage collected before removal: " + rn));
        }
    }

    public <T extends P> T fire(Class<T> ext) {
        if (ext == this.iface) {
            return ext.cast(this.fire);
        }
        if (!this.iface.isAssignableFrom(ext)) {
            throw new IllegalArgumentException("Cannot fire on less-specific interface");
        }
        return (T)this.extFires.computeIfAbsent(ext, e -> Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{this.iface, ext}, new ListenerHandler(ext)));
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V put(K key, V val) {
        Object object = this.lock;
        synchronized (object) {
            if (this.map.get(key) == val) {
                return val;
            }
            Map<K, V> newMap = this.createMap();
            newMap.putAll(this.map);
            V result = newMap.put(key, val);
            this.map = newMap;
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putAll(ListenerMap<? extends K, P, ? extends V> that) {
        Object object = this.lock;
        synchronized (object) {
            Map<K, V> newMap = this.createMap();
            newMap.putAll(this.map);
            newMap.putAll(that.map);
            this.map = newMap;
        }
    }

    public V get(K key) {
        return this.map.get(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V remove(K key) {
        Object object = this.lock;
        synchronized (object) {
            if (!this.map.containsKey(key)) {
                return null;
            }
            Map<K, V> newMap = this.createMap();
            newMap.putAll(this.map);
            V result = newMap.remove(key);
            this.map = newMap;
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Object object = this.lock;
        synchronized (object) {
            if (this.map.isEmpty()) {
                return;
            }
            this.map = this.createMap();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addChained(ListenerMap<?, ? extends P, ?> map) {
        Object object = this.lock;
        synchronized (object) {
            if (this.chained.contains(map)) {
                return;
            }
            LinkedHashSet newChained = new LinkedHashSet();
            newChained.addAll(this.chained);
            newChained.add(map);
            this.chained = newChained;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeChained(ListenerMap<?, ?, ?> map) {
        Object object = this.lock;
        synchronized (object) {
            if (!this.chained.contains(map)) {
                return;
            }
            LinkedHashSet newChained = new LinkedHashSet();
            newChained.addAll(this.chained);
            newChained.remove(map);
            this.chained = newChained;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearChained() {
        Object object = this.lock;
        synchronized (object) {
            if (this.chained.isEmpty()) {
                return;
            }
            this.chained = new LinkedHashSet();
        }
    }

    protected class ListenerHandler<T extends P>
    implements InvocationHandler {
        protected final Class<T> ext;

        public ListenerHandler(Class<T> ext) {
            this.ext = ext;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            Set chainedVolatile;
            ListenerMap.this.executor.execute(() -> {
                Collection listenersVolatile;
                Iterator iterator = ListenerMap.this.lock;
                synchronized (iterator) {
                    listenersVolatile = ListenerMap.this.map.values();
                }
                for (Object l : listenersVolatile) {
                    if (!this.ext.isAssignableFrom(l.getClass())) continue;
                    try {
                        method.invoke(l, args);
                    }
                    catch (InvocationTargetException e) {
                        Throwable cause = e.getCause();
                        ListenerMap.reportError(l, cause);
                    }
                    catch (Throwable e) {
                        ListenerMap.reportError(l, e);
                    }
                }
            });
            Iterator iterator = ListenerMap.this.lock;
            synchronized (iterator) {
                chainedVolatile = ListenerMap.this.chained;
            }
            for (ListenerMap c : chainedVolatile) {
                T l = c.fire(this.ext);
                try {
                    method.invoke(l, args);
                }
                catch (InvocationTargetException e) {
                    Throwable cause = e.getCause();
                    ListenerMap.reportError(l, cause);
                }
                catch (Throwable e) {
                    ListenerMap.reportError(l, e);
                }
            }
            return null;
        }
    }
}

