/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcode.struct;

import ghidra.pcode.struct.AbstractStmt;
import ghidra.pcode.struct.RValInternal;
import ghidra.pcode.struct.StringTree;
import ghidra.pcode.struct.StructuredSleigh;
import ghidra.program.model.data.DataType;

class VoidExprStmt
extends AbstractStmt
implements RValInternal,
StructuredSleigh.StmtWithVal {
    private final RValInternal expr;
    private final DataType type;

    private VoidExprStmt(StructuredSleigh ctx, StructuredSleigh.RVal expr, DataType type) {
        super(ctx);
        this.expr = (RValInternal)expr;
        this.type = type;
    }

    protected VoidExprStmt(StructuredSleigh ctx, StructuredSleigh.RVal expr) {
        this(ctx, expr, expr.getType());
    }

    @Override
    public StructuredSleigh.RVal cast(DataType type) {
        return new VoidExprStmt(this.ctx, this.expr, type);
    }

    public String toString() {
        return "<VoidExpr " + this.expr + ">";
    }

    @Override
    protected StringTree generate(StructuredSleigh.Label next, StructuredSleigh.Label fall) {
        StringTree st = new StringTree();
        st.append(this.expr.generate());
        st.append(";\n");
        st.append(next.genGoto(fall));
        return st;
    }

    @Override
    public DataType getType() {
        return this.type;
    }

    @Override
    public String generate() {
        return this.ctx.nil.generate();
    }
}

