/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcode.exec;

import ghidra.pcode.exec.PairedPcodeArithmetic;
import ghidra.pcode.exec.PairedPcodeExecutorStatePiece;
import ghidra.pcode.exec.PcodeArithmetic;
import ghidra.pcode.exec.PcodeExecutorState;
import ghidra.pcode.exec.PcodeExecutorStatePiece;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.lang.Language;
import ghidra.program.model.mem.MemBuffer;
import org.apache.commons.lang3.tuple.Pair;

public class PairedPcodeExecutorState<L, R>
implements PcodeExecutorState<Pair<L, R>> {
    private final PairedPcodeExecutorStatePiece<L, L, R> piece;
    private final PcodeArithmetic<Pair<L, R>> arithmetic;

    public PairedPcodeExecutorState(PairedPcodeExecutorStatePiece<L, L, R> piece) {
        this.piece = piece;
        this.arithmetic = piece.getArithmetic();
    }

    public PairedPcodeExecutorState(PcodeExecutorState<L> left, PcodeExecutorStatePiece<L, R> right, PcodeArithmetic<Pair<L, R>> arithmetic) {
        this.piece = new PairedPcodeExecutorStatePiece<L, L, R>(left, right, left.getArithmetic(), arithmetic);
        this.arithmetic = arithmetic;
    }

    public PairedPcodeExecutorState(PcodeExecutorState<L> left, PcodeExecutorStatePiece<L, R> right) {
        this(left, right, new PairedPcodeArithmetic(left.getArithmetic(), right.getArithmetic()));
    }

    @Override
    public Language getLanguage() {
        return this.piece.getLanguage();
    }

    @Override
    public PcodeArithmetic<Pair<L, R>> getArithmetic() {
        return this.arithmetic;
    }

    @Override
    public MemBuffer getConcreteBuffer(Address address, PcodeArithmetic.Purpose purpose) {
        return this.piece.getConcreteBuffer(address, purpose);
    }

    public PcodeExecutorStatePiece<L, L> getLeft() {
        return this.piece.getLeft();
    }

    public PcodeExecutorStatePiece<L, R> getRight() {
        return this.piece.getRight();
    }

    @Override
    public void setVar(AddressSpace space, Pair<L, R> offset, int size, boolean quantize, Pair<L, R> val) {
        this.piece.setVar(space, offset.getLeft(), size, quantize, val);
    }

    @Override
    public Pair<L, R> getVar(AddressSpace space, Pair<L, R> offset, int size, boolean quantize, PcodeExecutorStatePiece.Reason reason) {
        return this.piece.getVar(space, (L)offset.getLeft(), size, quantize, reason);
    }

    @Override
    public void clear() {
        this.piece.clear();
    }
}

