/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcode.exec;

import com.google.common.collect.BoundType;
import com.google.common.collect.Range;
import com.google.common.collect.RangeSet;
import com.google.common.primitives.UnsignedLong;
import ghidra.generic.util.datastruct.SemisparseByteArray;
import ghidra.pcode.exec.PcodeExecutorStatePiece;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressRangeImpl;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.lang.Language;
import ghidra.program.model.lang.Register;
import ghidra.util.Msg;
import java.util.Arrays;
import java.util.Set;
import java.util.TreeSet;

public class BytesPcodeExecutorStateSpace<B> {
    protected final SemisparseByteArray bytes = new SemisparseByteArray();
    protected final Language language;
    protected final AddressSpace space;
    protected final B backing;

    public BytesPcodeExecutorStateSpace(Language language, AddressSpace space, B backing) {
        this.language = language;
        this.space = space;
        this.backing = backing;
    }

    public void write(long offset, byte[] val, int srcOffset, int length) {
        this.bytes.putData(offset, val, srcOffset, length);
    }

    public long lower(Range<UnsignedLong> rng) {
        return rng.lowerBoundType() == BoundType.CLOSED ? ((UnsignedLong)rng.lowerEndpoint()).longValue() : ((UnsignedLong)rng.lowerEndpoint()).longValue() + 1L;
    }

    public long upper(Range<UnsignedLong> rng) {
        return rng.upperBoundType() == BoundType.CLOSED ? ((UnsignedLong)rng.upperEndpoint()).longValue() : ((UnsignedLong)rng.upperEndpoint()).longValue() - 1L;
    }

    protected void readUninitializedFromBacking(RangeSet<UnsignedLong> uninitialized) {
    }

    protected byte[] readBytes(long offset, int size, PcodeExecutorStatePiece.Reason reason) {
        byte[] data = new byte[size];
        this.bytes.getData(offset, data);
        return data;
    }

    protected AddressRange addrRng(Range<UnsignedLong> rng) {
        Address start = this.space.getAddress(this.lower(rng));
        Address end = this.space.getAddress(this.upper(rng));
        return new AddressRangeImpl(start, end);
    }

    protected AddressSet addrSet(RangeSet<UnsignedLong> set) {
        AddressSet result = new AddressSet();
        for (Range rng : set.asRanges()) {
            result.add(this.addrRng((Range<UnsignedLong>)rng));
        }
        return result;
    }

    protected Set<Register> getRegs(AddressSetView set) {
        TreeSet<Register> regs = new TreeSet<Register>();
        for (AddressRange rng : set) {
            Register r = this.language.getRegister(rng.getMinAddress(), (int)rng.getLength());
            if (r != null) {
                regs.add(r);
                continue;
            }
            regs.addAll(Arrays.asList(this.language.getRegisters(rng.getMinAddress())));
        }
        return regs;
    }

    protected void warnAddressSet(String message, AddressSetView set) {
        Set<Register> regs = this.getRegs(set);
        if (regs.isEmpty()) {
            Msg.warn((Object)this, (Object)(message + ": " + set));
        } else {
            Msg.warn((Object)this, (Object)(message + ": " + set + " (registers " + regs + ")"));
        }
    }

    protected void warnUninit(RangeSet<UnsignedLong> uninit) {
        AddressSet uninitialized = this.addrSet(uninit);
        this.warnAddressSet("Emulator read from uninitialized state", (AddressSetView)uninitialized);
    }

    public byte[] read(long offset, int size, PcodeExecutorStatePiece.Reason reason) {
        RangeSet<UnsignedLong> stillUninit;
        if (this.backing != null) {
            this.readUninitializedFromBacking(this.bytes.getUninitialized(offset, offset + (long)size - 1L));
        }
        if (!(stillUninit = this.bytes.getUninitialized(offset, offset + (long)size - 1L)).isEmpty() && reason == PcodeExecutorStatePiece.Reason.EXECUTE) {
            this.warnUninit(stillUninit);
        }
        return this.readBytes(offset, size, reason);
    }

    public void clear() {
        this.bytes.clear();
    }
}

