/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcode.emu.unix;

import ghidra.docking.settings.Settings;
import ghidra.docking.settings.SettingsImpl;
import ghidra.pcode.emu.PcodeMachine;
import ghidra.pcode.emu.sys.AnnotatedEmuSyscallUseropLibrary;
import ghidra.pcode.emu.sys.EmuProcessExitedException;
import ghidra.pcode.emu.unix.DefaultEmuUnixFileHandle;
import ghidra.pcode.emu.unix.EmuUnixException;
import ghidra.pcode.emu.unix.EmuUnixFile;
import ghidra.pcode.emu.unix.EmuUnixFileDescriptor;
import ghidra.pcode.emu.unix.EmuUnixFileSystem;
import ghidra.pcode.emu.unix.EmuUnixUser;
import ghidra.pcode.exec.AnnotatedPcodeUseropLibrary;
import ghidra.pcode.exec.PcodeArithmetic;
import ghidra.pcode.exec.PcodeExecutionException;
import ghidra.pcode.exec.PcodeExecutor;
import ghidra.pcode.exec.PcodeExecutorState;
import ghidra.pcode.exec.PcodeExecutorStatePiece;
import ghidra.pcode.struct.StructuredSleigh;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StringDataInstance;
import ghidra.program.model.data.StringDataType;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.MemBuffer;
import java.util.HashMap;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;

public abstract class AbstractEmuUnixSyscallUseropLibrary<T>
extends AnnotatedEmuSyscallUseropLibrary<T> {
    protected final EmuUnixFileSystem<T> fs;
    protected EmuUnixUser user;
    protected final int intSize;
    protected final NavigableSet<Integer> closedFds = new TreeSet<Integer>();
    protected final Map<Integer, EmuUnixFileDescriptor<T>> descriptors = new HashMap<Integer, EmuUnixFileDescriptor<T>>();

    public AbstractEmuUnixSyscallUseropLibrary(PcodeMachine<T> machine, EmuUnixFileSystem<T> fs, Program program) {
        this(machine, fs, program, EmuUnixUser.DEFAULT_USER);
    }

    public AbstractEmuUnixSyscallUseropLibrary(PcodeMachine<T> machine, EmuUnixFileSystem<T> fs, Program program, EmuUnixUser user) {
        super(machine, program);
        this.fs = fs;
        this.user = user;
        this.intSize = program.getCompilerSpec().getDataOrganization().getIntegerSize();
    }

    protected int lowestFd() {
        Integer lowest = this.closedFds.pollFirst();
        if (lowest != null) {
            return lowest;
        }
        return this.descriptors.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int claimFd(EmuUnixFileDescriptor<T> desc) {
        Map<Integer, EmuUnixFileDescriptor<T>> map = this.descriptors;
        synchronized (map) {
            int fd = this.lowestFd();
            this.putDescriptor(fd, desc);
            return fd;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected EmuUnixFileDescriptor<T> findFd(int fd) {
        Map<Integer, EmuUnixFileDescriptor<T>> map = this.descriptors;
        synchronized (map) {
            EmuUnixFileDescriptor<T> desc = this.descriptors.get(fd);
            if (desc == null) {
                throw new EmuUnixException("Invalid descriptor: " + fd, this.getErrno(Errno.EBADF));
            }
            return desc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected EmuUnixFileDescriptor<T> releaseFd(int fd) {
        Map<Integer, EmuUnixFileDescriptor<T>> map = this.descriptors;
        synchronized (map) {
            if (this.descriptors.size() + this.closedFds.size() - 1 == fd) {
                return this.descriptors.remove(fd);
            }
            EmuUnixFileDescriptor<T> removed = this.descriptors.remove(fd);
            if (removed == null) {
                throw new EmuUnixException("Invalid descriptor: " + fd, this.getErrno(Errno.EBADF));
            }
            this.closedFds.add(fd);
            return removed;
        }
    }

    @Override
    protected AnnotatedEmuSyscallUseropLibrary.StructuredPart newStructuredPart() {
        return new UnixStructuredPart();
    }

    protected abstract Set<EmuUnixFileSystem.OpenFlag> convertFlags(int var1);

    protected EmuUnixFileDescriptor<T> createHandle(EmuUnixFile<T> file, int flags) {
        return new DefaultEmuUnixFileHandle<T>(this.machine, this.cSpec, file, this.convertFlags(flags), this.user);
    }

    protected abstract int getErrno(Errno var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EmuUnixFileDescriptor<T> putDescriptor(int fd, EmuUnixFileDescriptor<T> desc) {
        Map<Integer, EmuUnixFileDescriptor<T>> map = this.descriptors;
        synchronized (map) {
            return this.descriptors.put(fd, desc);
        }
    }

    protected abstract boolean returnErrno(PcodeExecutor<T> var1, int var2);

    @Override
    public boolean handleError(PcodeExecutor<T> executor, PcodeExecutionException err) {
        if (err instanceof EmuUnixException) {
            Integer errno = ((EmuUnixException)err).getErrno();
            if (errno == null) {
                return false;
            }
            return this.returnErrno(executor, errno);
        }
        return false;
    }

    @AnnotatedPcodeUseropLibrary.PcodeUserop
    @AnnotatedEmuSyscallUseropLibrary.EmuSyscall(value="exit")
    public T unix_exit(T status) {
        throw new EmuProcessExitedException(this.machine.getArithmetic(), status);
    }

    @AnnotatedPcodeUseropLibrary.PcodeUserop
    @AnnotatedEmuSyscallUseropLibrary.EmuSyscall(value="read")
    public T unix_read(@AnnotatedPcodeUseropLibrary.OpState PcodeExecutorState<T> state, T fd, T bufPtr, T count) {
        PcodeArithmetic<T> arithmetic = this.machine.getArithmetic();
        int ifd = (int)arithmetic.toLong(fd, PcodeArithmetic.Purpose.OTHER);
        EmuUnixFileDescriptor desc = this.findFd(ifd);
        AddressSpace space = this.machine.getLanguage().getAddressFactory().getDefaultAddressSpace();
        int size = (int)arithmetic.toLong(count, PcodeArithmetic.Purpose.OTHER);
        Object buf = arithmetic.fromConst(0L, size);
        T result = desc.read(buf);
        int iresult = (int)arithmetic.toLong(result, PcodeArithmetic.Purpose.OTHER);
        state.setVar(space, bufPtr, iresult, true, buf);
        return result;
    }

    @AnnotatedPcodeUseropLibrary.PcodeUserop
    @AnnotatedEmuSyscallUseropLibrary.EmuSyscall(value="write")
    public T unix_write(@AnnotatedPcodeUseropLibrary.OpState PcodeExecutorState<T> state, T fd, T bufPtr, T count) {
        PcodeArithmetic<T> arithmetic = this.machine.getArithmetic();
        int ifd = (int)arithmetic.toLong(fd, PcodeArithmetic.Purpose.OTHER);
        EmuUnixFileDescriptor desc = this.findFd(ifd);
        AddressSpace space = this.machine.getLanguage().getAddressFactory().getDefaultAddressSpace();
        int size = (int)arithmetic.toLong(count, PcodeArithmetic.Purpose.OTHER);
        Object buf = state.getVar(space, bufPtr, size, true, PcodeExecutorStatePiece.Reason.EXECUTE);
        return desc.write(buf);
    }

    @AnnotatedPcodeUseropLibrary.PcodeUserop
    @AnnotatedEmuSyscallUseropLibrary.EmuSyscall(value="open")
    public T unix_open(@AnnotatedPcodeUseropLibrary.OpState PcodeExecutorState<T> state, T pathnamePtr, T flags, T mode) {
        PcodeArithmetic<T> arithmetic = this.machine.getArithmetic();
        int iflags = (int)arithmetic.toLong(flags, PcodeArithmetic.Purpose.OTHER);
        int imode = (int)arithmetic.toLong(mode, PcodeArithmetic.Purpose.OTHER);
        long pathnameOff = arithmetic.toLong(pathnamePtr, PcodeArithmetic.Purpose.OTHER);
        AddressSpace space = this.machine.getLanguage().getAddressFactory().getDefaultAddressSpace();
        SettingsImpl settings = new SettingsImpl();
        MemBuffer buffer = state.getConcreteBuffer(space.getAddress(pathnameOff), PcodeArithmetic.Purpose.OTHER);
        StringDataInstance sdi = new StringDataInstance((DataType)StringDataType.dataType, (Settings)settings, buffer, -1);
        sdi = new StringDataInstance((DataType)StringDataType.dataType, (Settings)settings, buffer, sdi.getStringLength());
        String pathname = Objects.requireNonNull(sdi.getStringValue());
        EmuUnixFile<T> file = this.fs.open(pathname, this.convertFlags(iflags), this.user, imode);
        int ifd = this.claimFd(this.createHandle(file, iflags));
        return arithmetic.fromConst(ifd, this.intSize);
    }

    @AnnotatedPcodeUseropLibrary.PcodeUserop
    @AnnotatedEmuSyscallUseropLibrary.EmuSyscall(value="close")
    public T unix_close(T fd) {
        PcodeArithmetic<T> arithmetic = this.machine.getArithmetic();
        int ifd = (int)arithmetic.toLong(fd, PcodeArithmetic.Purpose.OTHER);
        EmuUnixFileDescriptor<T> desc = this.releaseFd(ifd);
        desc.close();
        return arithmetic.fromConst(0L, this.intSize);
    }

    @AnnotatedPcodeUseropLibrary.PcodeUserop
    @AnnotatedEmuSyscallUseropLibrary.EmuSyscall(value="group_exit")
    public void unix_group_exit(T status) {
        throw new EmuProcessExitedException(this.machine.getArithmetic(), status);
    }

    public static enum Errno {
        EBADF;

    }

    protected class UnixStructuredPart
    extends AnnotatedEmuSyscallUseropLibrary.StructuredPart {
        final StructuredSleigh.UseropDecl unix_read;
        final StructuredSleigh.UseropDecl unix_write;

        protected UnixStructuredPart() {
            super(AbstractEmuUnixSyscallUseropLibrary.this);
            this.unix_read = this.userop(this.type("size_t"), "unix_read", this.types("int", "void *", "size_t"));
            this.unix_write = this.userop(this.type("size_t"), "unix_write", this.types("int", "void *", "size_t"));
        }

        protected void gatherScatterIovec(StructuredSleigh.Var in_fd, StructuredSleigh.Var in_iovec, StructuredSleigh.Var in_iovcnt, StructuredSleigh.UseropDecl subOp) {
            StructuredSleigh.Var tmp_i = this.local("tmp_i", this.type("size_t"));
            StructuredSleigh.Var tmp_total = this.local("tmp_total", this.type("size_t"));
            StructuredSleigh.Var tmp_ret = this.local("tmp_ret", this.type("size_t"));
            this._for(tmp_i.set(0L), tmp_i.ltiu(in_iovcnt), tmp_i.inc(), () -> {
                StructuredSleigh.Var tmp_io = this.local("tmp_io", in_iovec.index(tmp_i));
                StructuredSleigh.Var tmp_base = this.local("tmp_base", tmp_io.field("iov_base").deref());
                StructuredSleigh.Var tmp_len = this.local("tmp_len", tmp_io.field("iov_len").deref());
                tmp_ret.set(subOp.call(in_fd, tmp_base, tmp_len));
                tmp_total.addiTo(tmp_ret);
                this._if(tmp_ret.ltiu(tmp_len), () -> this._break());
            });
            this._result(tmp_total);
        }

        @StructuredSleigh.StructuredUserop(type="size_t")
        @AnnotatedEmuSyscallUseropLibrary.EmuSyscall(value="readv")
        public void unix_readv(@StructuredSleigh.Param(type="int", name="in_fd") StructuredSleigh.Var in_fd, @StructuredSleigh.Param(type="iovec *", name="in_iovec") StructuredSleigh.Var in_iovec, @StructuredSleigh.Param(type="size_t", name="in_iovcnt") StructuredSleigh.Var in_iovcnt) {
            this.gatherScatterIovec(in_fd, in_iovec, in_iovcnt, this.unix_read);
        }

        @StructuredSleigh.StructuredUserop(type="size_t")
        @AnnotatedEmuSyscallUseropLibrary.EmuSyscall(value="writev")
        public void unix_writev(@StructuredSleigh.Param(type="int", name="in_fd") StructuredSleigh.Var in_fd, @StructuredSleigh.Param(type="iovec *", name="in_iovec") StructuredSleigh.Var in_iovec, @StructuredSleigh.Param(type="size_t", name="in_iovcnt") StructuredSleigh.Var in_iovcnt) {
            this.gatherScatterIovec(in_fd, in_iovec, in_iovcnt, this.unix_write);
        }
    }
}

