/*
 * Decompiled with CFR 0.152.
 */
package ghidra.trace.model.time.schedule;

import ghidra.pcode.emu.PcodeThread;

public interface Stepper<T> {
    public static <T> Stepper<T> instruction() {
        return Enum.INSTRUCTION;
    }

    public static <T> Stepper<T> pcode() {
        return Enum.PCODE;
    }

    public void tick(PcodeThread<T> var1);

    public void skip(PcodeThread<T> var1);

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum Enum implements Stepper
    {
        INSTRUCTION{

            public void tick(PcodeThread thread) {
                thread.stepInstruction();
            }

            public void skip(PcodeThread thread) {
                thread.skipInstruction();
            }
        }
        ,
        PCODE{

            public void tick(PcodeThread thread) {
                thread.stepPcodeOp();
            }

            public void skip(PcodeThread thread) {
                thread.skipPcodeOp();
            }
        };

    }
}

