/*
 * Decompiled with CFR 0.152.
 */
package ghidra.trace.model.map;

import com.google.common.collect.Range;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressRangeImpl;
import ghidra.program.model.address.AddressSetView;
import ghidra.trace.database.map.DBTraceAddressSnapRangePropertyMapTree;
import ghidra.trace.model.ImmutableTraceAddressSnapRange;
import ghidra.trace.model.TraceAddressSnapRange;
import ghidra.util.database.spatial.BoundedShape;
import ghidra.util.database.spatial.SpatialMap;
import java.util.function.Predicate;

public interface TraceAddressSnapRangePropertyMapOperations<T>
extends SpatialMap<TraceAddressSnapRange, T, DBTraceAddressSnapRangePropertyMapTree.TraceAddressSnapRangeQuery> {
    default public T put(Address address, Range<Long> lifespan, T value) {
        return (T)this.put((BoundedShape)new ImmutableTraceAddressSnapRange((AddressRange)new AddressRangeImpl(address, address), lifespan), value);
    }

    default public T put(Address minAddress, Address maxAddress, long minSnap, long maxSnap, T value) {
        return (T)this.put((BoundedShape)new ImmutableTraceAddressSnapRange(minAddress, maxAddress, minSnap, maxSnap), value);
    }

    default public T put(Address minAddress, Address maxAddress, long snap, T value) {
        return (T)this.put((BoundedShape)new ImmutableTraceAddressSnapRange(minAddress, maxAddress, snap, snap), value);
    }

    default public T put(AddressRange range, Range<Long> lifespan, T value) {
        return (T)this.put((BoundedShape)new ImmutableTraceAddressSnapRange(range, lifespan), value);
    }

    public AddressSetView getAddressSetView(Range<Long> var1, Predicate<T> var2);

    public AddressSetView getAddressSetView(Range<Long> var1);

    public void deleteValue(T var1);
}

