/*
 * Decompiled with CFR 0.152.
 */
package ghidra.trace.model.guest;

import ghidra.dbg.target.TargetObject;
import ghidra.dbg.target.schema.TargetObjectSchema;
import ghidra.dbg.util.PathMatcher;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressFactory;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.lang.CompilerSpec;
import ghidra.program.model.lang.InstructionSet;
import ghidra.program.model.lang.Language;
import ghidra.program.model.lang.Register;
import ghidra.program.model.mem.MemBuffer;
import ghidra.trace.model.Trace;
import ghidra.trace.model.symbol.TraceLabelSymbol;
import ghidra.trace.model.target.TraceObject;
import java.util.List;

public interface TracePlatform {
    public Trace getTrace();

    public boolean isGuest();

    default public boolean isHost() {
        return !this.isGuest();
    }

    public Language getLanguage();

    default public AddressFactory getAddressFactory() {
        return this.getLanguage().getAddressFactory();
    }

    public CompilerSpec getCompilerSpec();

    public AddressSetView getHostAddressSet();

    public AddressSetView getGuestAddressSet();

    public Address mapHostToGuest(Address var1);

    public AddressRange mapHostToGuest(AddressRange var1);

    public AddressSetView mapHostToGuest(AddressSetView var1);

    public Address mapGuestToHost(Address var1);

    public AddressRange mapGuestToHost(AddressRange var1);

    public AddressSetView mapGuestToHost(AddressSetView var1);

    public AddressRange getConventionalRegisterRange(AddressSpace var1, Register var2);

    public String getConventionalRegisterObjectName(Register var1);

    public PathMatcher getConventionalRegisterPath(TargetObjectSchema var1, List<String> var2, Register var3);

    public PathMatcher getConventionalRegisterPath(TraceObject var1, Register var2);

    public PathMatcher getConventionalRegisterPath(TargetObject var1, Register var2);

    public PathMatcher getConventionalRegisterPath(AddressSpace var1, Register var2);

    public TraceLabelSymbol addRegisterMapOverride(Register var1, String var2);

    public MemBuffer getMappedMemBuffer(long var1, Address var3);

    public InstructionSet mapGuestInstructionAddressesToHost(InstructionSet var1);
}

