/*
 * Decompiled with CFR 0.152.
 */
package ghidra.trace.model;

import com.google.common.collect.Range;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressFactory;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.data.Category;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeManagerDomainObject;
import ghidra.program.model.data.DataTypePath;
import ghidra.program.model.lang.CompilerSpec;
import ghidra.program.model.lang.Language;
import ghidra.program.model.listing.FlowOverride;
import ghidra.program.model.listing.FunctionTag;
import ghidra.program.model.listing.ProgramFragment;
import ghidra.program.model.symbol.SourceType;
import ghidra.trace.model.TraceAddressSnapRange;
import ghidra.trace.model.TraceTimeViewport;
import ghidra.trace.model.bookmark.TraceBookmark;
import ghidra.trace.model.bookmark.TraceBookmarkManager;
import ghidra.trace.model.bookmark.TraceBookmarkType;
import ghidra.trace.model.breakpoint.TraceBreakpoint;
import ghidra.trace.model.breakpoint.TraceBreakpointManager;
import ghidra.trace.model.context.TraceRegisterContextManager;
import ghidra.trace.model.data.TraceBasedDataTypeManager;
import ghidra.trace.model.guest.TraceGuestPlatform;
import ghidra.trace.model.guest.TraceGuestPlatformMappedRange;
import ghidra.trace.model.guest.TracePlatformManager;
import ghidra.trace.model.listing.TraceCodeManager;
import ghidra.trace.model.listing.TraceCodeUnit;
import ghidra.trace.model.listing.TraceData;
import ghidra.trace.model.listing.TraceInstruction;
import ghidra.trace.model.memory.TraceMemoryManager;
import ghidra.trace.model.memory.TraceMemoryRegion;
import ghidra.trace.model.memory.TraceMemoryState;
import ghidra.trace.model.modules.TraceModule;
import ghidra.trace.model.modules.TraceModuleManager;
import ghidra.trace.model.modules.TraceSection;
import ghidra.trace.model.modules.TraceStaticMapping;
import ghidra.trace.model.modules.TraceStaticMappingManager;
import ghidra.trace.model.program.TraceProgramView;
import ghidra.trace.model.program.TraceVariableSnapProgramView;
import ghidra.trace.model.property.TraceAddressPropertyManager;
import ghidra.trace.model.stack.TraceStack;
import ghidra.trace.model.stack.TraceStackManager;
import ghidra.trace.model.symbol.TraceEquateManager;
import ghidra.trace.model.symbol.TraceFunctionSymbol;
import ghidra.trace.model.symbol.TraceNamespaceSymbol;
import ghidra.trace.model.symbol.TraceReference;
import ghidra.trace.model.symbol.TraceReferenceManager;
import ghidra.trace.model.symbol.TraceSymbol;
import ghidra.trace.model.symbol.TraceSymbolManager;
import ghidra.trace.model.symbol.TraceSymbolWithLifespan;
import ghidra.trace.model.target.TraceObject;
import ghidra.trace.model.target.TraceObjectManager;
import ghidra.trace.model.target.TraceObjectValue;
import ghidra.trace.model.thread.TraceThread;
import ghidra.trace.model.thread.TraceThreadManager;
import ghidra.trace.model.time.TraceSnapshot;
import ghidra.trace.model.time.TraceTimeManager;
import ghidra.trace.util.DefaultTraceChangeType;
import ghidra.util.LockHold;
import ghidra.util.UniversalID;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.swing.ImageIcon;
import resources.ResourceManager;

public interface Trace
extends DataTypeManagerDomainObject {
    public static final ImageIcon TRACE_ICON = ResourceManager.loadImage((String)"images/video-x-generic16.png");

    public Language getBaseLanguage();

    public CompilerSpec getBaseCompilerSpec();

    public AddressFactory getBaseAddressFactory();

    public TraceAddressPropertyManager getAddressPropertyManager();

    public TraceBookmarkManager getBookmarkManager();

    public TraceBreakpointManager getBreakpointManager();

    public TraceCodeManager getCodeManager();

    public TraceBasedDataTypeManager getDataTypeManager();

    public TraceEquateManager getEquateManager();

    public TracePlatformManager getPlatformManager();

    public TraceMemoryManager getMemoryManager();

    public TraceModuleManager getModuleManager();

    public TraceObjectManager getObjectManager();

    public TraceReferenceManager getReferenceManager();

    public TraceRegisterContextManager getRegisterContextManager();

    public TraceStackManager getStackManager();

    public TraceStaticMappingManager getStaticMappingManager();

    public TraceSymbolManager getSymbolManager();

    public TraceThreadManager getThreadManager();

    public TraceTimeManager getTimeManager();

    public TraceProgramView getFixedProgramView(long var1);

    public TraceVariableSnapProgramView createProgramView(long var1);

    public Collection<TraceProgramView> getAllProgramViews();

    public TraceVariableSnapProgramView getProgramView();

    public TraceTimeViewport createTimeViewport();

    public void addProgramViewListener(TraceProgramViewListener var1);

    public void removeProgramViewListener(TraceProgramViewListener var1);

    public LockHold lockRead();

    public LockHold lockWrite();

    public static interface TraceProgramViewListener {
        public void viewCreated(TraceProgramView var1);
    }

    public static final class TracePlatformChangeType<U>
    extends DefaultTraceChangeType<TraceGuestPlatform, U> {
        public static final TracePlatformChangeType<Void> ADDED = new TracePlatformChangeType();
        public static final TracePlatformChangeType<Void> DELETED = new TracePlatformChangeType();
        public static final TracePlatformChangeType<TraceGuestPlatformMappedRange> MAPPING_ADDED = new TracePlatformChangeType();
        public static final TracePlatformChangeType<TraceGuestPlatformMappedRange> MAPPING_DELETED = new TracePlatformChangeType();
    }

    public static final class TraceSnapshotChangeType<U>
    extends DefaultTraceChangeType<TraceSnapshot, U> {
        public static final TraceSnapshotChangeType<Void> ADDED = new TraceSnapshotChangeType();
        public static final TraceSnapshotChangeType<Void> CHANGED = new TraceSnapshotChangeType();
        public static final TraceSnapshotChangeType<Void> DELETED = new TraceSnapshotChangeType();
    }

    public static final class TraceThreadChangeType<U>
    extends DefaultTraceChangeType<TraceThread, U> {
        public static final TraceThreadChangeType<Void> ADDED = new TraceThreadChangeType();
        public static final TraceThreadChangeType<Void> CHANGED = new TraceThreadChangeType();
        public static final TraceThreadChangeType<Range<Long>> LIFESPAN_CHANGED = new TraceThreadChangeType();
        public static final TraceThreadChangeType<Void> DELETED = new TraceThreadChangeType();
    }

    public static final class TraceSymbolChangeType<U>
    extends DefaultTraceChangeType<TraceSymbol, U> {
        public static final TraceSymbolChangeType<Void> ADDED = new TraceSymbolChangeType();
        public static final TraceSymbolChangeType<SourceType> SOURCE_CHANGED = new TraceSymbolChangeType();
        public static final TraceSymbolChangeType<TraceSymbol> SET_AS_PRIMARY = new TraceSymbolChangeType();
        public static final TraceSymbolChangeType<String> RENAMED = new TraceSymbolChangeType();
        public static final TraceSymbolChangeType<TraceNamespaceSymbol> PARENT_CHANGED = new TraceSymbolChangeType();
        public static final TraceSymbolChangeType<TraceReference> ASSOCIATION_ADDED = new TraceSymbolChangeType();
        public static final TraceSymbolChangeType<TraceReference> ASSOCIATION_REMOVED = new TraceSymbolChangeType();
        public static final TraceSymbolChangeType<Address> ADDRESS_CHANGED = new TraceSymbolChangeType();
        public static final DefaultTraceChangeType<TraceSymbolWithLifespan, Range<Long>> LIFESPAN_CHANGED = new DefaultTraceChangeType();
        public static final TraceSymbolChangeType<Void> DELETED = new TraceSymbolChangeType();
        public static final TraceSymbolChangeType<Void> CHANGED = new TraceSymbolChangeType();
    }

    public static final class TraceSourceArchiveChangeType<U>
    extends DefaultTraceChangeType<UniversalID, U> {
        public static final TraceSourceArchiveChangeType<Void> ADDED = new TraceSourceArchiveChangeType();
        public static final TraceSourceArchiveChangeType<Void> CHANGED = new TraceSourceArchiveChangeType();
        public static final TraceSourceArchiveChangeType<Void> DELETED = new TraceSourceArchiveChangeType();
    }

    public static final class TraceStaticMappingChangeType<U>
    extends DefaultTraceChangeType<TraceStaticMapping, U> {
        public static final TraceStaticMappingChangeType<Void> ADDED = new TraceStaticMappingChangeType();
        public static final TraceStaticMappingChangeType<Void> DELETED = new TraceStaticMappingChangeType();
    }

    public static final class TraceStackChangeType<U>
    extends DefaultTraceChangeType<TraceStack, U> {
        public static final TraceStackChangeType<Void> ADDED = new TraceStackChangeType();
        public static final TraceStackChangeType<Long> CHANGED = new TraceStackChangeType();
        public static final TraceStackChangeType<Void> DELETED = new TraceStackChangeType();
    }

    public static final class TraceSectionChangeType<U>
    extends DefaultTraceChangeType<TraceSection, U> {
        public static final TraceSectionChangeType<Void> ADDED = new TraceSectionChangeType();
        public static final TraceSectionChangeType<Void> CHANGED = new TraceSectionChangeType();
        public static final TraceSectionChangeType<Void> DELETED = new TraceSectionChangeType();
    }

    public static final class TraceReferenceChangeType<T, U>
    extends DefaultTraceChangeType<T, U> {
        public static final TraceReferenceChangeType<TraceAddressSnapRange, TraceReference> ADDED = new TraceReferenceChangeType();
        public static final TraceReferenceChangeType<TraceReference, Range<Long>> LIFESPAN_CHANGED = new TraceReferenceChangeType();
        public static final TraceReferenceChangeType<TraceReference, Boolean> PRIMARY_CHANGED = new TraceReferenceChangeType();
        public static final TraceReferenceChangeType<TraceAddressSnapRange, TraceReference> DELETED = new TraceReferenceChangeType();
    }

    public static final class TraceModuleChangeType<U>
    extends DefaultTraceChangeType<TraceModule, U> {
        public static final TraceModuleChangeType<Void> ADDED = new TraceModuleChangeType();
        public static final TraceModuleChangeType<Void> CHANGED = new TraceModuleChangeType();
        public static final TraceModuleChangeType<Range<Long>> LIFESPAN_CHANGED = new TraceModuleChangeType();
        public static final TraceModuleChangeType<Void> DELETED = new TraceModuleChangeType();
    }

    public static final class TraceMemoryStateChangeType<U>
    extends DefaultTraceChangeType<TraceAddressSnapRange, U> {
        public static final TraceMemoryStateChangeType<TraceMemoryState> CHANGED = new TraceMemoryStateChangeType();
    }

    public static final class TraceOverlaySpaceChangeType
    extends DefaultTraceChangeType<Trace, AddressSpace> {
        public static final TraceOverlaySpaceChangeType ADDED = new TraceOverlaySpaceChangeType();
        public static final TraceOverlaySpaceChangeType DELETED = new TraceOverlaySpaceChangeType();
    }

    public static final class TraceMemoryRegionChangeType<U>
    extends DefaultTraceChangeType<TraceMemoryRegion, U> {
        public static final TraceMemoryRegionChangeType<Void> ADDED = new TraceMemoryRegionChangeType();
        public static final TraceMemoryRegionChangeType<Void> CHANGED = new TraceMemoryRegionChangeType();
        public static final TraceMemoryRegionChangeType<Range<Long>> LIFESPAN_CHANGED = new TraceMemoryRegionChangeType();
        public static final TraceMemoryRegionChangeType<Void> DELETED = new TraceMemoryRegionChangeType();
    }

    public static final class TraceMemoryBytesChangeType
    extends DefaultTraceChangeType<TraceAddressSnapRange, byte[]> {
        public static final TraceMemoryBytesChangeType CHANGED = new TraceMemoryBytesChangeType();
    }

    public static final class TraceInstructionChangeType<U>
    extends DefaultTraceChangeType<TraceInstruction, U> {
        public static final TraceInstructionChangeType<FlowOverride> FLOW_OVERRIDE_CHANGED = new TraceInstructionChangeType();
        public static final TraceInstructionChangeType<Boolean> FALL_THROUGH_OVERRIDE_CHANGED = new TraceInstructionChangeType();
    }

    public static final class TraceFunctionTagChangeType<U>
    extends DefaultTraceChangeType<FunctionTag, U> {
        public static final TraceFunctionTagChangeType<Void> ADDED = new TraceFunctionTagChangeType();
        public static final TraceFunctionTagChangeType<Void> CHANGED = new TraceFunctionTagChangeType();
        public static final TraceFunctionTagChangeType<Void> DELETED = new TraceFunctionTagChangeType();
    }

    public static final class TraceFunctionChangeType<U>
    extends DefaultTraceChangeType<TraceFunctionSymbol, U> {
        public static final TraceFunctionChangeType<Void> CHANGED = new TraceFunctionChangeType();
        public static final TraceFunctionChangeType<Integer> CHANGED_PURGE = new TraceFunctionChangeType();
        public static final TraceFunctionChangeType<Boolean> CHANGED_INLINE = new TraceFunctionChangeType();
        public static final TraceFunctionChangeType<Boolean> CHANGED_NORETURN = new TraceFunctionChangeType();
        public static final TraceFunctionChangeType<String> CHANGED_CALL_FIXUP = new TraceFunctionChangeType();
        public static final TraceFunctionChangeType<Void> CHANGED_RETURN = new TraceFunctionChangeType();
        public static final TraceFunctionChangeType<Void> CHANGED_PARAMETERS = new TraceFunctionChangeType();
        public static final TraceFunctionChangeType<TraceFunctionSymbol> CHANGED_THUNK = new TraceFunctionChangeType();
        public static final TraceFunctionChangeType<AddressSetView> CHANGED_BODY = new TraceFunctionChangeType();
        public static final TraceFunctionChangeType<FunctionTag> TAG_APPLIED = new TraceFunctionChangeType();
        public static final TraceFunctionChangeType<FunctionTag> TAG_REMOVED = new TraceFunctionChangeType();
    }

    public static final class TraceDataTypeChangeType<U>
    extends DefaultTraceChangeType<Long, U> {
        public static final TraceDataTypeChangeType<DataType> ADDED = new TraceDataTypeChangeType();
        public static final TraceDataTypeChangeType<DataType> CHANGED = new TraceDataTypeChangeType();
        public static final TraceDataTypeChangeType<DataTypePath> REPLACED = new TraceDataTypeChangeType();
        public static final TraceDataTypeChangeType<DataTypePath> MOVED = new TraceDataTypeChangeType();
        public static final TraceDataTypeChangeType<String> RENAMED = new TraceDataTypeChangeType();
        public static final TraceDataTypeChangeType<DataTypePath> DELETED = new TraceDataTypeChangeType();
    }

    public static final class TraceCompositeDataChangeType<T, U>
    extends DefaultTraceChangeType<T, U> {
        public static final TraceCompositeDataChangeType<TraceAddressSnapRange, TraceData> ADDED = new TraceCompositeDataChangeType();
        public static final TraceCompositeDataChangeType<TraceData, Range<Long>> LIFESPAN_CHANGED = new TraceCompositeDataChangeType();
        public static final TraceCompositeDataChangeType<TraceAddressSnapRange, TraceData> REMOVED = new TraceCompositeDataChangeType();
    }

    public static final class TraceCommentChangeType
    extends DefaultTraceChangeType<TraceAddressSnapRange, String> {
        private static final Map<Integer, TraceCommentChangeType> BY_TYPE = new HashMap<Integer, TraceCommentChangeType>();
        public static final TraceCommentChangeType PLATE_CHANGED = new TraceCommentChangeType(3);
        public static final TraceCommentChangeType PRE_CHANGED = new TraceCommentChangeType(1);
        public static final TraceCommentChangeType POST_CHANGED = new TraceCommentChangeType(2);
        public static final TraceCommentChangeType EOL_CHANGED = new TraceCommentChangeType(0);
        public static final TraceCommentChangeType REPEATABLE_CHANGED = new TraceCommentChangeType(4);
        public final int type;

        public static TraceCommentChangeType byType(int type) {
            return Objects.requireNonNull(BY_TYPE.get(type));
        }

        private TraceCommentChangeType(int type) {
            this.type = type;
            BY_TYPE.put(type, this);
        }
    }

    public static final class TraceCodeChangeType<T, U>
    extends DefaultTraceChangeType<T, U> {
        public static final TraceCodeChangeType<TraceAddressSnapRange, TraceCodeUnit> ADDED = new TraceCodeChangeType();
        public static final TraceCodeChangeType<TraceCodeUnit, Range<Long>> LIFESPAN_CHANGED = new TraceCodeChangeType();
        public static final TraceCodeChangeType<TraceAddressSnapRange, TraceCodeUnit> REMOVED = new TraceCodeChangeType();
        public static final TraceCodeChangeType<TraceAddressSnapRange, ProgramFragment> FRAGMENT_CHANGED = new TraceCodeChangeType();
        public static final TraceCodeChangeType<TraceAddressSnapRange, Long> DATA_TYPE_REPLACED = new TraceCodeChangeType();
        public static final TraceCodeChangeType<TraceAddressSnapRange, Void> DATA_TYPE_SETTINGS_CHANGED = new TraceCodeChangeType();
    }

    public static final class TraceCategoryChangeType<U>
    extends DefaultTraceChangeType<Long, U> {
        public static final TraceCategoryChangeType<Category> ADDED = new TraceCategoryChangeType();
        public static final TraceCategoryChangeType<CategoryPath> MOVED = new TraceCategoryChangeType();
        public static final TraceCategoryChangeType<String> RENAMED = new TraceCategoryChangeType();
        public static final TraceCategoryChangeType<CategoryPath> DELETED = new TraceCategoryChangeType();
    }

    public static final class TraceBreakpointChangeType<U>
    extends DefaultTraceChangeType<TraceBreakpoint, U> {
        public static final TraceBreakpointChangeType<Void> ADDED = new TraceBreakpointChangeType();
        public static final TraceBreakpointChangeType<Void> CHANGED = new TraceBreakpointChangeType();
        public static final TraceBreakpointChangeType<Range<Long>> LIFESPAN_CHANGED = new TraceBreakpointChangeType();
        public static final TraceBreakpointChangeType<Void> DELETED = new TraceBreakpointChangeType();
    }

    public static final class TraceBookmarkChangeType<T, U>
    extends DefaultTraceChangeType<T, U> {
        public static final TraceBookmarkChangeType<TraceBookmarkType, Void> TYPE_ADDED = new TraceBookmarkChangeType();
        public static final TraceBookmarkChangeType<TraceBookmark, Void> ADDED = new TraceBookmarkChangeType();
        public static final TraceBookmarkChangeType<TraceBookmark, Void> CHANGED = new TraceBookmarkChangeType();
        public static final TraceBookmarkChangeType<TraceBookmark, Range<Long>> LIFESPAN_CHANGED = new TraceBookmarkChangeType();
        public static final TraceBookmarkChangeType<TraceBookmark, Void> DELETED = new TraceBookmarkChangeType();
    }

    public static final class TraceObjectChangeType<T, U>
    extends DefaultTraceChangeType<T, U> {
        public static final TraceObjectChangeType<TraceObject, Void> CREATED = new TraceObjectChangeType();
        public static final TraceObjectChangeType<TraceObject, Void> LIFE_CHANGED = new TraceObjectChangeType();
        public static final TraceObjectChangeType<TraceObject, Void> DELETED = new TraceObjectChangeType();
        public static final TraceObjectChangeType<TraceObjectValue, Void> VALUE_CREATED = new TraceObjectChangeType();
        public static final TraceObjectChangeType<TraceObjectValue, Range<Long>> VALUE_LIFESPAN_CHANGED = new TraceObjectChangeType();
        public static final TraceObjectChangeType<TraceObjectValue, Void> VALUE_DELETED = new TraceObjectChangeType();
    }
}

