/*
 * Decompiled with CFR 0.152.
 */
package ghidra.trace.database.target.visitors;

import com.google.common.collect.Range;
import ghidra.dbg.util.PathPattern;
import ghidra.dbg.util.PathPredicates;
import ghidra.trace.database.target.visitors.TreeTraversal;
import ghidra.trace.model.target.TraceObject;
import ghidra.trace.model.target.TraceObjectKeyPath;
import ghidra.trace.model.target.TraceObjectValPath;
import ghidra.trace.model.target.TraceObjectValue;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;

public class OrderedSuccessorsVisitor
implements TreeTraversal.SpanIntersectingVisitor {
    protected final PathPredicates predicates;
    protected final boolean forward;

    public OrderedSuccessorsVisitor(TraceObjectKeyPath path, boolean forward) {
        this.predicates = new PathPattern(path.getKeyList());
        this.forward = forward;
    }

    @Override
    public TraceObjectValPath composePath(TraceObjectValPath pre, TraceObjectValue value) {
        return pre == null ? TraceObjectValPath.of() : pre.append(value);
    }

    @Override
    public TreeTraversal.VisitResult visitValue(TraceObjectValue value, TraceObjectValPath path) {
        List<String> keyList = path.getKeyList();
        if (this.predicates.matches(keyList)) {
            return TreeTraversal.VisitResult.INCLUDE_PRUNE;
        }
        if (!value.isObject() || !this.predicates.successorCouldMatch(keyList, true)) {
            return TreeTraversal.VisitResult.EXCLUDE_PRUNE;
        }
        return TreeTraversal.VisitResult.EXCLUDE_DESCEND;
    }

    @Override
    public TraceObject continueObject(TraceObjectValue value) {
        return value.isObject() ? value.getChild() : null;
    }

    @Override
    public Stream<? extends TraceObjectValue> continueValues(TraceObject object, Range<Long> span, TraceObjectValPath path) {
        Set nextKeys = this.predicates.getNextKeys(path.getKeyList());
        if (nextKeys.isEmpty()) {
            return Stream.empty();
        }
        if (nextKeys.size() != 1) {
            throw new IllegalArgumentException("predicates must be a singleton");
        }
        String next = (String)nextKeys.iterator().next();
        if (PathPattern.isWildcard((String)next)) {
            throw new IllegalArgumentException("predicates must be a singleton");
        }
        return object.getOrderedValues(span, next, this.forward);
    }
}

