/*
 * Decompiled with CFR 0.152.
 */
package ghidra.trace.database.target;

import com.google.common.collect.Range;
import com.google.common.collect.RangeSet;
import com.google.common.collect.TreeRangeSet;
import ghidra.trace.database.DBTraceUtils;
import ghidra.trace.database.target.DBTraceObject;
import ghidra.trace.database.target.DBTraceObjectAddressRangeValue;
import ghidra.trace.model.Trace;
import ghidra.trace.model.TraceUniqueObject;
import ghidra.trace.model.target.TraceObject;
import ghidra.trace.model.target.TraceObjectInterface;
import ghidra.trace.model.target.TraceObjectValue;
import ghidra.trace.util.TraceAddressSpace;
import ghidra.trace.util.TraceChangeRecord;
import ghidra.trace.util.TraceChangeType;
import ghidra.util.database.ObjectKey;

public interface DBTraceObjectInterface
extends TraceObjectInterface,
TraceUniqueObject {
    public TraceChangeRecord<?, ?> translateEvent(TraceChangeRecord<?, ?> var1);

    public static TraceAddressSpace spaceForValue(TraceObject object, long snap, String key) {
        TraceObjectValue val = object.getAttribute(snap, key);
        if (val instanceof DBTraceObjectAddressRangeValue) {
            DBTraceObjectAddressRangeValue addrVal = (DBTraceObjectAddressRangeValue)val;
            return addrVal.getTraceAddressSpace();
        }
        return null;
    }

    default public TraceAddressSpace spaceForValue(long snap, String key) {
        return DBTraceObjectInterface.spaceForValue(this.getObject(), snap, key);
    }

    @Override
    default public ObjectKey getObjectKey() {
        return this.getObject().getObjectKey();
    }

    @Override
    default public boolean isDeleted() {
        return this.getObject().getLife().isEmpty();
    }

    public static abstract class Translator<T> {
        private final String spaceValueKey;
        private final DBTraceObject object;
        private final T iface;
        private RangeSet<Long> life = TreeRangeSet.create();

        public Translator(String spaceValueKey, DBTraceObject object, T iface) {
            this.spaceValueKey = spaceValueKey;
            this.object = object;
            this.iface = iface;
        }

        protected abstract TraceChangeType<T, Void> getAddedType();

        protected abstract TraceChangeType<T, Range<Long>> getLifespanChangedType();

        protected abstract TraceChangeType<T, ?> getChangedType();

        protected abstract boolean appliesToKey(String var1);

        protected abstract TraceChangeType<T, Void> getDeletedType();

        protected void emitExtraAdded() {
        }

        protected void emitExtraLifespanChanged(Range<Long> oldLifespan, Range<Long> newLifespan) {
        }

        protected void emitExtraValueChanged(Range<Long> lifespan, String key, Object oldValue, Object newValue) {
        }

        protected void emitExtraDeleted() {
        }

        protected TraceAddressSpace getSpace(RangeSet<Long> life) {
            if (life.isEmpty()) {
                return null;
            }
            return this.spaceValueKey == null ? null : DBTraceObjectInterface.spaceForValue(this.object, DBTraceUtils.lowerEndpoint((Range<Long>)life.span()), this.spaceValueKey);
        }

        protected TraceChangeRecord<?, ?> translateAdded() {
            TraceChangeType<T, Void> type = this.getAddedType();
            if (type == null) {
                return null;
            }
            this.emitExtraAdded();
            return new TraceChangeRecord<T, Object>(type, this.getSpace(this.life), this.iface, null, null);
        }

        protected TraceChangeRecord<?, ?> translateLifespanChanged(RangeSet<Long> oldLife) {
            TraceChangeType<T, Range<Long>> type = this.getLifespanChangedType();
            if (type == null) {
                return null;
            }
            Range oldLifespan = oldLife.span();
            Range newLifespan = this.life.span();
            this.emitExtraLifespanChanged((Range<Long>)oldLifespan, (Range<Long>)newLifespan);
            return new TraceChangeRecord<T, Range>(type, this.getSpace(this.life), this.iface, oldLifespan, newLifespan);
        }

        protected TraceChangeRecord<?, ?> translateDeleted(RangeSet<Long> life) {
            TraceChangeType<T, Void> type = this.getDeletedType();
            if (type == null) {
                return null;
            }
            this.emitExtraDeleted();
            return new TraceChangeRecord<T, Object>(type, this.getSpace(life), this.iface, null, null);
        }

        public TraceChangeRecord<?, ?> translate(TraceChangeRecord<?, ?> rec) {
            if (rec.getEventType() == Trace.TraceObjectChangeType.LIFE_CHANGED.getType()) {
                boolean newHasLife;
                if (this.object.isDeleted()) {
                    return null;
                }
                assert (rec.getAffectedObject() == this.object);
                RangeSet<Long> oldLife = this.life;
                this.life = this.object.getLife();
                boolean oldHasLife = !oldLife.isEmpty();
                boolean bl = newHasLife = !this.life.isEmpty();
                if (newHasLife && oldHasLife) {
                    return this.translateLifespanChanged(oldLife);
                }
                if (newHasLife) {
                    return this.translateAdded();
                }
                if (oldHasLife) {
                    return this.translateDeleted(oldLife);
                }
                throw new AssertionError((Object)"Life changed from empty to empty?");
            }
            if (rec.getEventType() == Trace.TraceObjectChangeType.VALUE_CREATED.getType()) {
                if (this.object.isDeleted()) {
                    return null;
                }
                TraceChangeType<T, ?> type = this.getChangedType();
                if (type == null) {
                    return null;
                }
                TraceChangeRecord cast = Trace.TraceObjectChangeType.VALUE_CREATED.cast(rec);
                TraceObjectValue affected = (TraceObjectValue)cast.getAffectedObject();
                String key = affected.getEntryKey();
                if (!this.appliesToKey(key)) {
                    return null;
                }
                assert (affected.getParent() == this.object);
                if (this.object.getCanonicalParent(affected.getMaxSnap()) == null) {
                    return null;
                }
                this.emitExtraValueChanged(affected.getLifespan(), key, cast.getOldValue(), cast.getNewValue());
                return new TraceChangeRecord<T, Object>(type, this.getSpace(this.life), this.iface, null, null);
            }
            if (rec.getEventType() == Trace.TraceObjectChangeType.DELETED.getType()) {
                return this.translateDeleted(this.life);
            }
            return null;
        }
    }
}

