/*
 * Decompiled with CFR 0.152.
 */
package ghidra.trace.database.symbol;

import com.google.common.collect.Collections2;
import com.google.common.collect.Range;
import db.DBHandle;
import db.DBRecord;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressRangeImpl;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.lang.Language;
import ghidra.program.model.lang.Register;
import ghidra.program.model.symbol.OffsetReference;
import ghidra.program.model.symbol.RefType;
import ghidra.program.model.symbol.Reference;
import ghidra.program.model.symbol.ShiftedReference;
import ghidra.program.model.symbol.SourceType;
import ghidra.trace.database.DBTrace;
import ghidra.trace.database.DBTraceUtils;
import ghidra.trace.database.address.DBTraceOverlaySpaceAdapter;
import ghidra.trace.database.map.DBTraceAddressSnapRangePropertyMapAddressSetView;
import ghidra.trace.database.map.DBTraceAddressSnapRangePropertyMapSpace;
import ghidra.trace.database.map.DBTraceAddressSnapRangePropertyMapTree;
import ghidra.trace.database.space.AbstractDBTraceSpaceBasedManager;
import ghidra.trace.database.space.DBTraceSpaceBased;
import ghidra.trace.database.symbol.AbstractDBTraceSymbol;
import ghidra.trace.database.symbol.DBTraceOffsetReference;
import ghidra.trace.database.symbol.DBTraceReference;
import ghidra.trace.database.symbol.DBTraceReferenceManager;
import ghidra.trace.database.symbol.DBTraceShiftedReference;
import ghidra.trace.database.symbol.DBTraceStackReference;
import ghidra.trace.model.Trace;
import ghidra.trace.model.memory.TraceMemoryRegion;
import ghidra.trace.model.symbol.TraceReference;
import ghidra.trace.model.symbol.TraceReferenceSpace;
import ghidra.trace.model.thread.TraceThread;
import ghidra.trace.util.TraceChangeRecord;
import ghidra.util.LockHold;
import ghidra.util.Msg;
import ghidra.util.database.DBCachedObjectIndex;
import ghidra.util.database.DBCachedObjectStore;
import ghidra.util.database.DBCachedObjectStoreFactory;
import ghidra.util.database.DBObjectColumn;
import ghidra.util.database.annot.DBAnnotatedColumn;
import ghidra.util.database.annot.DBAnnotatedField;
import ghidra.util.database.annot.DBAnnotatedObjectInfo;
import ghidra.util.exception.VersionException;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;

public class DBTraceReferenceSpace
implements DBTraceSpaceBased,
TraceReferenceSpace {
    protected final DBTraceReferenceManager manager;
    protected final DBHandle dbh;
    protected final AddressSpace space;
    protected final TraceThread thread;
    protected final int frameLevel;
    protected final ReadWriteLock lock;
    protected final Language baseLanguage;
    protected final DBTrace trace;
    protected final AddressRangeImpl fullSpace;
    protected final DBTraceAddressSnapRangePropertyMapSpace<DBTraceReferenceEntry, DBTraceReferenceEntry> referenceMapSpace;
    protected final DBCachedObjectIndex<Long, DBTraceReferenceEntry> refsBySymbolId;
    protected final DBTraceAddressSnapRangePropertyMapSpace<DBTraceXRefEntry, DBTraceXRefEntry> xrefMapSpace;
    protected final DBCachedObjectIndex<Long, DBTraceXRefEntry> xrefsByRefKey;

    public DBTraceReferenceSpace(DBTraceReferenceManager manager, DBHandle dbh, AddressSpace space, AbstractDBTraceSpaceBasedManager.DBTraceSpaceEntry ent, TraceThread thread) throws VersionException, IOException {
        this.manager = manager;
        this.dbh = dbh;
        this.space = space;
        this.thread = thread;
        this.frameLevel = ent.getFrameLevel();
        this.lock = manager.getLock();
        this.baseLanguage = manager.getBaseLanguage();
        this.trace = manager.getTrace();
        this.fullSpace = new AddressRangeImpl(space.getMinAddress(), space.getMaxAddress());
        DBCachedObjectStoreFactory factory = this.trace.getStoreFactory();
        long threadKey = ent.getThreadKey();
        int frameLevel = ent.getFrameLevel();
        this.referenceMapSpace = new DBTraceAddressSnapRangePropertyMapSpace(DBTraceReferenceEntry.tableName(space, threadKey, frameLevel), factory, this.lock, space, thread, frameLevel, DBTraceReferenceEntry.class, (t, s, r) -> new DBTraceReferenceEntry(this, t, s, r));
        this.refsBySymbolId = this.referenceMapSpace.getUserIndex(Long.TYPE, DBTraceReferenceEntry.SYMBOL_ID_COLUMN);
        this.xrefMapSpace = new DBTraceAddressSnapRangePropertyMapSpace(DBTraceXRefEntry.tableName(space, threadKey, frameLevel), factory, this.lock, space, thread, frameLevel, DBTraceXRefEntry.class, (t, s, r) -> new DBTraceXRefEntry(this, t, s, r));
        this.xrefsByRefKey = this.xrefMapSpace.getUserIndex(Long.TYPE, DBTraceXRefEntry.REF_KEY_COLUMN);
    }

    protected void doAddXRef(DBTraceReferenceEntry refEnt) {
        DBTraceXRefEntry xrefEnt = (DBTraceXRefEntry)this.xrefMapSpace.put(refEnt.toAddress, refEnt.getLifespan(), null);
        xrefEnt.set((short)refEnt.getRange().getAddressSpace().getSpaceID(), refEnt.getKey());
    }

    protected void doDelXRef(DBTraceReferenceEntry refEnt) {
        for (DBTraceXRefEntry xrefEnt : this.xrefsByRefKey.get((Object)refEnt.getKey())) {
            if (xrefEnt.refSpaceId != refEnt.getRange().getAddressSpace().getSpaceID()) continue;
            this.xrefMapSpace.deleteData(xrefEnt);
            return;
        }
        throw new AssertionError();
    }

    protected void doSetXRefLifespan(DBTraceReferenceEntry refEnt) {
        for (DBTraceXRefEntry xrefEnt : this.xrefsByRefKey.get((Object)refEnt.getKey())) {
            if (xrefEnt.refSpaceId != refEnt.getRange().getAddressSpace().getSpaceID()) continue;
            xrefEnt.setLifespan(refEnt.getLifespan());
            return;
        }
        throw new AssertionError();
    }

    @Override
    public AddressSpace getAddressSpace() {
        return this.space;
    }

    @Override
    public TraceThread getThread() {
        return this.thread;
    }

    @Override
    public int getFrameLevel() {
        return this.frameLevel;
    }

    @Override
    public DBTraceReference addReference(TraceReference reference) {
        return this.addReference((Range)reference.getLifespan(), (Reference)reference);
    }

    @Override
    public DBTraceReference addReference(Range<Long> lifespan, Reference reference) {
        if (reference.isOffsetReference()) {
            OffsetReference oRef = (OffsetReference)reference;
            return this.addOffsetReference((Range)lifespan, oRef.getFromAddress(), oRef.getBaseAddress(), true, oRef.getOffset(), oRef.getReferenceType(), oRef.getSource(), oRef.getOperandIndex());
        }
        if (reference.isShiftedReference()) {
            ShiftedReference sRef = (ShiftedReference)reference;
            return this.addShiftedReference((Range)lifespan, sRef.getFromAddress(), sRef.getToAddress(), sRef.getShift(), sRef.getReferenceType(), sRef.getSource(), sRef.getOperandIndex());
        }
        return this.addMemoryReference((Range)lifespan, reference.getFromAddress(), reference.getToAddress(), reference.getReferenceType(), reference.getSource(), reference.getOperandIndex());
    }

    protected void makeWay(Range<Long> span, Address fromAddress, Address toAddress, int operandIndex) {
        for (DBTraceReferenceEntry ent : this.referenceMapSpace.reduce(DBTraceAddressSnapRangePropertyMapTree.TraceAddressSnapRangeQuery.intersecting((AddressRange)new AddressRangeImpl(fromAddress, fromAddress), span)).values()) {
            if (!ent.toAddress.equals((Object)toAddress) || ent.opIndex != operandIndex) continue;
            DBTraceUtils.makeWay(ent, span, (e, s) -> e.setLifespan((Range<Long>)s), e -> e.ref.delete());
        }
    }

    @Override
    public DBTraceReference addMemoryReference(Range<Long> lifespan, Address fromAddress, Address toAddress, RefType refType, SourceType source, int operandIndex) {
        if (operandIndex < -1) {
            throw new IllegalArgumentException("operandIndex");
        }
        try (LockHold hold = LockHold.lock((Lock)this.lock.writeLock());){
            DBTraceReference ref;
            this.makeWay(lifespan, fromAddress, toAddress, operandIndex);
            DBTraceReferenceEntry entry = (DBTraceReferenceEntry)this.referenceMapSpace.put(fromAddress, lifespan, null);
            entry.set(toAddress, -1L, refType, operandIndex, 0L, false, TypeEnum.MEMORY, source);
            entry.ref = ref = TypeEnum.MEMORY.construct(entry);
            this.manager.doAddXRef(entry);
            DBTraceReference dBTraceReference = ref;
            return dBTraceReference;
        }
    }

    private boolean isExternalBlockAddress(Range<Long> lifespan, Address addr) {
        TraceMemoryRegion region = this.trace.getMemoryManager().getRegionContaining((Long)lifespan.lowerEndpoint(), addr);
        return region != null && "EXTERNAL".equals(region.getName());
    }

    @Override
    public DBTraceOffsetReference addOffsetReference(Range<Long> lifespan, Address fromAddress, Address toAddress, boolean toAddrIsBase, long offset, RefType refType, SourceType source, int operandIndex) {
        if (operandIndex < -1) {
            throw new IllegalArgumentException("operandIndex");
        }
        try (LockHold hold = LockHold.lock((Lock)this.lock.writeLock());){
            TypeEnum type = TypeEnum.OFFSET;
            boolean isExternalBlockRef = this.isExternalBlockAddress(lifespan, toAddress);
            boolean badOffsetReference = false;
            if (isExternalBlockRef) {
                type = TypeEnum.OFFSET_EXTERNAL;
                if (!toAddrIsBase) {
                    Address baseAddr = toAddress.subtractWrap(offset);
                    if (this.isExternalBlockAddress(lifespan, baseAddr)) {
                        toAddress = baseAddr;
                        toAddrIsBase = true;
                    } else {
                        isExternalBlockRef = false;
                        type = TypeEnum.OFFSET;
                        badOffsetReference = true;
                    }
                }
            } else if (toAddrIsBase) {
                toAddress = toAddress.addWrap(offset);
                toAddrIsBase = false;
                if (this.isExternalBlockAddress(lifespan, toAddress)) {
                    badOffsetReference = true;
                }
            }
            if (badOffsetReference) {
                Msg.warn((Object)this, (Object)("Offset Reference from " + fromAddress + " produces bad Xref into EXTERNAL block"));
            }
            this.makeWay(lifespan, fromAddress, toAddress, operandIndex);
            DBTraceReferenceEntry entry = (DBTraceReferenceEntry)this.referenceMapSpace.put(fromAddress, lifespan, null);
            entry.set(toAddress, -1L, refType, operandIndex, offset, false, type, source);
            DBTraceOffsetReference ref = new DBTraceOffsetReference(entry, isExternalBlockRef);
            entry.ref = ref;
            this.manager.doAddXRef(entry);
            DBTraceOffsetReference dBTraceOffsetReference = ref;
            return dBTraceOffsetReference;
        }
    }

    @Override
    public DBTraceShiftedReference addShiftedReference(Range<Long> lifespan, Address fromAddress, Address toAddress, int shift, RefType refType, SourceType source, int operandIndex) {
        if (operandIndex < -1) {
            throw new IllegalArgumentException("operandIndex");
        }
        try (LockHold hold = LockHold.lock((Lock)this.lock.writeLock());){
            this.makeWay(lifespan, fromAddress, toAddress, operandIndex);
            DBTraceReferenceEntry entry = (DBTraceReferenceEntry)this.referenceMapSpace.put(fromAddress, lifespan, null);
            entry.set(toAddress, -1L, refType, operandIndex, shift, false, TypeEnum.SHIFT, source);
            DBTraceShiftedReference ref = new DBTraceShiftedReference(entry);
            entry.ref = ref;
            this.manager.doAddXRef(entry);
            DBTraceShiftedReference dBTraceShiftedReference = ref;
            return dBTraceShiftedReference;
        }
    }

    @Override
    public DBTraceReference addRegisterReference(Range<Long> lifespan, Address fromAddress, Register toRegister, RefType refType, SourceType source, int operandIndex) {
        return this.addMemoryReference((Range)lifespan, fromAddress, toRegister.getAddress(), refType, source, operandIndex);
    }

    @Override
    public DBTraceReference addStackReference(Range<Long> lifespan, Address fromAddress, int toStackOffset, RefType refType, SourceType source, int operandIndex) {
        AddressSpace stack = this.baseLanguage.getDefaultCompilerSpec().getStackSpace();
        return this.addMemoryReference((Range)lifespan, fromAddress, stack.getAddress((long)toStackOffset), refType, source, operandIndex);
    }

    @Override
    public DBTraceReference getReference(long snap, Address fromAddress, Address toAddress, int operandIndex) {
        try (LockHold hold = LockHold.lock((Lock)this.lock.readLock());){
            for (DBTraceReferenceEntry entry : this.referenceMapSpace.reduce(DBTraceAddressSnapRangePropertyMapTree.TraceAddressSnapRangeQuery.at(fromAddress, snap)).values()) {
                if (!toAddress.equals((Object)entry.toAddress) || entry.opIndex != operandIndex) continue;
                DBTraceReference dBTraceReference = entry.ref;
                return dBTraceReference;
            }
            Iterator iterator = null;
            return iterator;
        }
    }

    public Collection<? extends DBTraceReference> getReferencesFrom(long snap, Address fromAddress) {
        return Collections2.transform((Collection)this.referenceMapSpace.reduce(DBTraceAddressSnapRangePropertyMapTree.TraceAddressSnapRangeQuery.at(fromAddress, snap)).values(), e -> e.ref);
    }

    public Collection<? extends DBTraceReference> getReferencesFrom(long snap, Address fromAddress, int operandIndex) {
        return Collections2.filter(this.getReferencesFrom(snap, fromAddress), r -> r.getOperandIndex() == operandIndex);
    }

    public Collection<? extends DBTraceReference> getReferencesFromRange(Range<Long> span, AddressRange range) {
        return Collections2.transform((Collection)this.referenceMapSpace.reduce(DBTraceAddressSnapRangePropertyMapTree.TraceAddressSnapRangeQuery.intersecting(range, span)).values(), e -> e.ref);
    }

    @Override
    public DBTraceReference getPrimaryReferenceFrom(long snap, Address fromAddress, int operandIndex) {
        for (DBTraceReference dBTraceReference : this.getReferencesFrom(snap, fromAddress)) {
            if (!dBTraceReference.isPrimary() || dBTraceReference.getOperandIndex() != operandIndex) continue;
            return dBTraceReference;
        }
        return null;
    }

    public Collection<? extends DBTraceReference> getFlowReferencesFrom(long snap, Address fromAddress) {
        return Collections2.filter(this.getReferencesFrom(snap, fromAddress), r -> r.getReferenceType().isFlow());
    }

    @Override
    public void clearReferencesFrom(Range<Long> span, AddressRange range) {
        try (LockHold hold = this.manager.getTrace().lockWrite();){
            long startSnap = DBTraceUtils.lowerEndpoint(span);
            for (DBTraceReferenceEntry ref : this.referenceMapSpace.reduce(DBTraceAddressSnapRangePropertyMapTree.TraceAddressSnapRangeQuery.intersecting(range, span)).values()) {
                this.truncateOrDeleteEntry(ref, startSnap);
            }
        }
    }

    protected DBTraceReferenceEntry getRefEntryForXRefEntry(DBTraceXRefEntry e) {
        AddressSpace fromAddressSpace = this.baseLanguage.getAddressFactory().getAddressSpace((int)e.refSpaceId);
        DBTraceReferenceSpace fromSpace = this.manager.getForSpace(fromAddressSpace, false);
        assert (fromSpace != null);
        return fromSpace.referenceMapSpace.getDataByKey(e.refKey);
    }

    protected DBTraceReference getRefForXRefEntry(DBTraceXRefEntry e) {
        return this.getRefEntryForXRefEntry((DBTraceXRefEntry)e).ref;
    }

    public Collection<? extends DBTraceReference> getReferencesTo(long snap, Address toAddress) {
        return Collections2.transform((Collection)this.xrefMapSpace.reduce(DBTraceAddressSnapRangePropertyMapTree.TraceAddressSnapRangeQuery.at(toAddress, snap)).values(), this::getRefForXRefEntry);
    }

    public Collection<? extends DBTraceReference> getReferencesToRange(Range<Long> span, AddressRange range) {
        return Collections2.transform((Collection)this.xrefMapSpace.reduce(DBTraceAddressSnapRangePropertyMapTree.TraceAddressSnapRangeQuery.intersecting(range, span)).values(), this::getRefForXRefEntry);
    }

    protected void truncateOrDeleteEntry(DBTraceReferenceEntry ref, long otherStartSnap) {
        if (DBTraceUtils.lowerEndpoint(ref.getLifespan()) < otherStartSnap) {
            Range<Long> oldSpan = ref.getLifespan();
            ref.setEndSnap(otherStartSnap - 1L);
            this.trace.setChanged(new TraceChangeRecord<DBTraceReference, Range<Long>>(Trace.TraceReferenceChangeType.LIFESPAN_CHANGED, this, ref.ref, oldSpan, ref.getLifespan()));
        } else {
            ref.ref.delete();
        }
    }

    @Override
    public void clearReferencesTo(Range<Long> span, AddressRange range) {
        try (LockHold hold = this.manager.getTrace().lockWrite();){
            long startSnap = DBTraceUtils.lowerEndpoint(span);
            for (DBTraceXRefEntry xref : this.xrefMapSpace.reduce(DBTraceAddressSnapRangePropertyMapTree.TraceAddressSnapRangeQuery.intersecting(range, span)).values()) {
                DBTraceReferenceEntry ref = this.getRefEntryForXRefEntry(xref);
                this.truncateOrDeleteEntry(ref, startSnap);
            }
        }
    }

    @Override
    public AddressSetView getReferenceSources(Range<Long> span) {
        return new DBTraceAddressSnapRangePropertyMapAddressSetView<DBTraceReferenceEntry>(this.space, this.lock, this.referenceMapSpace.reduce(DBTraceAddressSnapRangePropertyMapTree.TraceAddressSnapRangeQuery.intersecting((AddressRange)this.fullSpace, span)), e -> true);
    }

    @Override
    public AddressSetView getReferenceDestinations(Range<Long> span) {
        return new DBTraceAddressSnapRangePropertyMapAddressSetView<DBTraceXRefEntry>(this.space, this.lock, this.xrefMapSpace.reduce(DBTraceAddressSnapRangePropertyMapTree.TraceAddressSnapRangeQuery.intersecting((AddressRange)this.fullSpace, span)), e -> true);
    }

    @Override
    public int getReferenceCountFrom(long snap, Address fromAddress) {
        return this.referenceMapSpace.reduce(DBTraceAddressSnapRangePropertyMapTree.TraceAddressSnapRangeQuery.at(fromAddress, snap)).size();
    }

    @Override
    public int getReferenceCountTo(long snap, Address toAddress) {
        return this.xrefMapSpace.reduce(DBTraceAddressSnapRangePropertyMapTree.TraceAddressSnapRangeQuery.at(toAddress, snap)).size();
    }

    protected Collection<? extends DBTraceReference> getReferencesBySymbolId(long id) {
        return Collections2.transform((Collection)this.refsBySymbolId.get((Object)id), e -> e.ref);
    }

    @Override
    public void invalidateCache() {
        try (LockHold hold = LockHold.lock((Lock)this.lock.writeLock());){
            this.referenceMapSpace.invalidateCache();
            this.xrefMapSpace.invalidateCache();
        }
    }

    @DBAnnotatedObjectInfo(version=1)
    protected static class DBTraceReferenceEntry
    extends DBTraceAddressSnapRangePropertyMapTree.AbstractDBTraceAddressSnapRangePropertyMapData<DBTraceReferenceEntry>
    implements DBTraceOverlaySpaceAdapter.DecodesAddresses {
        private static final String TABLE_NAME = "References";
        private static final byte SOURCE_MASK = 15;
        private static final byte SOURCE_SHIFT = 0;
        private static final byte PRIMARY_MASK = 16;
        private static final byte PRIMARY_CLEAR = -17;
        private static final byte TYPE_MASK = 3;
        private static final byte TYPE_SHIFT = 5;
        static final String TO_ADDR_COLUMN_NAME = "ToAddr";
        static final String SYMBOL_ID_COLUMN_NAME = "SymbolId";
        static final String REF_TYPE_COLUMN_NAME = "RefType";
        static final String OP_INDEX_COLUMN_NAME = "OpIndex";
        static final String EXT_COLUMN_NAME = "Ext";
        static final String FLAGS_COLUMN_NAME = "Flags";
        @DBAnnotatedColumn(value="ToAddr")
        static DBObjectColumn TO_ADDR_COLUMN;
        @DBAnnotatedColumn(value="SymbolId")
        static DBObjectColumn SYMBOL_ID_COLUMN;
        @DBAnnotatedColumn(value="RefType")
        static DBObjectColumn REF_TYPE_COLUMN;
        @DBAnnotatedColumn(value="OpIndex")
        static DBObjectColumn OP_INDEX_COLUMN;
        @DBAnnotatedColumn(value="Ext")
        static DBObjectColumn EXT_COLUMN;
        @DBAnnotatedColumn(value="Flags")
        static DBObjectColumn FLAGS_COLUMN;
        @DBAnnotatedField(column="ToAddr", indexed=true, codec=DBTraceOverlaySpaceAdapter.AddressDBFieldCodec.class)
        protected Address toAddress = Address.NO_ADDRESS;
        @DBAnnotatedField(column="SymbolId", indexed=true)
        protected long symbolId;
        @DBAnnotatedField(column="RefType", codec=DBTraceUtils.RefTypeDBFieldCodec.class)
        protected RefType refType;
        @DBAnnotatedField(column="OpIndex")
        protected byte opIndex;
        @DBAnnotatedField(column="Ext")
        protected long ext;
        @DBAnnotatedField(column="Flags")
        protected byte flags;
        protected final DBTraceReferenceSpace space;
        protected DBTraceReference ref;

        public static String tableName(AddressSpace space, long threadKey, int frameLevel) {
            return DBTraceUtils.tableName(TABLE_NAME, space, threadKey, frameLevel);
        }

        public DBTraceReferenceEntry(DBTraceReferenceSpace space, DBTraceAddressSnapRangePropertyMapTree<DBTraceReferenceEntry, ?> tree, DBCachedObjectStore<?> store, DBRecord record) {
            super(tree, store, record);
            this.space = space;
        }

        @Override
        public DBTraceOverlaySpaceAdapter getOverlaySpaceAdapter() {
            return this.space.manager.overlayAdapter;
        }

        @Override
        protected void fresh(boolean created) throws IOException {
            super.fresh(created);
            if (created) {
                return;
            }
            TypeEnum type = TypeEnum.values()[this.flags >> 5 & 3];
            this.ref = type.construct(this);
        }

        protected void setRecordValue(DBTraceReferenceEntry value) {
        }

        protected DBTraceReferenceEntry getRecordValue() {
            return this;
        }

        protected void set(Address toAddress, long symbolId, RefType refType, int opIndex, long ext, boolean isPrimary, TypeEnum type, SourceType sourceType) {
            this.toAddress = toAddress;
            this.symbolId = symbolId;
            this.refType = refType;
            this.opIndex = (byte)opIndex;
            this.ext = ext;
            this.flags = (byte)((isPrimary ? 16 : 0) | sourceType.ordinal() << 0 | type.ordinal() << 5);
            this.update(new DBObjectColumn[]{TO_ADDR_COLUMN, SYMBOL_ID_COLUMN, REF_TYPE_COLUMN, OP_INDEX_COLUMN, EXT_COLUMN, FLAGS_COLUMN});
        }

        protected void setLifespan(Range<Long> lifespan) {
            super.doSetLifespan(lifespan);
            this.space.manager.doSetXRefLifespan(this);
        }

        public void setEndSnap(long endSnap) {
            this.setLifespan(DBTraceUtils.toRange(DBTraceUtils.lowerEndpoint((Range<Long>)this.lifespan), endSnap));
        }

        public void setSymbolId(long symbolId) {
            if (this.symbolId == symbolId) {
                return;
            }
            AbstractDBTraceSymbol oldSymbol = this.space.trace.getSymbolManager().getSymbolByID(this.symbolId);
            AbstractDBTraceSymbol newSymbol = this.space.trace.getSymbolManager().getSymbolByID(symbolId);
            this.symbolId = symbolId;
            this.update(SYMBOL_ID_COLUMN);
            if (oldSymbol != null) {
                this.space.trace.setChanged(new TraceChangeRecord<AbstractDBTraceSymbol, DBTraceReference>(Trace.TraceSymbolChangeType.ASSOCIATION_REMOVED, this.space, oldSymbol, this.ref));
            }
            if (newSymbol != null) {
                this.space.trace.setChanged(new TraceChangeRecord<AbstractDBTraceSymbol, DBTraceReference>(Trace.TraceSymbolChangeType.ASSOCIATION_ADDED, this.space, newSymbol, this.ref));
            }
        }

        public long getSymbolId() {
            return this.symbolId;
        }

        public void setRefType(RefType refType) {
            this.refType = refType;
            this.update(REF_TYPE_COLUMN);
        }

        public RefType getRefType() {
            return this.refType;
        }

        public void setPrimary(boolean b) {
            this.flags = b ? (byte)(this.flags | 0x10) : (byte)(this.flags & 0xFFFFFFEF);
            this.update(FLAGS_COLUMN);
        }

        public boolean isPrimary() {
            return (this.flags & 0x10) != 0;
        }

        public SourceType getSourceType() {
            return SourceType.values()[this.flags >> 0 & 0xF];
        }

        protected void doDelete() {
            try (LockHold hold = LockHold.lock((Lock)this.space.lock.writeLock());){
                this.space.referenceMapSpace.deleteData(this);
                this.space.manager.doDelXRef(this);
            }
        }
    }

    @DBAnnotatedObjectInfo(version=0)
    protected static class DBTraceXRefEntry
    extends DBTraceAddressSnapRangePropertyMapTree.AbstractDBTraceAddressSnapRangePropertyMapData<DBTraceXRefEntry> {
        private static final String TABLE_NAME = "XRefs";
        static final String REF_KEY_COLUMN_NAME = "RefKey";
        static final String REF_SPACE_COLUMN_NAME = "Space";
        @DBAnnotatedColumn(value="RefKey")
        static DBObjectColumn REF_KEY_COLUMN;
        @DBAnnotatedColumn(value="Space")
        static DBObjectColumn REF_SPACE_COLUMN;
        @DBAnnotatedField(column="Space")
        protected short refSpaceId;
        @DBAnnotatedField(column="RefKey", indexed=true)
        protected long refKey;
        protected final DBTraceReferenceSpace space;

        public static String tableName(AddressSpace space, long threadKey, int frameLevel) {
            return DBTraceUtils.tableName(TABLE_NAME, space, threadKey, frameLevel);
        }

        public DBTraceXRefEntry(DBTraceReferenceSpace space, DBTraceAddressSnapRangePropertyMapTree<DBTraceXRefEntry, ?> tree, DBCachedObjectStore<?> store, DBRecord record) {
            super(tree, store, record);
            this.space = space;
        }

        protected void setRecordValue(DBTraceXRefEntry value) {
        }

        protected DBTraceXRefEntry getRecordValue() {
            return this;
        }

        void set(short refSpaceId, long refKey) {
            this.refSpaceId = refSpaceId;
            this.refKey = refKey;
            this.update(REF_SPACE_COLUMN, REF_KEY_COLUMN);
        }

        protected void setLifespan(Range<Long> lifespan) {
            super.doSetLifespan(lifespan);
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    protected static enum TypeEnum {
        MEMORY{

            @Override
            protected DBTraceReference construct(DBTraceReferenceEntry ent) {
                if (ent.toAddress.isStackAddress()) {
                    return new DBTraceStackReference(ent);
                }
                return new DBTraceReference(ent);
            }
        }
        ,
        OFFSET{

            @Override
            protected DBTraceReference construct(DBTraceReferenceEntry ent) {
                return new DBTraceOffsetReference(ent, false);
            }
        }
        ,
        SHIFT{

            @Override
            protected DBTraceReference construct(DBTraceReferenceEntry ent) {
                return new DBTraceShiftedReference(ent);
            }
        }
        ,
        OFFSET_EXTERNAL{

            @Override
            protected DBTraceReference construct(DBTraceReferenceEntry ent) {
                return new DBTraceOffsetReference(ent, true);
            }
        };


        protected abstract DBTraceReference construct(DBTraceReferenceEntry var1);
    }
}

