/*
 * Decompiled with CFR 0.152.
 */
package ghidra.trace.database.space;

import db.DBHandle;
import db.DBRecord;
import generic.CatenatedCollection;
import ghidra.dbg.target.TargetRegisterContainer;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressFactory;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.lang.Language;
import ghidra.trace.database.DBTrace;
import ghidra.trace.database.DBTraceManager;
import ghidra.trace.database.DBTraceUtils;
import ghidra.trace.database.space.DBTraceSpaceBased;
import ghidra.trace.database.thread.DBTraceThreadManager;
import ghidra.trace.model.stack.TraceObjectStackFrame;
import ghidra.trace.model.stack.TraceStackFrame;
import ghidra.trace.model.target.TraceObject;
import ghidra.trace.model.thread.TraceObjectThread;
import ghidra.trace.model.thread.TraceThread;
import ghidra.trace.util.TraceAddressSpace;
import ghidra.util.LockHold;
import ghidra.util.Msg;
import ghidra.util.database.DBAnnotatedObject;
import ghidra.util.database.DBCachedObjectStore;
import ghidra.util.database.DBCachedObjectStoreFactory;
import ghidra.util.database.DBObjectColumn;
import ghidra.util.database.DBOpenMode;
import ghidra.util.database.annot.DBAnnotatedColumn;
import ghidra.util.database.annot.DBAnnotatedField;
import ghidra.util.database.annot.DBAnnotatedObjectInfo;
import ghidra.util.exception.VersionException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;

public abstract class AbstractDBTraceSpaceBasedManager<M extends DBTraceSpaceBased>
implements DBTraceManager {
    protected static final AddressSpace NO_ADDRESS_SPACE = Address.NO_ADDRESS.getAddressSpace();
    protected final String name;
    protected final DBHandle dbh;
    protected final ReadWriteLock lock;
    protected final Language baseLanguage;
    protected final DBTrace trace;
    protected final DBTraceThreadManager threadManager;
    protected final DBCachedObjectStore<DBTraceSpaceEntry> spaceStore;
    protected final Map<AddressSpace, M> memSpaces = new TreeMap<AddressSpace, M>();
    protected final Map<Pair<TraceThread, Integer>, M> regSpaces = new HashMap<Pair<TraceThread, Integer>, M>();
    protected final Map<TraceObject, M> regSpacesByObject = new HashMap<TraceObject, M>();
    protected final Collection<M> memSpacesView = Collections.unmodifiableCollection(this.memSpaces.values());
    protected final Collection<M> regSpacesView = Collections.unmodifiableCollection(this.regSpaces.values());
    protected final Collection<M> allSpacesView = new CatenatedCollection(new Collection[]{this.memSpacesView, this.regSpacesView});

    public AbstractDBTraceSpaceBasedManager(String name, DBHandle dbh, DBOpenMode openMode, ReadWriteLock lock, TaskMonitor monitor, Language baseLanguage, DBTrace trace, DBTraceThreadManager threadManager) throws IOException, VersionException {
        this.name = name;
        this.dbh = dbh;
        this.lock = lock;
        this.baseLanguage = baseLanguage;
        this.trace = trace;
        this.threadManager = threadManager;
        DBCachedObjectStoreFactory factory = trace.getStoreFactory();
        this.spaceStore = factory.getOrCreateCachedStore(name + "Spaces", DBTraceSpaceEntry.class, DBTraceSpaceEntry::new, true);
    }

    protected String tableName(AddressSpace space, long threadKey, int frameLevel) {
        return DBTraceUtils.tableName(this.name, space, threadKey, frameLevel);
    }

    protected void loadSpaces() throws VersionException, IOException {
        for (DBTraceSpaceEntry ent : this.spaceStore.asMap().values()) {
            AddressFactory addressFactory = this.trace.getBaseAddressFactory();
            AddressSpace space = NO_ADDRESS_SPACE.getName().equals(ent.spaceName) ? NO_ADDRESS_SPACE : addressFactory.getAddressSpace(ent.spaceName);
            if (space == null) {
                Msg.error((Object)this, (Object)("Space " + ent.spaceName + " does not exist in trace (language=" + this.baseLanguage + ")."));
                continue;
            }
            if (space.isRegisterSpace()) {
                if (this.threadManager == null) {
                    Msg.error((Object)this, (Object)"Register spaces are not allowed without a thread manager.");
                    continue;
                }
                TraceThread thread = this.threadManager.getThread(ent.threadKey);
                DBTraceSpaceBased regSpace = ent.space == null ? this.createRegisterSpace(space, thread, ent) : ent.space;
                this.regSpaces.put((Pair<TraceThread, Integer>)ImmutablePair.of((Object)thread, (Object)ent.getFrameLevel()), regSpace);
                continue;
            }
            DBTraceSpaceBased memSpace = ent.space == null ? this.createSpace(space, ent) : ent.space;
            this.memSpaces.put(space, memSpace);
        }
    }

    protected M getForSpace(AddressSpace space, boolean createIfAbsent) {
        this.trace.assertValidSpace(Objects.requireNonNull(space));
        if (!space.isMemorySpace() && !space.isRegisterSpace() && space != Address.NO_ADDRESS.getAddressSpace()) {
            throw new IllegalArgumentException("Space must be a memory, register, or NO_ADDRESS space");
        }
        if (!createIfAbsent) {
            try (LockHold hold = LockHold.lock((Lock)this.lock.readLock());){
                DBTraceSpaceBased dBTraceSpaceBased = (DBTraceSpaceBased)this.memSpaces.get(space);
                return (M)dBTraceSpaceBased;
            }
        }
        try (LockHold hold = LockHold.lock((Lock)this.lock.writeLock());){
            DBTraceSpaceBased dBTraceSpaceBased = this.memSpaces.computeIfAbsent(space, s -> {
                try {
                    DBTraceSpaceEntry ent = (DBTraceSpaceEntry)this.spaceStore.create();
                    ent.set(space.getName(), -1L, 0);
                    return this.createSpace(space, ent);
                }
                catch (VersionException e) {
                    throw new AssertionError((Object)e);
                }
                catch (IOException e) {
                    this.dbError(e);
                    return null;
                }
            });
            return (M)dBTraceSpaceBased;
        }
    }

    protected M getForRegisterSpace(TraceThread thread, int frameLevel, boolean createIfAbsent) {
        this.trace.getThreadManager().assertIsMine(thread);
        if (thread instanceof TraceObjectThread) {
            TraceObjectThread objThread = (TraceObjectThread)thread;
            return this.getForRegisterSpaceObjectThread(objThread, frameLevel, createIfAbsent);
        }
        ImmutablePair frame = ImmutablePair.of((Object)thread, (Object)frameLevel);
        if (!createIfAbsent) {
            try (LockHold hold = LockHold.lock((Lock)this.lock.readLock());){
                DBTraceSpaceBased dBTraceSpaceBased = (DBTraceSpaceBased)this.regSpaces.get(frame);
                return (M)dBTraceSpaceBased;
            }
        }
        try (LockHold hold = LockHold.lock((Lock)this.lock.writeLock());){
            DBTraceSpaceBased dBTraceSpaceBased = this.regSpaces.computeIfAbsent((Pair<TraceThread, Integer>)frame, t -> {
                AddressSpace regSpace = this.baseLanguage.getAddressFactory().getRegisterSpace();
                try {
                    DBTraceSpaceEntry ent = (DBTraceSpaceEntry)this.spaceStore.create();
                    ent.set(regSpace.getName(), thread.getKey(), frameLevel);
                    return this.createRegisterSpace(regSpace, thread, ent);
                }
                catch (VersionException e) {
                    throw new AssertionError((Object)e);
                }
                catch (IOException e) {
                    this.dbError(e);
                    return null;
                }
            });
            return (M)dBTraceSpaceBased;
        }
    }

    protected M getForRegisterSpace(TraceStackFrame frame, boolean createIfAbsent) {
        if (frame instanceof TraceObjectStackFrame) {
            TraceObjectStackFrame objFrame = (TraceObjectStackFrame)frame;
            return this.getForRegisterSpace(objFrame.getObject(), 0, createIfAbsent);
        }
        return this.getForRegisterSpace(frame.getStack().getThread(), frame.getLevel(), createIfAbsent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private M doGetForRegisterSpaceFoundContainer(TraceObject object, TraceObject objRegs, boolean createIfAbsent) {
        String name = objRegs.getCanonicalPath().toString();
        if (!createIfAbsent) {
            try (LockHold hold = LockHold.lock((Lock)this.lock.readLock());){
                AddressSpace as = this.trace.getBaseAddressFactory().getAddressSpace(name);
                if (as == null) {
                    M m = null;
                    return m;
                }
                M space = this.getForSpace(as, createIfAbsent);
                if (space == null) {
                    M m = null;
                    return m;
                }
                Map<TraceObject, Object> map = this.regSpacesByObject;
                synchronized (map) {
                    this.regSpacesByObject.put(object, space);
                }
                map = space;
                return (M)map;
            }
        }
        try (LockHold hold = LockHold.lock((Lock)this.lock.writeLock());){
            AddressSpace as = this.trace.getMemoryManager().getOrCreateOverlayAddressSpace(name, this.trace.getBaseAddressFactory().getRegisterSpace());
            M space = this.getForSpace(as, createIfAbsent);
            Map<TraceObject, Object> map = this.regSpacesByObject;
            synchronized (map) {
                this.regSpacesByObject.put(object, space);
            }
            map = space;
            return (M)map;
        }
    }

    protected M getForRegisterSpaceObjectThread(TraceObjectThread thread, int frameLevel, boolean createIfAbsent) {
        return this.getForRegisterSpace(thread.getObject(), frameLevel, createIfAbsent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected M getForRegisterSpace(TraceObject object, int frameLevel, boolean createIfAbsent) {
        DBTraceSpaceBased space;
        Map<TraceObject, M> map = this.regSpacesByObject;
        synchronized (map) {
            space = (DBTraceSpaceBased)this.regSpacesByObject.get(object);
            if (space != null) {
                return (M)space;
            }
        }
        try (LockHold hold = LockHold.lock((Lock)(createIfAbsent ? this.lock.writeLock() : this.lock.readLock()));){
            if (object.getTargetSchema().getInterfaces().contains(TargetRegisterContainer.class)) {
                space = this.doGetForRegisterSpaceFoundContainer(object, object, createIfAbsent);
                return (M)space;
            }
            TraceObject objRegs = object.queryRegisterContainer(frameLevel);
            if (objRegs != null) {
                M m = this.doGetForRegisterSpaceFoundContainer(object, objRegs, createIfAbsent);
                return m;
            }
            M m = null;
            return m;
        }
    }

    public DBTrace getTrace() {
        return this.trace;
    }

    public ReadWriteLock getLock() {
        return this.lock;
    }

    public Language getBaseLanguage() {
        return this.baseLanguage;
    }

    public M get(TraceAddressSpace space, boolean createIfAbsent) {
        TraceThread thread = space.getThread();
        if (thread != null) {
            return this.getForRegisterSpace(thread, space.getFrameLevel(), createIfAbsent);
        }
        return this.getForSpace(space.getAddressSpace(), createIfAbsent);
    }

    public Collection<M> getActiveSpaces() {
        return this.allSpacesView;
    }

    public Collection<M> getActiveMemorySpaces() {
        return this.memSpacesView;
    }

    public Collection<M> getActiveRegisterSpaces() {
        return this.regSpacesView;
    }

    protected abstract M createSpace(AddressSpace var1, DBTraceSpaceEntry var2) throws VersionException, IOException;

    protected abstract M createRegisterSpace(AddressSpace var1, TraceThread var2, DBTraceSpaceEntry var3) throws VersionException, IOException;

    public void dbError(IOException e) {
        this.trace.dbError(e);
    }

    @Override
    public void invalidateCache(boolean all) {
        try (LockHold hold = LockHold.lock((Lock)this.lock.writeLock());){
            this.spaceStore.invalidateCache();
            this.memSpaces.clear();
            this.regSpaces.clear();
            this.loadSpaces();
            for (DBTraceSpaceBased m : this.memSpaces.values()) {
                m.invalidateCache();
            }
            for (DBTraceSpaceBased r : this.regSpaces.values()) {
                r.invalidateCache();
            }
        }
        catch (VersionException e) {
            throw new AssertionError((Object)e);
        }
        catch (IOException e) {
            this.dbError(e);
        }
    }

    @DBAnnotatedObjectInfo(version=0)
    public static class DBTraceSpaceEntry
    extends DBAnnotatedObject {
        static final String SPACE_COLUMN_NAME = "Space";
        static final String THREAD_COLUMN_NAME = "Thread";
        static final String FRAME_COLUMN_NAME = "Frame";
        @DBAnnotatedColumn(value="Space")
        static DBObjectColumn SPACE_COLUMN;
        @DBAnnotatedColumn(value="Thread")
        static DBObjectColumn THREAD_COLUMN;
        @DBAnnotatedColumn(value="Frame")
        static DBObjectColumn FRAME_COLUMN;
        @DBAnnotatedField(column="Space")
        private String spaceName;
        @DBAnnotatedField(column="Thread")
        private long threadKey;
        @DBAnnotatedField(column="Frame")
        private int frameLevel;
        DBTraceSpaceBased space;

        public DBTraceSpaceEntry(DBCachedObjectStore<?> store, DBRecord record) {
            super(store, record);
        }

        void set(String spaceName, long threadKey, int frameLevel) {
            this.spaceName = spaceName;
            this.threadKey = threadKey;
            this.frameLevel = frameLevel;
            this.update(SPACE_COLUMN, THREAD_COLUMN, FRAME_COLUMN);
        }

        public long getThreadKey() {
            return this.threadKey;
        }

        public int getFrameLevel() {
            return this.frameLevel;
        }
    }
}

