/*
 * Decompiled with CFR 0.152.
 */
package ghidra.trace.database.module;

import com.google.common.collect.Range;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressSpace;
import ghidra.trace.database.DBTrace;
import ghidra.trace.database.map.DBTraceAddressSnapRangePropertyMapSpace;
import ghidra.trace.database.map.DBTraceAddressSnapRangePropertyMapTree;
import ghidra.trace.database.module.DBTraceModule;
import ghidra.trace.database.module.DBTraceModuleManager;
import ghidra.trace.database.module.DBTraceSection;
import ghidra.trace.database.space.DBTraceSpaceBased;
import ghidra.trace.database.thread.DBTraceThread;
import ghidra.trace.model.ImmutableTraceAddressSnapRange;
import ghidra.trace.model.Trace;
import ghidra.trace.model.modules.TraceModuleSpace;
import ghidra.trace.util.TraceChangeRecord;
import ghidra.util.database.DBCachedObjectIndex;
import ghidra.util.exception.VersionException;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.concurrent.locks.ReadWriteLock;

public class DBTraceModuleSpace
implements TraceModuleSpace,
DBTraceSpaceBased {
    protected final DBTraceModuleManager manager;
    protected final AddressSpace space;
    protected final ReadWriteLock lock;
    protected final DBTrace trace;
    protected final DBTraceAddressSnapRangePropertyMapSpace<DBTraceModule, DBTraceModule> moduleMapSpace;
    protected final DBCachedObjectIndex<String, DBTraceModule> modulesByPath;
    protected final Collection<DBTraceModule> moduleView;
    protected final DBTraceAddressSnapRangePropertyMapSpace<DBTraceSection, DBTraceSection> sectionMapSpace;
    protected final DBCachedObjectIndex<Long, DBTraceSection> sectionsByModuleKey;
    protected final DBCachedObjectIndex<String, DBTraceSection> sectionsByPath;
    protected final Collection<DBTraceSection> sectionView;

    public DBTraceModuleSpace(DBTraceModuleManager manager, AddressSpace space) throws VersionException, IOException {
        this.manager = manager;
        this.space = space;
        this.lock = manager.getLock();
        this.trace = manager.getTrace();
        this.moduleMapSpace = new DBTraceAddressSnapRangePropertyMapSpace(DBTraceModule.tableName(space), this.trace.getStoreFactory(), this.lock, space, null, 0, DBTraceModule.class, (t, s, r) -> new DBTraceModule(this, t, s, r));
        this.modulesByPath = this.moduleMapSpace.getUserIndex(String.class, DBTraceModule.PATH_COLUMN);
        this.moduleView = Collections.unmodifiableCollection(this.moduleMapSpace.values());
        this.sectionMapSpace = new DBTraceAddressSnapRangePropertyMapSpace(DBTraceSection.tableName(space), this.trace.getStoreFactory(), this.lock, space, null, 0, DBTraceSection.class, (t, s, r) -> new DBTraceSection(this, t, s, r));
        this.sectionsByModuleKey = this.sectionMapSpace.getUserIndex(Long.TYPE, DBTraceSection.MODULE_COLUMN);
        this.sectionsByPath = this.sectionMapSpace.getUserIndex(String.class, DBTraceSection.PATH_COLUMN);
        this.sectionView = Collections.unmodifiableCollection(this.sectionMapSpace.values());
    }

    @Override
    public DBTraceThread getThread() {
        return null;
    }

    @Override
    public int getFrameLevel() {
        return 0;
    }

    @Override
    public void invalidateCache() {
        this.moduleMapSpace.invalidateCache();
        this.sectionMapSpace.invalidateCache();
    }

    @Override
    public AddressSpace getAddressSpace() {
        return this.space;
    }

    protected DBTraceModule doAddModule(String modulePath, String moduleName, AddressRange range, Range<Long> lifespan) {
        DBTraceModule module = this.moduleMapSpace.put(new ImmutableTraceAddressSnapRange(range, lifespan), null);
        module.set(modulePath, moduleName);
        this.trace.setChanged(new TraceChangeRecord(Trace.TraceModuleChangeType.ADDED, null, module));
        return module;
    }

    public Collection<? extends DBTraceModule> getAllModules() {
        return this.moduleView;
    }

    protected Collection<? extends DBTraceModule> doGetModulesByPath(String modulePath) {
        return this.modulesByPath.get((Object)modulePath);
    }

    public Collection<? extends DBTraceModule> getLoadedModules(long snap) {
        return Collections.unmodifiableCollection(this.moduleMapSpace.reduce(DBTraceAddressSnapRangePropertyMapTree.TraceAddressSnapRangeQuery.atSnap(snap, this.space)).values());
    }

    public Collection<? extends DBTraceModule> getModulesAt(long snap, Address address) {
        return Collections.unmodifiableCollection(this.moduleMapSpace.reduce(DBTraceAddressSnapRangePropertyMapTree.TraceAddressSnapRangeQuery.at(address, snap)).values());
    }

    public Collection<? extends DBTraceModule> getModulesIntersecting(Range<Long> lifespan, AddressRange range) {
        return Collections.unmodifiableCollection(this.moduleMapSpace.reduce(DBTraceAddressSnapRangePropertyMapTree.TraceAddressSnapRangeQuery.intersecting(range, lifespan)).values());
    }

    public DBTraceSection doAddSection(DBTraceModule module, String sectionPath, String sectionName, AddressRange range) {
        DBTraceSection section = this.sectionMapSpace.put(new ImmutableTraceAddressSnapRange(range, module.getLifespan()), null);
        section.set(module, sectionPath, sectionName);
        this.trace.setChanged(new TraceChangeRecord(Trace.TraceSectionChangeType.ADDED, null, section));
        return section;
    }

    public Collection<? extends DBTraceSection> getAllSections() {
        return this.sectionView;
    }

    public Collection<? extends DBTraceSection> getSectionsAt(long snap, Address address) {
        return Collections.unmodifiableCollection(this.sectionMapSpace.reduce(DBTraceAddressSnapRangePropertyMapTree.TraceAddressSnapRangeQuery.at(address, snap)).values());
    }

    public Collection<? extends DBTraceSection> getSectionsIntersecting(Range<Long> lifespan, AddressRange range) {
        return Collections.unmodifiableCollection(this.sectionMapSpace.reduce(DBTraceAddressSnapRangePropertyMapTree.TraceAddressSnapRangeQuery.intersecting(range, lifespan)).values());
    }

    public Collection<? extends DBTraceSection> doGetSectionsByModuleId(long key) {
        return this.sectionsByModuleKey.get((Object)key);
    }

    public DBTraceSection doGetSectionByName(long moduleKey, String sectionName) {
        for (DBTraceSection section : this.sectionsByModuleKey.get((Object)moduleKey)) {
            if (!Objects.equals(section.getName(), sectionName)) continue;
            return section;
        }
        return null;
    }

    public Collection<? extends DBTraceSection> doGetSectionsByPath(String sectionPath) {
        return this.sectionsByPath.get((Object)sectionPath);
    }

    public DBTraceModule doGetModuleById(long moduleKey) {
        return this.moduleMapSpace.getDataByKey(moduleKey);
    }
}

