/*
 * Decompiled with CFR 0.152.
 */
package ghidra.trace.database.memory;

import com.google.common.collect.Range;
import db.DBRecord;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressOverflowException;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressSpace;
import ghidra.trace.database.DBTrace;
import ghidra.trace.database.DBTraceUtils;
import ghidra.trace.database.map.DBTraceAddressSnapRangePropertyMapTree;
import ghidra.trace.database.memory.DBTraceMemorySpace;
import ghidra.trace.model.Trace;
import ghidra.trace.model.memory.TraceMemoryFlag;
import ghidra.trace.model.memory.TraceMemoryRegion;
import ghidra.trace.model.memory.TraceOverlappedRegionException;
import ghidra.trace.util.TraceChangeRecord;
import ghidra.util.LockHold;
import ghidra.util.database.DBCachedObjectStore;
import ghidra.util.database.DBObjectColumn;
import ghidra.util.database.annot.DBAnnotatedColumn;
import ghidra.util.database.annot.DBAnnotatedField;
import ghidra.util.database.annot.DBAnnotatedObjectInfo;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Set;
import java.util.concurrent.locks.Lock;

@DBAnnotatedObjectInfo(version=0)
public class DBTraceMemoryRegion
extends DBTraceAddressSnapRangePropertyMapTree.AbstractDBTraceAddressSnapRangePropertyMapData<DBTraceMemoryRegion>
implements TraceMemoryRegion {
    public static final String TABLE_NAME = "MemoryRegions";
    public static final String PATH_COLUMN_NAME = "Path";
    public static final String NAME_COLUMN_NAME = "Name";
    public static final String FLAGS_COLUMN_NAME = "Flags";
    @DBAnnotatedColumn(value="Path")
    static DBObjectColumn PATH_COLUMN;
    @DBAnnotatedColumn(value="Name")
    static DBObjectColumn NAME_COLUMN;
    @DBAnnotatedColumn(value="Flags")
    static DBObjectColumn FLAGS_COLUMN;
    @DBAnnotatedField(column="Path", indexed=true)
    private String path;
    @DBAnnotatedField(column="Name")
    private String name;
    @DBAnnotatedField(column="Flags")
    private byte flagsByte = 0;
    private final DBTraceMemorySpace space;
    private final EnumSet<TraceMemoryFlag> flags = EnumSet.noneOf(TraceMemoryFlag.class);

    static String tableName(AddressSpace space, long threadKey) {
        return DBTraceUtils.tableName(TABLE_NAME, space, threadKey, 0);
    }

    public DBTraceMemoryRegion(DBTraceMemorySpace space, DBTraceAddressSnapRangePropertyMapTree<DBTraceMemoryRegion, DBTraceMemoryRegion> tree, DBCachedObjectStore<?> store, DBRecord record) {
        super(tree, store, record);
        this.space = space;
    }

    @Override
    protected void fresh(boolean created) throws IOException {
        super.fresh(created);
        if (created) {
            return;
        }
        this.flags.clear();
        TraceMemoryFlag.fromBits(this.flags, this.flagsByte);
    }

    protected void setRecordValue(DBTraceMemoryRegion value) {
    }

    protected DBTraceMemoryRegion getRecordValue() {
        return this;
    }

    void set(String path, String name, Collection<TraceMemoryFlag> flags) {
        this.path = path;
        this.name = name;
        this.flagsByte = 0;
        this.flags.clear();
        for (TraceMemoryFlag f : flags) {
            this.flagsByte = (byte)(this.flagsByte | f.getBits());
            this.flags.add(f);
        }
        this.update(PATH_COLUMN, NAME_COLUMN, FLAGS_COLUMN);
    }

    protected void checkOverlapConflicts(Range<Long> lifespan, AddressRange range) throws TraceOverlappedRegionException {
        Collection<? extends DBTraceMemoryRegion> overlapConflicts = this.space.getRegionsIntersecting(lifespan, range);
        for (TraceMemoryRegion traceMemoryRegion : overlapConflicts) {
            if (traceMemoryRegion == this) continue;
            throw new TraceOverlappedRegionException(overlapConflicts);
        }
    }

    protected void checkPathConflicts(Range<Long> lifespan, String path) throws DuplicateNameException {
        Collection<TraceMemoryRegion> pathConflicts = this.space.manager.getRegionsWithPathInLifespan(lifespan, path);
        for (TraceMemoryRegion c : pathConflicts) {
            if (c == this) continue;
            throw new DuplicateNameException("Only one region with a given path may occupy the same snap");
        }
    }

    @Override
    public DBTrace getTrace() {
        return this.space.trace;
    }

    @Override
    public String getPath() {
        try (LockHold hold = LockHold.lock((Lock)this.space.lock.readLock());){
            String string = this.path;
            return string;
        }
    }

    @Override
    public void setName(String name) {
        try (LockHold hold = LockHold.lock((Lock)this.space.lock.writeLock());){
            this.name = name;
            this.update(NAME_COLUMN);
            this.space.trace.updateViewsChangeRegionBlockName(this);
        }
        this.space.trace.setChanged(new TraceChangeRecord(Trace.TraceMemoryRegionChangeType.CHANGED, this.space, this));
    }

    @Override
    public String getName() {
        try (LockHold hold = LockHold.lock((Lock)this.space.lock.readLock());){
            String string = this.name;
            return string;
        }
    }

    @Override
    public void setLifespan(Range<Long> newLifespan) throws TraceOverlappedRegionException, DuplicateNameException {
        try (LockHold hold = LockHold.lock((Lock)this.space.lock.writeLock());){
            this.checkOverlapConflicts(newLifespan, this.range);
            this.checkPathConflicts(newLifespan, this.path);
            Range<Long> oldLifespan = this.getLifespan();
            this.doSetLifespan(newLifespan);
            this.space.trace.updateViewsChangeRegionBlockLifespan(this, oldLifespan, newLifespan);
            this.space.trace.setChanged(new TraceChangeRecord<DBTraceMemoryRegion, Range<Long>>(Trace.TraceMemoryRegionChangeType.LIFESPAN_CHANGED, this.space, this, oldLifespan, newLifespan));
        }
    }

    @Override
    public void setCreationSnap(long creationSnap) throws DuplicateNameException, TraceOverlappedRegionException {
        this.setLifespan(DBTraceUtils.toRange(creationSnap, this.getDestructionSnap()));
    }

    @Override
    public long getCreationSnap() {
        try (LockHold hold = LockHold.lock((Lock)this.space.lock.readLock());){
            long l = DBTraceUtils.lowerEndpoint((Range<Long>)this.lifespan);
            return l;
        }
    }

    @Override
    public void setDestructionSnap(long destructionSnap) throws DuplicateNameException, TraceOverlappedRegionException {
        this.setLifespan(DBTraceUtils.toRange(this.getCreationSnap(), destructionSnap));
    }

    @Override
    public long getDestructionSnap() {
        try (LockHold hold = LockHold.lock((Lock)this.space.lock.readLock());){
            long l = DBTraceUtils.upperEndpoint((Range<Long>)this.lifespan);
            return l;
        }
    }

    @Override
    public void setRange(AddressRange newRange) throws TraceOverlappedRegionException {
        try (LockHold hold = LockHold.lock((Lock)this.space.lock.writeLock());){
            if (this.range.equals(newRange)) {
                return;
            }
            AddressRange oldRange = this.range;
            this.checkOverlapConflicts((Range<Long>)this.lifespan, newRange);
            this.doSetRange(newRange);
            this.space.trace.updateViewsChangeRegionBlockRange(this, oldRange, newRange);
        }
        this.space.trace.setChanged(new TraceChangeRecord(Trace.TraceMemoryRegionChangeType.CHANGED, this.space, this));
    }

    @Override
    public void setMinAddress(Address min) throws TraceOverlappedRegionException {
        try (LockHold hold = LockHold.lock((Lock)this.space.lock.writeLock());){
            this.setRange(DBTraceUtils.toRange(min, this.range.getMaxAddress()));
        }
    }

    @Override
    public Address getMinAddress() {
        try (LockHold hold = LockHold.lock((Lock)this.space.lock.readLock());){
            Address address = this.range.getMinAddress();
            return address;
        }
    }

    @Override
    public void setMaxAddress(Address max) throws TraceOverlappedRegionException {
        try (LockHold hold = LockHold.lock((Lock)this.space.lock.writeLock());){
            this.setRange(DBTraceUtils.toRange(this.range.getMinAddress(), max));
        }
    }

    @Override
    public Address getMaxAddress() {
        try (LockHold hold = LockHold.lock((Lock)this.space.lock.readLock());){
            Address address = this.range.getMaxAddress();
            return address;
        }
    }

    @Override
    public void setLength(long length) throws AddressOverflowException, TraceOverlappedRegionException {
        try (LockHold hold = LockHold.lock((Lock)this.space.lock.writeLock());){
            Address minAddress = this.range.getMinAddress();
            this.setRange(DBTraceUtils.toRange(minAddress, minAddress.addNoWrap(length - 1L)));
        }
    }

    @Override
    public long getLength() {
        try (LockHold hold = LockHold.lock((Lock)this.space.lock.readLock());){
            long l = this.range.getLength();
            return l;
        }
    }

    @Override
    public void setFlags(Collection<TraceMemoryFlag> flags) {
        try (LockHold hold = LockHold.lock((Lock)this.space.lock.writeLock());){
            this.flagsByte = TraceMemoryFlag.toBits(flags);
            this.flags.clear();
            this.flags.addAll(flags);
            this.update(FLAGS_COLUMN);
            this.space.trace.updateViewsChangeRegionBlockFlags(this, (Range<Long>)this.lifespan);
        }
        this.space.trace.setChanged(new TraceChangeRecord(Trace.TraceMemoryRegionChangeType.CHANGED, this.space, this));
    }

    @Override
    public void addFlags(Collection<TraceMemoryFlag> flags) {
        try (LockHold hold = LockHold.lock((Lock)this.space.lock.writeLock());){
            this.flagsByte = (byte)(this.flagsByte | TraceMemoryFlag.toBits(flags));
            this.flags.addAll(flags);
            this.update(FLAGS_COLUMN);
            this.space.trace.updateViewsChangeRegionBlockFlags(this, (Range<Long>)this.lifespan);
        }
        this.space.trace.setChanged(new TraceChangeRecord(Trace.TraceMemoryRegionChangeType.CHANGED, this.space, this));
    }

    @Override
    public void clearFlags(Collection<TraceMemoryFlag> flags) {
        try (LockHold hold = LockHold.lock((Lock)this.space.lock.writeLock());){
            this.flagsByte = (byte)(this.flagsByte & ~TraceMemoryFlag.toBits(flags));
            this.flags.removeAll(flags);
            this.update(FLAGS_COLUMN);
            this.space.trace.updateViewsChangeRegionBlockFlags(this, (Range<Long>)this.lifespan);
        }
        this.space.trace.setChanged(new TraceChangeRecord(Trace.TraceMemoryRegionChangeType.CHANGED, this.space, this));
    }

    @Override
    public Set<TraceMemoryFlag> getFlags() {
        try (LockHold hold = LockHold.lock((Lock)this.space.lock.readLock());){
            Set<TraceMemoryFlag> set = Set.copyOf(this.flags);
            return set;
        }
    }

    @Override
    public void delete() {
        this.space.deleteRegion(this);
    }
}

