/*
 * Decompiled with CFR 0.152.
 */
package agent.dbgeng.model.impl;

import agent.dbgeng.manager.DbgModule;
import agent.dbgeng.manager.DbgModuleSection;
import agent.dbgeng.manager.DbgProcess;
import agent.dbgeng.model.iface2.DbgModelTargetModule;
import agent.dbgeng.model.impl.DbgModelTargetModuleContainerImpl;
import agent.dbgeng.model.impl.DbgModelTargetObjectImpl;
import agent.dbgeng.model.impl.DbgModelTargetSymbolContainerImpl;
import ghidra.dbg.target.TargetObject;
import ghidra.dbg.target.schema.TargetAttributeType;
import ghidra.dbg.target.schema.TargetElementType;
import ghidra.dbg.target.schema.TargetObjectSchemaInfo;
import ghidra.dbg.util.PathUtils;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressRangeImpl;
import ghidra.program.model.address.AddressSpace;
import java.util.List;
import java.util.Map;

@TargetObjectSchemaInfo(name="Module", elements={@TargetElementType(type=Void.class)}, attributes={@TargetAttributeType(name="Symbols", type=DbgModelTargetSymbolContainerImpl.class, required=true, fixed=true), @TargetAttributeType(name="BaseAddress", type=Address.class), @TargetAttributeType(name="ImageName", type=String.class), @TargetAttributeType(name="TimeStamp", type=Integer.class), @TargetAttributeType(name="Len", type=String.class), @TargetAttributeType(type=Void.class)})
public class DbgModelTargetModuleImpl
extends DbgModelTargetObjectImpl
implements DbgModelTargetModule {
    protected final DbgProcess process;
    protected final DbgModule module;
    protected final DbgModelTargetSymbolContainerImpl symbols;

    protected static String indexModule(DbgModule module) {
        return module.getName();
    }

    protected static String keyModule(DbgModule module) {
        return PathUtils.makeKey((String)DbgModelTargetModuleImpl.indexModule(module));
    }

    public DbgModelTargetModuleImpl(DbgModelTargetModuleContainerImpl modules, DbgModule module) {
        super(modules.getModel(), (TargetObject)modules, DbgModelTargetModuleImpl.keyModule(module), "Module");
        this.getModel().addModelObject(module, (TargetObject)this);
        this.process = modules.process;
        this.module = module;
        this.symbols = new DbgModelTargetSymbolContainerImpl(this);
        AddressSpace space = this.getModel().getAddressSpace("ram");
        this.changeAttributes(List.of(), List.of(this.symbols), Map.of("_display", this.getIndex(), "_short_display", module.getName(), "_module_name", module.getImageName(), "BaseAddress", space.getAddress(module.getKnownBase().longValue()), "ImageName", module.getImageName(), "TimeStamp", module.getTimeStamp(), "Len", Integer.toHexString(module.getSize())), "Initialized");
        DbgModuleSection section = new DbgModuleSection(module);
        Address min = space.getAddress(section.getStart().longValue());
        Address max = space.getAddress(section.getStart() + (long)section.getSize().intValue() - 1L);
        AddressRangeImpl range = new AddressRangeImpl(min, max);
        this.changeAttributes(List.of(), List.of(), Map.of("_range", range), "Initialized");
    }

    protected Address doGetBase() {
        return this.getModel().getAddressSpace("ram").getAddress(this.module.getKnownBase().longValue());
    }

    @Override
    public DbgModule getDbgModule() {
        return this.module;
    }

    public DbgProcess getProcess() {
        return this.process;
    }
}

