/*
 * Decompiled with CFR 0.152.
 */
package agent.dbgeng.model.impl;

import agent.dbgeng.manager.DbgEventFilter;
import agent.dbgeng.manager.cmd.DbgListEventFiltersCommand;
import agent.dbgeng.manager.impl.DbgManagerImpl;
import agent.dbgeng.manager.impl.DbgProcessImpl;
import agent.dbgeng.model.iface2.DbgModelTargetDebugContainer;
import agent.dbgeng.model.iface2.DbgModelTargetEvent;
import agent.dbgeng.model.iface2.DbgModelTargetEventContainer;
import agent.dbgeng.model.iface2.DbgModelTargetProcess;
import agent.dbgeng.model.impl.DbgModelTargetEventImpl;
import agent.dbgeng.model.impl.DbgModelTargetObjectImpl;
import ghidra.async.AsyncUtils;
import ghidra.dbg.target.TargetObject;
import ghidra.dbg.target.schema.TargetAttributeType;
import ghidra.dbg.target.schema.TargetElementType;
import ghidra.dbg.target.schema.TargetObjectSchemaInfo;
import ghidra.util.datastruct.WeakValueHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;

@TargetObjectSchemaInfo(name="EventContainer", elements={@TargetElementType(type=DbgModelTargetEventImpl.class)}, attributes={@TargetAttributeType(type=Void.class)}, canonicalContainer=true)
public class DbgModelTargetEventContainerImpl
extends DbgModelTargetObjectImpl
implements DbgModelTargetEventContainer {
    protected final DbgModelTargetDebugContainer debug;
    protected final Map<String, DbgModelTargetEventImpl> events = new WeakValueHashMap();

    public DbgModelTargetEventContainerImpl(DbgModelTargetDebugContainer debug) {
        super(debug.getModel(), (TargetObject)debug, "Events", "EventContainer");
        this.debug = debug;
        this.requestElements(true);
    }

    public CompletableFuture<Void> requestElements(boolean refresh) {
        DbgModelTargetProcess targetProcess = this.getParentProcess();
        DbgProcessImpl currentProcess = this.getManager().getCurrentProcess();
        if (!refresh || currentProcess != null && !currentProcess.equals(targetProcess.getProcess())) {
            return AsyncUtils.NIL;
        }
        return this.listEventFilters().thenAccept(byName -> {
            List eventObjs;
            DbgModelTargetEventContainerImpl dbgModelTargetEventContainerImpl = this;
            synchronized (dbgModelTargetEventContainerImpl) {
                eventObjs = byName.stream().map(this::getTargetEvent).collect(Collectors.toList());
            }
            this.setElements(eventObjs, Map.of(), "Refreshed");
        });
    }

    public synchronized DbgModelTargetEvent getTargetEvent(DbgEventFilter filter) {
        String id = filter.getName();
        DbgModelTargetEventImpl event = this.events.get(id);
        if (event != null && event.getFilter().getName().equals(id)) {
            return event;
        }
        event = new DbgModelTargetEventImpl(this, filter);
        this.events.put(filter.getName(), event);
        return event;
    }

    public CompletableFuture<List<DbgEventFilter>> listEventFilters() {
        DbgManagerImpl manager = this.getManager();
        return manager.execute(new DbgListEventFiltersCommand(manager));
    }
}

