/*
 * Decompiled with CFR 0.152.
 */
package agent.dbgeng.model.iface2;

import agent.dbgeng.dbgeng.DebugClient;
import agent.dbgeng.manager.impl.DbgManagerImpl;
import agent.dbgeng.model.AbstractDbgModel;
import agent.dbgeng.model.iface2.DbgModelTargetProcess;
import agent.dbgeng.model.iface2.DbgModelTargetSession;
import agent.dbgeng.model.iface2.DbgModelTargetThread;
import ghidra.async.AsyncUtils;
import ghidra.dbg.DebuggerModelListener;
import ghidra.dbg.agent.SpiTargetObject;
import ghidra.dbg.target.TargetObject;
import ghidra.dbg.util.CollectionUtils;
import ghidra.util.datastruct.ListenerSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;

public interface DbgModelTargetObject
extends SpiTargetObject {
    public AbstractDbgModel getModel();

    default public DbgManagerImpl getManager() {
        return (DbgManagerImpl)this.getModel().getManager();
    }

    default public CompletableFuture<Void> init(Map<String, Object> map) {
        return CompletableFuture.completedFuture(null);
    }

    default public DbgManagerImpl getManagerWithCheck() {
        DbgManagerImpl impl = (DbgManagerImpl)this.getModel().getManager();
        if (impl == null) {
            return impl;
        }
        DebugClient.DebugStatus status = impl.getControl().getExecutionStatus();
        if (status.equals((Object)DebugClient.DebugStatus.GO)) {
            System.err.println("Attempt to access DbgManager while GO");
            throw new RuntimeException("Attempt to access DbgManager while GO");
        }
        return impl;
    }

    public CollectionUtils.Delta<?, ?> changeAttributes(List<String> var1, Map<String, ?> var2, String var3);

    public CompletableFuture<? extends Map<String, ?>> requestNativeAttributes();

    default public CompletableFuture<Void> requestAugmentedAttributes() {
        return AsyncUtils.NIL;
    }

    public CompletableFuture<List<TargetObject>> requestNativeElements();

    public ListenerSet<DebuggerModelListener> getListeners();

    public DbgModelTargetSession getParentSession();

    public DbgModelTargetProcess getParentProcess();

    public DbgModelTargetThread getParentThread();

    public TargetObject getProxy();

    public void setModified(Map<String, Object> var1, boolean var2);

    public void setModified(boolean var1);

    public void resetModified();
}

