/*
 * Decompiled with CFR 0.152.
 */
package agent.dbgeng;

import agent.dbgeng.model.impl.DbgModelImpl;
import ghidra.dbg.DebuggerModelFactory;
import ghidra.dbg.DebuggerObjectModel;
import ghidra.dbg.util.ConfigurableFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;

@ConfigurableFactory.FactoryDescription(brief="IN-VM MS dbgeng local debugger", htmlDetails="Launch a dbgeng session in this same JVM")
public class DbgEngInJvmDebuggerModelFactory
implements DebuggerModelFactory {
    protected String remote = "none";
    @ConfigurableFactory.FactoryOption(value="DebugConnect options (.server)")
    public final ConfigurableFactory.Property<String> agentRemoteOption = ConfigurableFactory.Property.fromAccessors(String.class, this::getAgentRemote, this::setAgentRemote);
    protected String transport = "none";
    @ConfigurableFactory.FactoryOption(value="Remote process server options (untested)")
    public final ConfigurableFactory.Property<String> agentTransportOption = ConfigurableFactory.Property.fromAccessors(String.class, this::getAgentTransport, this::setAgentTransport);

    public CompletableFuture<? extends DebuggerObjectModel> build() {
        DbgModelImpl model = new DbgModelImpl();
        ArrayList<String> cmds = new ArrayList<String>();
        this.completeCommandLine(cmds);
        return model.startDbgEng(cmds.toArray(new String[cmds.size()])).thenApply(__ -> model);
    }

    public boolean isCompatible() {
        return System.getProperty("os.name").toLowerCase().contains("windows");
    }

    public String getAgentTransport() {
        return this.transport;
    }

    public void setAgentTransport(String transport) {
        this.transport = transport;
    }

    public String getAgentRemote() {
        return this.remote;
    }

    public void setAgentRemote(String remote) {
        this.remote = remote;
    }

    protected void completeCommandLine(List<String> cmd) {
        if (!this.remote.equals("none")) {
            cmd.addAll(List.of(this.remote));
        }
        if (!this.transport.equals("none")) {
            cmd.addAll(List.of(this.transport));
        }
    }
}

