/*
 * Decompiled with CFR 0.152.
 */
package org.jungrapht.visualization.layout.util;

import org.jungrapht.visualization.layout.algorithms.util.IterativeContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VisRunnable
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(VisRunnable.class);
    private final IterativeContext iterativeContext;
    private long sleepTime = 10L;
    private boolean stop = false;

    public static VisRunnable noop() {
        return new VisRunnable(null){

            @Override
            public void run() {
            }
        };
    }

    public VisRunnable(IterativeContext iterativeContext) {
        log.trace("created a VisRunnable {} for {}", (Object)this.hashCode(), (Object)iterativeContext);
        this.iterativeContext = iterativeContext;
    }

    public void stop() {
        log.trace("told {} to stop", (Object)this);
        this.stop = true;
    }

    @Override
    public void run() {
        while (!this.iterativeContext.done() && !this.stop) {
            try {
                this.iterativeContext.step();
                try {
                    Thread.sleep(this.sleepTime);
                }
                catch (InterruptedException interruptedException) {
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        if (this.stop) {
            log.trace("done here because {} stop = {}", (Object)this.hashCode(), (Object)this.stop);
        }
    }
}

