/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pdb2.pdbreader;

import ghidra.app.util.bin.format.pdb2.pdbreader.AbstractPdb;
import ghidra.app.util.bin.format.pdb2.pdbreader.Pdb200;
import ghidra.app.util.bin.format.pdb2.pdbreader.Pdb400;
import ghidra.app.util.bin.format.pdb2.pdbreader.Pdb700;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbException;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbReaderOptions;
import ghidra.app.util.bin.format.pdb2.pdbreader.msf.Msf;
import ghidra.app.util.bin.format.pdb2.pdbreader.msf.MsfParser;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.util.Objects;

public class PdbParser {
    public static final int VC2_ID = 19941610;
    public static final int VC4_ID = 19950623;
    public static final int VC41_ID = 19950814;
    public static final int VC50_ID = 19960307;
    public static final int VC98_ID = 19970604;
    public static final int VC70DEP_ID = 19990604;
    public static final int VC70_ID = 20000404;
    public static final int VC80_ID = 20030901;
    public static final int VC110_ID = 20091201;
    public static final int VC140_ID = 20140508;

    public static AbstractPdb parse(String filename, PdbReaderOptions pdbOptions, TaskMonitor monitor) throws IOException, PdbException, CancelledException {
        Objects.requireNonNull(filename, "filename cannot be null");
        Objects.requireNonNull(pdbOptions, "pdbOptions cannot be null");
        Objects.requireNonNull(monitor, "monitor cannot be null");
        Msf msf = MsfParser.parse(filename, pdbOptions, monitor);
        int versionNumber = AbstractPdb.deserializeVersionNumber(msf, monitor);
        AbstractPdb pdb = switch (versionNumber) {
            case 19941610 -> new Pdb200(msf, pdbOptions);
            case 19950623, 19950814, 19960307, 19970604, 19990604 -> new Pdb400(msf, pdbOptions);
            case 20000404, 20030901, 20091201, 20140508 -> new Pdb700(msf, pdbOptions);
            default -> {
                msf.close();
                throw new PdbException("Unknown PDB Version: " + versionNumber);
            }
        };
        pdb.deserializeIdentifiersOnly(monitor);
        return pdb;
    }
}

