/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pdb2.pdbreader;

import ghidra.app.util.bin.format.pdb2.pdbreader.AbstractPdb;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbByteReader;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbException;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbReaderOptions;
import ghidra.app.util.bin.format.pdb2.pdbreader.msf.Msf;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.io.Writer;

public class Pdb700
extends AbstractPdb {
    Pdb700(Msf msf, PdbReaderOptions pdbOptions) throws IOException, PdbException {
        super(msf, pdbOptions);
    }

    @Override
    void deserializeIdentifiersOnly(TaskMonitor monitor) throws IOException, PdbException, CancelledException {
        PdbByteReader reader = this.getDirectoryReader();
        this.deserializeVersionSignatureAge(reader);
        this.guid = reader.parseGUID();
    }

    @Override
    void deserializeDirectory() throws IOException, PdbException, CancelledException {
        PdbByteReader reader = this.getDirectoryReader();
        this.deserializeVersionSignatureAge(reader);
        this.guid = reader.parseGUID();
        this.deserializeParameters(reader);
    }

    @Override
    public void dumpDirectory(Writer writer) throws IOException {
        StringBuilder builder = new StringBuilder();
        builder.append(this.dumpVersionSignatureAge());
        builder.append("\n");
        builder.append(this.dumpGUID());
        builder.append("\n");
        builder.append(this.dumpParameters());
        writer.write(builder.toString());
    }

    protected String dumpGUID() {
        if (this.guid == null) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        builder.append("GUID: ");
        builder.append(this.guid);
        return builder.toString();
    }
}

