/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pdb2.pdbreader;

import ghidra.app.util.bin.format.pdb2.pdbreader.AbstractPdb;
import ghidra.app.util.bin.format.pdb2.pdbreader.AbstractSymbolInformation;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbByteReader;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbException;
import ghidra.util.exception.CancelledException;
import java.io.IOException;
import java.io.Writer;

public class GlobalSymbolInformation
extends AbstractSymbolInformation {
    public GlobalSymbolInformation(AbstractPdb pdbIn) {
        super(pdbIn);
    }

    @Override
    void deserialize(int streamNumber) throws IOException, PdbException, CancelledException {
        super.deserialize(streamNumber);
        PdbByteReader reader = this.pdb.getReaderForStreamNumber(streamNumber);
        this.deserializeHashTable(reader);
        this.generateSymbolsList();
    }

    @Override
    void dump(Writer writer) throws IOException, CancelledException {
        StringBuilder builder = new StringBuilder();
        builder.append("GlobalSymbolInformation-------------------------------------\n");
        this.dumpHashHeader(builder);
        this.dumpHashBasics(builder);
        this.dumpHashRecords(builder);
        builder.append("\nEnd GlobalSymbolInformation---------------------------------\n");
        writer.write(builder.toString());
    }
}

