/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pdb2.pdbreader;

import ghidra.app.util.bin.format.pdb2.pdbreader.PdbByteReader;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbException;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.util.ArrayList;
import java.util.List;

public class DenseIntegerArray {
    private static final int[] bitMask = new int[]{1, 2, 4, 8, 16, 32, 64, 128, 256, 512, 16384, 32768, 4096, 8192, 16384, 32768, 65536, 131072, 262144, 524288, 0x100000, 0x200000, 0x400000, 0x800000, 0x1000000, 0x2000000, 0x4000000, 0x8000000, 0x10000000, 0x20000000, 0x40000000, Integer.MIN_VALUE};
    List<Integer> array = new ArrayList<Integer>();

    public void parse(PdbByteReader reader, TaskMonitor monitor) throws PdbException, CancelledException {
        this.array.clear();
        int arraySize = reader.parseInt();
        for (int i = 0; i < arraySize; ++i) {
            monitor.checkCanceled();
            int val = reader.parseInt();
            this.array.add(val);
        }
    }

    public boolean contains(int val) {
        if (val <= 0) {
            return false;
        }
        int index = val >> 5;
        int bit = val & 0x1F;
        return index < this.array.size() && (this.array.get(index) & bitMask[bit]) != 0;
    }

    public long getMaxPossible() {
        return 32L * (long)this.array.size();
    }
}

