/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.plugintool.dialog;

import docking.widgets.OptionDialog;
import docking.widgets.table.AbstractDynamicTableColumn;
import docking.widgets.table.DynamicTableColumn;
import docking.widgets.table.TableColumnDescriptor;
import docking.widgets.table.threaded.ThreadedTableModel;
import ghidra.docking.settings.Settings;
import ghidra.framework.plugintool.PluginConfigurationModel;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.ServiceProvider;
import ghidra.framework.plugintool.util.PluginDescription;
import ghidra.framework.plugintool.util.PluginStatus;
import ghidra.util.HTMLUtilities;
import ghidra.util.datastruct.Accumulator;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskLauncher;
import ghidra.util.task.TaskMonitor;
import java.awt.Component;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.swing.Icon;
import javax.swing.JComponent;
import resources.Icons;
import resources.ResourceManager;

class PluginInstallerTableModel
extends ThreadedTableModel<PluginDescription, List<PluginDescription>> {
    static final int INSTALLED_COL = 0;
    static final int STATUS_COL = 1;
    static final int NAME_COL = 2;
    public static final Icon EXPERIMENTAL_ICON = ResourceManager.loadImage((String)"images/warning.png");
    public static final Icon DEV_ICON = Icons.STRONG_WARNING_ICON;
    private static Map<PluginStatus, Icon> statusIconMap = new HashMap<PluginStatus, Icon>();
    private PluginConfigurationModel model;
    private List<PluginDescription> pluginDescriptions;
    private JComponent parentComponent;

    protected PluginInstallerTableModel(PluginTool tool, JComponent parentComponent, List<PluginDescription> pluginDescriptions, PluginConfigurationModel model) {
        super("Plugins", (ServiceProvider)tool);
        this.parentComponent = parentComponent;
        this.model = model;
        this.pluginDescriptions = pluginDescriptions;
    }

    protected TableColumnDescriptor<PluginDescription> createTableColumnDescriptor() {
        TableColumnDescriptor descriptor = new TableColumnDescriptor();
        descriptor.addVisibleColumn((DynamicTableColumn)new PluginInstalledColumn(), -1, false);
        descriptor.addVisibleColumn((DynamicTableColumn)new PluginStatusColumn());
        descriptor.addVisibleColumn((DynamicTableColumn)new PluginNameColumn(), 1, true);
        descriptor.addVisibleColumn((DynamicTableColumn)new PluginDescriptionColumn());
        descriptor.addVisibleColumn((DynamicTableColumn)new PluginCategoryColumn());
        return descriptor;
    }

    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return columnIndex == 0;
    }

    public int getPrimarySortColumnIndex() {
        return 2;
    }

    public List<PluginDescription> getDataSource() {
        return this.pluginDescriptions;
    }

    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        super.setValueAt(aValue, rowIndex, columnIndex);
        if (columnIndex != 0) {
            return;
        }
        PluginDescription targetPluginDescription = (PluginDescription)this.getRowObject(rowIndex);
        boolean install = (Boolean)aValue;
        if (install) {
            this.addPlugin(targetPluginDescription);
        } else {
            List<PluginDescription> pluginsThatUseTarget = this.model.getDependencies(targetPluginDescription);
            String dependenciesToUnloadHtmlList = pluginsThatUseTarget.stream().map(PluginDescription::getName).sorted().collect(Collectors.joining("<li>", "<ul><li>", "</ul>"));
            if (pluginsThatUseTarget.isEmpty() || OptionDialog.showYesNoDialog((Component)this.parentComponent, (String)"Confirm plugin removal", (String)("<html>Other plugins depend on " + HTMLUtilities.escapeHTML((String)targetPluginDescription.getName()) + "<p><p>Removing it will also remove:" + dependenciesToUnloadHtmlList + "<p><p>Continue?")) == 1) {
                this.model.removePlugin(targetPluginDescription);
            }
        }
        this.parentComponent.repaint();
    }

    protected void doLoad(Accumulator<PluginDescription> accumulator, TaskMonitor monitor) throws CancelledException {
        accumulator.addAll(this.pluginDescriptions);
    }

    private void addPlugin(PluginDescription plugin) {
        if (!plugin.isSlowInstallation()) {
            this.model.addPlugin(plugin);
            return;
        }
        TaskLauncher.launchModal((String)"Adding Plugin", () -> this.model.addPlugin(plugin));
    }

    static {
        statusIconMap.put(PluginStatus.UNSTABLE, DEV_ICON);
        statusIconMap.put(PluginStatus.STABLE, EXPERIMENTAL_ICON);
    }

    class PluginInstalledColumn
    extends AbstractDynamicTableColumn<PluginDescription, Boolean, List<PluginDescription>> {
        PluginInstalledColumn() {
        }

        public String getColumnName() {
            return "Installation Status";
        }

        public int getColumnPreferredWidth() {
            return 25;
        }

        public Boolean getValue(PluginDescription rowObject, Settings settings, List<PluginDescription> data, ServiceProvider sp) throws IllegalArgumentException {
            return PluginInstallerTableModel.this.model.isLoaded(rowObject);
        }
    }

    class PluginStatusColumn
    extends AbstractDynamicTableColumn<PluginDescription, Icon, List<PluginDescription>> {
        PluginStatusColumn() {
        }

        public String getColumnName() {
            return "Status";
        }

        public int getColumnPreferredWidth() {
            return 25;
        }

        public Icon getValue(PluginDescription rowObject, Settings settings, List<PluginDescription> data, ServiceProvider sp) throws IllegalArgumentException {
            return statusIconMap.get((Object)rowObject.getStatus());
        }
    }

    class PluginNameColumn
    extends AbstractDynamicTableColumn<PluginDescription, String, List<PluginDescription>> {
        PluginNameColumn() {
        }

        public String getColumnName() {
            return "Name";
        }

        public int getColumnPreferredWidth() {
            return 200;
        }

        public String getValue(PluginDescription rowObject, Settings settings, List<PluginDescription> data, ServiceProvider sp) throws IllegalArgumentException {
            return rowObject.getName();
        }
    }

    class PluginDescriptionColumn
    extends AbstractDynamicTableColumn<PluginDescription, String, List<PluginDescription>> {
        PluginDescriptionColumn() {
        }

        public String getColumnName() {
            return "Description";
        }

        public int getColumnPreferredWidth() {
            return 200;
        }

        public String getValue(PluginDescription rowObject, Settings settings, List<PluginDescription> data, ServiceProvider sp) throws IllegalArgumentException {
            return rowObject.getShortDescription();
        }
    }

    class PluginCategoryColumn
    extends AbstractDynamicTableColumn<PluginDescription, String, List<PluginDescription>> {
        PluginCategoryColumn() {
        }

        public String getColumnName() {
            return "Category";
        }

        public int getColumnPreferredWidth() {
            return 200;
        }

        public String getValue(PluginDescription rowObject, Settings settings, List<PluginDescription> data, ServiceProvider sp) throws IllegalArgumentException {
            return rowObject.getCategory();
        }
    }
}

