/*
 * Decompiled with CFR 0.152.
 */
package ghidra.graph;

import docking.Tool;
import ghidra.framework.plugintool.PluginTool;
import ghidra.graph.ProgramGraphType;
import ghidra.service.graph.GraphDisplayOptions;
import ghidra.service.graph.GraphType;
import ghidra.service.graph.VertexShape;
import ghidra.util.WebColors;

public class ProgramGraphDisplayOptions
extends GraphDisplayOptions {
    public ProgramGraphDisplayOptions(ProgramGraphType graphType, PluginTool tool) {
        super((GraphType)graphType, (Tool)tool);
    }

    protected void initializeDefaults() {
        this.setDefaultVertexShape(VertexShape.ELLIPSE);
        this.setDefaultVertexColor(WebColors.RED);
        this.setDefaultEdgeColor(WebColors.RED);
        this.setFavoredEdgeType(ProgramGraphType.FALL_THROUGH);
        this.configureVertexType(ProgramGraphType.BODY, VertexShape.RECTANGLE, WebColors.BLUE);
        this.configureVertexType(ProgramGraphType.ENTRY, VertexShape.TRIANGLE_DOWN, WebColors.DARK_ORANGE);
        this.configureVertexType(ProgramGraphType.EXIT, VertexShape.TRIANGLE_UP, WebColors.DARK_MAGENTA);
        this.configureVertexType(ProgramGraphType.SWITCH, VertexShape.DIAMOND, WebColors.DARK_CYAN);
        this.configureVertexType(ProgramGraphType.EXTERNAL, VertexShape.RECTANGLE, WebColors.DARK_GREEN);
        this.configureVertexType(ProgramGraphType.BAD, VertexShape.ELLIPSE, WebColors.RED);
        this.configureVertexType(ProgramGraphType.DATA, VertexShape.ELLIPSE, WebColors.PINK);
        this.configureVertexType(ProgramGraphType.ENTRY_NEXUS, VertexShape.ELLIPSE, WebColors.WHEAT);
        this.configureVertexType(ProgramGraphType.INSTRUCTION, VertexShape.HEXAGON, WebColors.BLUE);
        this.configureVertexType(ProgramGraphType.STACK, VertexShape.RECTANGLE, WebColors.GREEN);
        this.configureEdgeType(ProgramGraphType.ENTRY_EDGE, WebColors.GRAY);
        this.configureEdgeType(ProgramGraphType.FALL_THROUGH, WebColors.BLUE);
        this.configureEdgeType(ProgramGraphType.UNCONDITIONAL_JUMP, WebColors.DARK_GREEN);
        this.configureEdgeType(ProgramGraphType.UNCONDITIONAL_CALL, WebColors.DARK_ORANGE);
        this.configureEdgeType(ProgramGraphType.TERMINATOR, WebColors.PURPLE);
        this.configureEdgeType(ProgramGraphType.JUMP_TERMINATOR, WebColors.PURPLE);
        this.configureEdgeType(ProgramGraphType.INDIRECTION, WebColors.PINK);
        this.configureEdgeType(ProgramGraphType.CONDITIONAL_JUMP, WebColors.DARK_GOLDENROD);
        this.configureEdgeType(ProgramGraphType.CONDITIONAL_CALL, WebColors.DARK_ORANGE);
        this.configureEdgeType(ProgramGraphType.CONDITIONAL_TERMINATOR, WebColors.PURPLE);
        this.configureEdgeType(ProgramGraphType.CONDITIONAL_CALL_TERMINATOR, WebColors.PURPLE);
        this.configureEdgeType(ProgramGraphType.COMPUTED_JUMP, WebColors.CYAN);
        this.configureEdgeType(ProgramGraphType.COMPUTED_CALL, WebColors.CYAN);
        this.configureEdgeType(ProgramGraphType.COMPUTED_CALL_TERMINATOR, WebColors.PURPLE);
        this.configureEdgeType(ProgramGraphType.CONDITIONAL_COMPUTED_CALL, WebColors.CYAN);
        this.configureEdgeType(ProgramGraphType.CONDITIONAL_COMPUTED_JUMP, WebColors.CYAN);
        this.configureEdgeType(ProgramGraphType.CALL_OVERRIDE_UNCONDITIONAL, WebColors.RED);
        this.configureEdgeType(ProgramGraphType.JUMP_OVERRIDE_UNCONDITIONAL, WebColors.RED);
        this.configureEdgeType(ProgramGraphType.CALLOTHER_OVERRIDE_CALL, WebColors.RED);
        this.configureEdgeType(ProgramGraphType.CALLOTHER_OVERRIDE_JUMP, WebColors.RED);
        this.configureEdgeType(ProgramGraphType.READ, WebColors.GREEN);
        this.configureEdgeType(ProgramGraphType.WRITE, WebColors.RED);
        this.configureEdgeType(ProgramGraphType.READ_WRITE, WebColors.DARK_GOLDENROD);
        this.configureEdgeType(ProgramGraphType.UNKNOWN_DATA, WebColors.BLACK);
        this.configureEdgeType(ProgramGraphType.EXTERNAL_REF, WebColors.PURPLE);
        this.configureEdgeType(ProgramGraphType.READ_INDIRECT, WebColors.DARK_GREEN);
        this.configureEdgeType(ProgramGraphType.WRITE_INDIRECT, WebColors.DARK_RED);
        this.configureEdgeType(ProgramGraphType.READ_WRITE_INDIRECT, WebColors.BROWN);
        this.configureEdgeType(ProgramGraphType.DATA_INDIRECT, WebColors.DARK_ORANGE);
        this.configureEdgeType(ProgramGraphType.PARAM, WebColors.CYAN);
        this.configureEdgeType(ProgramGraphType.THUNK, WebColors.BLUE);
    }
}

