/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.main;

import ghidra.framework.options.Options;
import ghidra.framework.options.OptionsChangeListener;
import ghidra.framework.options.ToolOptions;
import ghidra.framework.plugintool.PluginTool;
import ghidra.util.Msg;
import ghidra.util.SystemUtilities;
import ghidra.util.exception.AssertException;
import ghidra.util.task.SwingUpdateManager;
import java.awt.Color;
import java.awt.Font;
import java.util.LinkedList;
import javax.swing.JTextPane;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.DefaultCaret;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;

public class ConsoleTextPane
extends JTextPane
implements OptionsChangeListener {
    private static final String CUSTOM_ATTRIBUTE_KEY = ConsoleTextPane.class.getName();
    private static final String OUTPUT_ATTRIBUTE_VALUE = "OUTPUT";
    private static final String ERROR_ATTRIBUTE_VALUE = "ERROR";
    private static final String OPTIONS_NAME = "Console";
    private static final String MAXIMUM_CHARACTERS_OPTION_NAME = "Character Limit";
    private static final String TRUNCATION_FACTOR_OPTION_NAME = "Truncation Factor";
    private static final int DEFAULT_MAXIMUM_CHARS = 50000;
    private static final int MINIMUM_MAXIMUM_CHARS = 1000;
    private static final int MAX_UPDATE_INTERVAL_MS = 100;
    private static double DEFAULT_TRUNCATION_FACTOR = 0.1;
    private static SimpleAttributeSet outputAttributeSet;
    private static SimpleAttributeSet errorAttributeSet;
    private SwingUpdateManager updateManager = new SwingUpdateManager(100, 1000, () -> this.doUpdate());
    private LinkedList<MessageWrapper> messageList = new LinkedList();
    private boolean scrollLock;
    private int maximumCharacterLimit = 50000;
    private double truncationFactor = DEFAULT_TRUNCATION_FACTOR;

    public ConsoleTextPane(PluginTool tool) {
        this.createAttribtues();
        this.setEditable(true);
        ToolOptions options = tool.getOptions(OPTIONS_NAME);
        options.addOptionsChangeListener((OptionsChangeListener)this);
        this.initOptions((Options)options);
    }

    public void setScrollLock(boolean lock) {
        this.scrollLock = lock;
        this.updateCaretSelectionPolicy(lock);
    }

    public void addMessage(String message) {
        this.doAddMessage(new MessageWrapper(message));
    }

    public void addPartialMessage(String message) {
        this.doAddMessage(new MessageWrapper(message));
    }

    public void addErrorMessage(String message) {
        this.doAddMessage(new ErrorMessage(message));
    }

    public void optionsChanged(ToolOptions options, String name, Object oldValue, Object newValue) {
        if (MAXIMUM_CHARACTERS_OPTION_NAME.equals(name) || TRUNCATION_FACTOR_OPTION_NAME.equals(name)) {
            this.updateFromOptions((Options)options);
        }
    }

    private void initOptions(Options options) {
        options.registerOption(MAXIMUM_CHARACTERS_OPTION_NAME, (Object)50000, null, "The maximum number of characters to display before truncating characters from the top of the console.");
        options.registerOption(TRUNCATION_FACTOR_OPTION_NAME, (Object)DEFAULT_TRUNCATION_FACTOR, null, "The factor (when multiplied by the Character Limit) by which to remove characters when truncating is necessary.");
        this.updateFromOptions(options);
    }

    private void updateFromOptions(Options options) {
        int newLimit = options.getInt(MAXIMUM_CHARACTERS_OPTION_NAME, 50000);
        this.truncationFactor = options.getDouble(TRUNCATION_FACTOR_OPTION_NAME, DEFAULT_TRUNCATION_FACTOR);
        this.setMaximumCharacterLimit(newLimit);
    }

    void setMaximumCharacterLimit(int limit) {
        this.maximumCharacterLimit = Math.max(limit, 1000);
    }

    int getMaximumCharacterLimit() {
        return this.maximumCharacterLimit;
    }

    private void updateCaretSelectionPolicy(boolean lockSelection) {
        Caret caret = this.getCaret();
        if (caret instanceof DefaultCaret) {
            DefaultCaret defaultCaret = (DefaultCaret)caret;
            if (lockSelection) {
                defaultCaret.setUpdatePolicy(1);
            } else {
                defaultCaret.setUpdatePolicy(2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doAddMessage(MessageWrapper newMessage) {
        LinkedList<MessageWrapper> linkedList = this.messageList;
        synchronized (linkedList) {
            MessageWrapper lastMessage;
            if (!this.messageList.isEmpty() && (lastMessage = this.messageList.getLast()).merge(newMessage)) {
                return;
            }
            this.messageList.add(newMessage);
        }
        this.updateManager.update();
    }

    @Override
    public void setFont(Font font) {
        this.createAttributes(font);
        this.updateCurrentTextWithNewFont();
        super.setFont(font);
    }

    private void updateCurrentTextWithNewFont() {
        Document document = this.getDocument();
        if (document == null) {
            return;
        }
        SystemUtilities.assertTrue((boolean)(document instanceof StyledDocument), (String)(this.getClass().getName() + " is designed to work with StyledDocuments"));
        StyledDocument styledDocument = (StyledDocument)document;
        int length = document.getLength();
        int i = 0;
        while (i < length) {
            Element element = styledDocument.getCharacterElement(i);
            int elementStart = i;
            int elementLen = element.getEndOffset() - elementStart;
            i = element.getEndOffset();
            AttributeSet replacementAttributeSet = this.getAttributeSetByName((String)element.getAttributes().getAttribute(CUSTOM_ATTRIBUTE_KEY));
            styledDocument.setCharacterAttributes(elementStart, elementLen, replacementAttributeSet, true);
        }
    }

    private AttributeSet getAttributeSetByName(String attributeSetName) {
        if (OUTPUT_ATTRIBUTE_VALUE.equals(attributeSetName)) {
            return outputAttributeSet;
        }
        if (ERROR_ATTRIBUTE_VALUE.equals(attributeSetName)) {
            return errorAttributeSet;
        }
        throw new AssertException("Unexpected attribute type for text");
    }

    private void createAttribtues() {
        this.createAttributes(new Font("monospaced", 0, 12));
    }

    private void createAttributes(Font font) {
        outputAttributeSet = new SimpleAttributeSet();
        outputAttributeSet.addAttribute(CUSTOM_ATTRIBUTE_KEY, OUTPUT_ATTRIBUTE_VALUE);
        outputAttributeSet.addAttribute(StyleConstants.FontFamily, font.getFamily());
        outputAttributeSet.addAttribute(StyleConstants.FontSize, font.getSize());
        outputAttributeSet.addAttribute(StyleConstants.Italic, font.isItalic());
        outputAttributeSet.addAttribute(StyleConstants.Bold, font.isBold());
        outputAttributeSet.addAttribute(StyleConstants.Foreground, Color.BLACK);
        errorAttributeSet = new SimpleAttributeSet();
        errorAttributeSet.addAttribute(CUSTOM_ATTRIBUTE_KEY, ERROR_ATTRIBUTE_VALUE);
        errorAttributeSet.addAttribute(StyleConstants.FontFamily, font.getFamily());
        errorAttributeSet.addAttribute(StyleConstants.FontSize, font.getSize());
        errorAttributeSet.addAttribute(StyleConstants.Italic, font.isItalic());
        errorAttributeSet.addAttribute(StyleConstants.Bold, font.isBold());
        errorAttributeSet.addAttribute(StyleConstants.Foreground, Color.RED);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doUpdate() {
        long stopMS = System.currentTimeMillis() + 100L;
        int caretPos = this.getCaretPosition();
        boolean caretInvalidated = false;
        LinkedList<MessageWrapper> linkedList = this.messageList;
        synchronized (linkedList) {
            while (!this.messageList.isEmpty() && System.currentTimeMillis() < stopMS) {
                MessageWrapper msg = this.messageList.removeFirst();
                caretInvalidated |= this.appendString(msg.getMessage(), msg.getAttributes());
            }
            if (!this.messageList.isEmpty()) {
                this.updateManager.updateLater();
            }
        }
        if (!this.scrollLock || caretInvalidated) {
            int newDocLen = this.getDocument().getLength();
            this.setCaretPosition(this.scrollLock ? Math.min(caretPos, newDocLen) : newDocLen);
        }
    }

    private boolean appendString(CharSequence message, AttributeSet attributeSet) {
        if (message.length() > this.maximumCharacterLimit) {
            int delta = message.length() - this.maximumCharacterLimit;
            message = message.subSequence(delta, message.length());
        }
        try {
            Document document = this.getDocument();
            int overage = document.getLength() + message.length() - this.maximumCharacterLimit;
            if (overage <= 0) {
                document.insertString(document.getLength(), message.toString(), attributeSet);
                return false;
            }
            int truncationAmount = (int)((double)this.maximumCharacterLimit * this.truncationFactor);
            int docToTrim = Math.min(overage + truncationAmount, document.getLength());
            int caretPos = this.getCaretPosition();
            document.remove(0, docToTrim);
            document.insertString(document.getLength(), message.toString(), attributeSet);
            return caretPos < docToTrim;
        }
        catch (BadLocationException e) {
            Msg.debug((Object)this, (Object)"Unexpected exception updating text", (Throwable)e);
            return false;
        }
    }

    public void dispose() {
        this.updateManager.dispose();
    }

    private static class MessageWrapper {
        private final StringBuilder message;

        private MessageWrapper(String message) {
            if (message == null) {
                throw new AssertException("Attempted to log a null message.");
            }
            this.message = new StringBuilder(message);
        }

        CharSequence getMessage() {
            return this.message;
        }

        boolean merge(MessageWrapper other) {
            if (this.getClass() != other.getClass()) {
                return false;
            }
            this.message.append((CharSequence)other.message);
            return true;
        }

        AttributeSet getAttributes() {
            return outputAttributeSet;
        }
    }

    private static class ErrorMessage
    extends MessageWrapper {
        private ErrorMessage(String message) {
            super(message);
        }

        @Override
        AttributeSet getAttributes() {
            return errorAttributeSet;
        }
    }
}

