/*
 * Decompiled with CFR 0.152.
 */
package ghidra.base.help;

import docking.help.GHelpClassLoader;
import docking.help.HelpManager;
import generic.jar.ResourceFile;
import ghidra.framework.Application;
import ghidra.util.Msg;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.help.HelpSet;
import javax.help.HelpSetException;
import resources.ResourceManager;

public class GhidraHelpService
extends HelpManager {
    private static final String MASTER_HELP_SET_HS = "Base_HelpSet.hs";

    public static void install() {
        try {
            new GhidraHelpService();
        }
        catch (HelpSetException e) {
            Msg.error(GhidraHelpService.class, (Object)"Unable to load Ghidra help", (Throwable)e);
        }
    }

    private GhidraHelpService() throws HelpSetException {
        super(GhidraHelpService.findMasterHelpSetUrl());
        this.loadHelpSets();
        this.registerHelp();
    }

    private static URL findMasterHelpSetUrl() {
        GHelpClassLoader helpClassLoader = new GHelpClassLoader(null);
        URL url = HelpSet.findHelpSet((ClassLoader)helpClassLoader, (String)MASTER_HELP_SET_HS);
        if (url != null) {
            return url;
        }
        Msg.error(GhidraHelpService.class, (Object)"Failed to locate the primary Help Set.  Try building help to resolve the issue");
        return ResourceManager.getResource((String)"help/Dummy_HelpSet.hs");
    }

    private void loadHelpSets() {
        Map<ResourceFile, Set<URL>> helpSetsByModule = this.findHelpSetsByModule();
        Set<Map.Entry<ResourceFile, Set<URL>>> entries = helpSetsByModule.entrySet();
        for (Map.Entry<ResourceFile, Set<URL>> entry : entries) {
            ResourceFile module = entry.getKey();
            Set<URL> moduleHelpSets = entry.getValue();
            for (URL url : moduleHelpSets) {
                try {
                    this.addHelpSet(url, new GHelpClassLoader(module));
                }
                catch (HelpSetException e) {
                    Msg.error((Object)((Object)this), (Object)("Unexpected Exception Loading HelpSet: " + e.getMessage()), (Throwable)e);
                }
            }
        }
    }

    private Map<ResourceFile, Set<URL>> findHelpSetsByModule() {
        Set allHelpSets = ResourceManager.getResources((String)"help", (String)"hs");
        Collection moduleRoots = Application.getModuleRootDirectories();
        Map<ResourceFile, Set<URL>> helpSetsByModule = this.mapHelpToModule(moduleRoots, allHelpSets);
        return helpSetsByModule;
    }

    private Map<ResourceFile, Set<URL>> mapHelpToModule(Collection<ResourceFile> moduleRoots, Set<URL> allHelpSets) {
        HashMap<ResourceFile, Set<URL>> results = new HashMap<ResourceFile, Set<URL>>();
        for (ResourceFile module : moduleRoots) {
            String moduleName = module.getName();
            HashSet<URL> help = new HashSet<URL>();
            Iterator<URL> it = allHelpSets.iterator();
            while (it.hasNext()) {
                URL url = it.next();
                String asString = url.toExternalForm();
                if (!asString.contains(moduleName)) continue;
                it.remove();
                help.add(url);
            }
            if (help.isEmpty()) continue;
            results.put(module, help);
        }
        return results;
    }
}

