/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.viewer.field;

import docking.widgets.fieldpanel.field.AbstractTextFieldElement;
import docking.widgets.fieldpanel.field.AttributedString;
import docking.widgets.fieldpanel.field.CompositeFieldElement;
import docking.widgets.fieldpanel.field.FieldElement;
import docking.widgets.fieldpanel.field.TextField;
import docking.widgets.fieldpanel.support.FieldLocation;
import docking.widgets.fieldpanel.support.RowColLocation;
import ghidra.app.util.HighlightProvider;
import ghidra.app.util.viewer.field.FieldFactory;
import ghidra.app.util.viewer.field.ListingField;
import ghidra.app.util.viewer.field.ListingTextField;
import ghidra.app.util.viewer.format.FieldFormatModel;
import ghidra.app.util.viewer.options.OptionsGui;
import ghidra.app.util.viewer.proxy.FunctionProxy;
import ghidra.app.util.viewer.proxy.ProxyObj;
import ghidra.framework.options.Options;
import ghidra.framework.options.ToolOptions;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Parameter;
import ghidra.program.model.symbol.ExternalLocation;
import ghidra.program.model.symbol.ExternalManager;
import ghidra.program.model.symbol.SourceType;
import ghidra.program.util.FunctionCallingConventionFieldLocation;
import ghidra.program.util.FunctionEndParametersFieldLocation;
import ghidra.program.util.FunctionInlineFieldLocation;
import ghidra.program.util.FunctionNameFieldLocation;
import ghidra.program.util.FunctionNoReturnFieldLocation;
import ghidra.program.util.FunctionParameterFieldLocation;
import ghidra.program.util.FunctionParameterNameFieldLocation;
import ghidra.program.util.FunctionReturnTypeFieldLocation;
import ghidra.program.util.FunctionSignatureFieldLocation;
import ghidra.program.util.FunctionStartParametersFieldLocation;
import ghidra.program.util.FunctionThunkFieldLocation;
import ghidra.program.util.ProgramLocation;
import java.awt.Color;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;

public class FunctionSignatureFieldFactory
extends FieldFactory {
    public static final String FIELD_NAME = "Function Signature";
    public static final String GROUP_TITLE = "Function Signature Field";
    public static final String DISPLAY_NAMESPACE = "Function Signature Field.Display Namespace";
    private boolean displayFunctionScope;
    private Color funNameColor;
    private Color unresolvedThunkRefColor;
    private Color resolvedThunkRefColor;
    private Color funRetColor;
    private Color literalColor;
    private Color funParamsColor;
    private Color autoParamColor;

    public FunctionSignatureFieldFactory() {
        super(FIELD_NAME);
    }

    public FunctionSignatureFieldFactory(FieldFormatModel model, HighlightProvider hlProvider, Options displayOptions, Options fieldOptions) {
        super(FIELD_NAME, model, hlProvider, displayOptions, fieldOptions);
        fieldOptions.registerOption(DISPLAY_NAMESPACE, (Object)false, null, "Prepends namespaces to labels that are not in the global namespace.");
        this.displayFunctionScope = fieldOptions.getBoolean(DISPLAY_NAMESPACE, false);
        this.funRetColor = displayOptions.getColor(OptionsGui.FUN_RET_TYPE.getColorOptionName(), OptionsGui.FUN_RET_TYPE.getDefaultColor());
        this.funNameColor = displayOptions.getColor(OptionsGui.FUN_NAME.getColorOptionName(), OptionsGui.FUN_NAME.getDefaultColor());
        this.unresolvedThunkRefColor = displayOptions.getColor(OptionsGui.BAD_REF_ADDR.getColorOptionName(), OptionsGui.BAD_REF_ADDR.getDefaultColor());
        this.resolvedThunkRefColor = displayOptions.getColor(OptionsGui.EXT_REF_RESOLVED.getColorOptionName(), OptionsGui.EXT_REF_RESOLVED.getDefaultColor());
        this.funParamsColor = displayOptions.getColor(OptionsGui.FUN_PARAMS.getColorOptionName(), OptionsGui.FUN_PARAMS.getDefaultColor());
        this.autoParamColor = displayOptions.getColor(OptionsGui.FUN_AUTO_PARAMS.getColorOptionName(), OptionsGui.FUN_PARAMS.getDefaultColor());
        this.literalColor = displayOptions.getColor(OptionsGui.SEPARATOR.getColorOptionName(), OptionsGui.SEPARATOR.getDefaultColor());
    }

    @Override
    public void displayOptionsChanged(Options options, String optionName, Object oldValue, Object newValue) {
        super.displayOptionsChanged(options, optionName, oldValue, newValue);
        this.funRetColor = options.getColor(OptionsGui.FUN_RET_TYPE.getColorOptionName(), Color.BLACK);
        this.funNameColor = options.getColor(OptionsGui.FUN_NAME.getColorOptionName(), Color.BLACK);
        this.unresolvedThunkRefColor = this.displayOptions.getColor(OptionsGui.BAD_REF_ADDR.getColorOptionName(), OptionsGui.BAD_REF_ADDR.getDefaultColor());
        this.resolvedThunkRefColor = this.displayOptions.getColor(OptionsGui.EXT_REF_RESOLVED.getColorOptionName(), OptionsGui.EXT_REF_RESOLVED.getDefaultColor());
        this.funParamsColor = options.getColor(OptionsGui.FUN_PARAMS.getColorOptionName(), Color.BLACK);
        this.autoParamColor = options.getColor(OptionsGui.FUN_AUTO_PARAMS.getColorOptionName(), Color.GRAY);
        this.literalColor = options.getColor(OptionsGui.SEPARATOR.getColorOptionName(), Color.BLACK);
    }

    @Override
    public ListingField getField(ProxyObj<?> proxy, int varWidth) {
        AttributedString as;
        Object obj = proxy.getObject();
        if (!this.enabled || !(obj instanceof Function)) {
            return null;
        }
        Function function = (Function)obj;
        Parameter[] params = function.getParameters();
        ArrayList<FunctionSignatureFieldElement> textElements = new ArrayList<FunctionSignatureFieldElement>();
        int elementIndex = 0;
        int startCol = 0;
        if (function.isInline()) {
            as = new AttributedString("inline ", this.funRetColor, this.getMetrics());
            textElements.add(new FunctionInlineFieldElement(as, elementIndex, 0, startCol));
            startCol += as.length();
            ++elementIndex;
        }
        if (function.isThunk()) {
            as = new AttributedString("thunk ", this.funRetColor, this.getMetrics());
            textElements.add(new FunctionThunkFieldElement(as, elementIndex, 0, startCol));
            startCol += as.length();
            ++elementIndex;
        }
        if (function.hasNoReturn()) {
            as = new AttributedString("noreturn ", this.funRetColor, this.getMetrics());
            textElements.add(new FunctionNoReturnFieldElement(as, elementIndex, 0, startCol));
            startCol += as.length();
            ++elementIndex;
        }
        as = new AttributedString(function.getReturn().getFormalDataType().getDisplayName() + " ", this.funRetColor, this.getMetrics());
        textElements.add(new FunctionReturnTypeFieldElement(as, elementIndex, 0, startCol));
        startCol += as.length();
        ++elementIndex;
        String callingConvention = function.getCallingConventionName();
        if (callingConvention.equals("default")) {
            callingConvention = function.getCallingConvention().getName();
        }
        if (callingConvention != null && !callingConvention.equals("unknown")) {
            as = new AttributedString(callingConvention + " ", this.funRetColor, this.getMetrics());
            textElements.add(new FunctionCallingConventionFieldElement(as, elementIndex, 0, startCol));
            startCol += as.length();
            ++elementIndex;
        }
        as = new AttributedString(function.getName(this.displayFunctionScope), this.getFunctionNameColor(function), this.getMetrics());
        textElements.add(new FunctionNameFieldElement(as, elementIndex, 0, startCol));
        startCol += as.length();
        as = new AttributedString("(", this.literalColor, this.getMetrics());
        textElements.add(new FunctionStartParametersFieldElement(as, ++elementIndex, 0, startCol));
        startCol += as.length();
        ++elementIndex;
        int paramOffset = 0;
        AttributedString commaSeparator = new AttributedString(", ", this.literalColor, this.getMetrics());
        int lastParam = params.length - 1;
        for (int i = 0; i < params.length; ++i) {
            Color pcolor = params[i].isAutoParameter() ? this.autoParamColor : this.funParamsColor;
            Object text = params[i].getFormalDataType().getDisplayName() + " ";
            as = new AttributedString((String)text, pcolor, this.getMetrics());
            textElements.add(new FunctionParameterFieldElement(as, elementIndex, paramOffset, startCol, i));
            startCol += as.length();
            paramOffset += as.length();
            text = params[i].getName();
            as = new AttributedString((String)text, pcolor, this.getMetrics());
            textElements.add(new FunctionParameterNameFieldElement(as, ++elementIndex, paramOffset, startCol, i));
            startCol += as.length();
            paramOffset += as.length();
            ++elementIndex;
            if (i == lastParam) continue;
            textElements.add(new FunctionSignatureFieldElement(commaSeparator, elementIndex, 0, startCol));
            startCol += commaSeparator.length();
            paramOffset += commaSeparator.length();
            ++elementIndex;
        }
        if (function.hasVarArgs()) {
            if (params.length > 0) {
                textElements.add(new FunctionSignatureFieldElement(commaSeparator, elementIndex, 0, startCol));
                startCol += commaSeparator.length();
                paramOffset += commaSeparator.length();
                ++elementIndex;
            }
            as = new AttributedString("...", this.funParamsColor, this.getMetrics());
            textElements.add(new FunctionSignatureFieldElement(as, elementIndex, 0, startCol));
            startCol += as.length();
            ++elementIndex;
        } else if (lastParam < 0 && function.getSignatureSource() != SourceType.DEFAULT) {
            as = new AttributedString("void", this.funParamsColor, this.getMetrics());
            textElements.add(new FunctionSignatureFieldElement(as, elementIndex, 0, startCol));
            startCol += as.length();
            ++elementIndex;
        }
        as = new AttributedString(")", this.literalColor, this.getMetrics());
        textElements.add(new FunctionEndParametersFieldElement(as, elementIndex, 0, startCol));
        return ListingTextField.createSingleLineTextField(this, proxy, (FieldElement)new CompositeFieldElement(textElements), this.startX + varWidth, this.width, this.hlProvider);
    }

    private Color getFunctionNameColor(Function function) {
        if (function.isThunk()) {
            Function thunkedFunction = function.getThunkedFunction(true);
            if (thunkedFunction == null) {
                return this.unresolvedThunkRefColor;
            }
            if (thunkedFunction.isExternal()) {
                ExternalLocation externalLocation = thunkedFunction.getExternalLocation();
                String libName = externalLocation.getLibraryName();
                if ("<EXTERNAL>".equals(libName)) {
                    return this.unresolvedThunkRefColor;
                }
                ExternalManager externalManager = function.getProgram().getExternalManager();
                String path = externalManager.getExternalLibraryPath(libName);
                if (path == null || path.length() == 0) {
                    return this.unresolvedThunkRefColor;
                }
                return this.resolvedThunkRefColor;
            }
        }
        return this.funNameColor;
    }

    @Override
    public ProgramLocation getProgramLocation(int fieldRow, int fieldColumn, ListingField listingField) {
        ProxyObj<?> proxy = listingField.getProxy();
        if (proxy instanceof FunctionProxy) {
            FunctionProxy functionProxy = (FunctionProxy)proxy;
            if (!(listingField instanceof ListingTextField)) {
                return null;
            }
            ListingTextField btf = (ListingTextField)listingField;
            FieldElement fe = btf.getFieldElement(fieldRow, fieldColumn);
            if (!(fe instanceof FunctionSignatureFieldElement)) {
                return null;
            }
            FunctionSignatureFieldElement fieldElement = (FunctionSignatureFieldElement)fe;
            int offset = fieldElement.getOffsetInFieldElement(fieldColumn);
            if (offset == -1) {
                return null;
            }
            RowColLocation rowCol = fieldElement.getDataLocationForCharacterIndex(offset);
            return fieldElement.getProgramLocation(functionProxy, listingField.getText(), rowCol.row(), rowCol.col());
        }
        return null;
    }

    @Override
    public FieldLocation getFieldLocation(ListingField bf, BigInteger index, int fieldNum, ProgramLocation loc) {
        if (loc instanceof FunctionSignatureFieldLocation) {
            FunctionSignatureFieldLocation signatureLocation = (FunctionSignatureFieldLocation)loc;
            if (signatureLocation.isFieldBasedPositioning()) {
                return this.getFieldBasedFunctionSignatureFieldLocation(signatureLocation, bf, index, fieldNum);
            }
            return new FieldLocation(index, fieldNum, 0, signatureLocation.getCharOffset());
        }
        return null;
    }

    private FieldLocation getFieldBasedFunctionSignatureFieldLocation(FunctionSignatureFieldLocation signatureLocation, ListingField bf, BigInteger index, int fieldNum) {
        int characterIndex = 0;
        List<FieldElement> elements = this.getFieldElements(bf);
        if (signatureLocation instanceof FunctionNameFieldLocation) {
            characterIndex = this.getFunctionSignatureElement(elements, FunctionNameFieldElement.class, 0);
        } else if (signatureLocation instanceof FunctionReturnTypeFieldLocation) {
            characterIndex = this.getFunctionSignatureElement(elements, FunctionReturnTypeFieldElement.class, 0);
        } else if (signatureLocation instanceof FunctionInlineFieldLocation) {
            characterIndex = this.getFunctionSignatureElement(elements, FunctionInlineFieldElement.class, 0);
        } else if (signatureLocation instanceof FunctionNoReturnFieldLocation) {
            characterIndex = this.getFunctionSignatureElement(elements, FunctionNoReturnFieldElement.class, 0);
        } else if (signatureLocation instanceof FunctionParameterNameFieldLocation) {
            FunctionParameterNameFieldLocation parameterNameLocation = (FunctionParameterNameFieldLocation)signatureLocation;
            int ordinal = parameterNameLocation.getOrdinal();
            characterIndex = this.getFunctionSignatureElement(elements, FunctionParameterNameFieldElement.class, ordinal);
        } else if (signatureLocation instanceof FunctionStartParametersFieldLocation) {
            characterIndex = this.getFunctionSignatureElement(elements, FunctionStartParametersFieldElement.class, 0);
        } else if (signatureLocation instanceof FunctionEndParametersFieldLocation) {
            characterIndex = this.getFunctionSignatureElement(elements, FunctionEndParametersFieldElement.class, 0);
        }
        return new FieldLocation(index, fieldNum, 0, characterIndex);
    }

    private int getFunctionSignatureElement(List<FieldElement> elements, Class<?> elementClass, int classIndex) {
        int characterCount = 0;
        int classCount = 0;
        for (FieldElement fieldElement : elements) {
            if (fieldElement.getClass() == elementClass) {
                if (classCount == classIndex) {
                    return characterCount;
                }
                ++classCount;
            }
            characterCount += fieldElement.getText().length();
        }
        return 0;
    }

    private List<FieldElement> getFieldElements(ListingField listingField) {
        TextField textField = (TextField)listingField;
        ArrayList<FieldElement> elements = new ArrayList<FieldElement>();
        int numRows = textField.getNumRows();
        for (int row = 0; row < numRows; ++row) {
            FieldElement fieldElement;
            FieldElement previousFieldElement = null;
            int numColumns = textField.getNumCols(row);
            for (int col = 0; col < numColumns && (fieldElement = textField.getFieldElement(row, col)) != null; ++col) {
                if (fieldElement == previousFieldElement) continue;
                elements.add(fieldElement);
                previousFieldElement = fieldElement;
            }
        }
        return elements;
    }

    @Override
    public boolean acceptsType(int category, Class<?> proxyObjectClass) {
        if (!Function.class.isAssignableFrom(proxyObjectClass)) {
            return false;
        }
        return category == 2;
    }

    @Override
    public FieldFactory newInstance(FieldFormatModel formatModel, HighlightProvider provider, ToolOptions displayOptions, ToolOptions fieldOptions) {
        return new FunctionSignatureFieldFactory(formatModel, provider, (Options)displayOptions, (Options)fieldOptions);
    }

    @Override
    public Color getDefaultColor() {
        return OptionsGui.FUN_NAME.getDefaultColor();
    }

    @Override
    public void fieldOptionsChanged(Options options, String optionName, Object oldValue, Object newValue) {
        if (optionName.equals(DISPLAY_NAMESPACE)) {
            this.displayFunctionScope = (Boolean)newValue;
            this.model.update();
        }
    }

    class FunctionInlineFieldElement
    extends FunctionSignatureFieldElement {
        FunctionInlineFieldElement(AttributedString as, int elementRow, int elementColumn, int functionSigIndex) {
            super(as, elementRow, elementColumn, functionSigIndex);
        }

        @Override
        ProgramLocation getProgramLocation(FunctionProxy functionProxy, String signature, int rowInField, int columnInRow) {
            Function function = functionProxy.getObject();
            int signatureIndex = this.getCharacterIndexForDataLocation(rowInField, columnInRow) + this.functionSigIndex;
            return new FunctionInlineFieldLocation(function.getProgram(), functionProxy.getLocationAddress(), functionProxy.getFunctionAddress(), signatureIndex, signature);
        }

        @Override
        FieldElement createElement(AttributedString as, int elementRow, int elementColumn, int signatureIndex) {
            return new FunctionInlineFieldElement(as, elementRow, elementColumn, signatureIndex);
        }
    }

    class FunctionThunkFieldElement
    extends FunctionSignatureFieldElement {
        FunctionThunkFieldElement(AttributedString as, int elementRow, int elementColumn, int functionSigIndex) {
            super(as, elementRow, elementColumn, functionSigIndex);
        }

        @Override
        ProgramLocation getProgramLocation(FunctionProxy functionProxy, String signature, int rowInField, int columnInRow) {
            Function function = functionProxy.getObject();
            int signatureIndex = this.getCharacterIndexForDataLocation(rowInField, columnInRow) + this.functionSigIndex;
            return new FunctionThunkFieldLocation(function.getProgram(), functionProxy.getLocationAddress(), functionProxy.getFunctionAddress(), signatureIndex, signature);
        }

        @Override
        FieldElement createElement(AttributedString as, int elementRow, int elementColumn, int signatureIndex) {
            return new FunctionInlineFieldElement(as, elementRow, elementColumn, signatureIndex);
        }
    }

    class FunctionNoReturnFieldElement
    extends FunctionSignatureFieldElement {
        FunctionNoReturnFieldElement(AttributedString as, int elementRow, int elementColumn, int functionSigIndex) {
            super(as, elementRow, elementColumn, functionSigIndex);
        }

        @Override
        ProgramLocation getProgramLocation(FunctionProxy functionProxy, String signature, int rowInField, int columnInRow) {
            Function function = functionProxy.getObject();
            int signatureIndex = this.getCharacterIndexForDataLocation(rowInField, columnInRow) + this.functionSigIndex;
            return new FunctionNoReturnFieldLocation(function.getProgram(), functionProxy.getLocationAddress(), functionProxy.getFunctionAddress(), signatureIndex, signature, function.isInline() ? "noreturn" : "");
        }

        @Override
        FieldElement createElement(AttributedString as, int elementRow, int elementColumn, int signatureIndex) {
            return new FunctionNoReturnFieldElement(as, elementRow, elementColumn, signatureIndex);
        }
    }

    class FunctionReturnTypeFieldElement
    extends FunctionSignatureFieldElement {
        FunctionReturnTypeFieldElement(AttributedString as, int row, int column, int functionSigIndex) {
            super(as, row, column, functionSigIndex);
        }

        @Override
        ProgramLocation getProgramLocation(FunctionProxy functionProxy, String signature, int rowInField, int columnInRow) {
            Function function = functionProxy.getObject();
            int signatureIndex = this.getCharacterIndexForDataLocation(rowInField, columnInRow) + this.functionSigIndex;
            return new FunctionReturnTypeFieldLocation(function.getProgram(), functionProxy.getLocationAddress(), functionProxy.getFunctionAddress(), signatureIndex, signature, function.getReturnType().getName());
        }

        @Override
        FieldElement createElement(AttributedString as, int elementRow, int elementColumn, int signatureIndex) {
            return new FunctionReturnTypeFieldElement(as, elementRow, elementColumn, signatureIndex);
        }
    }

    class FunctionCallingConventionFieldElement
    extends FunctionSignatureFieldElement {
        FunctionCallingConventionFieldElement(AttributedString as, int elementRow, int elementColumn, int functionSigIndex) {
            super(as, elementRow, elementColumn, functionSigIndex);
        }

        @Override
        ProgramLocation getProgramLocation(FunctionProxy functionProxy, String signature, int rowInField, int columnInRow) {
            Function function = functionProxy.getObject();
            int signatureIndex = this.getCharacterIndexForDataLocation(rowInField, columnInRow) + this.functionSigIndex;
            return new FunctionCallingConventionFieldLocation(function.getProgram(), functionProxy.getLocationAddress(), functionProxy.getFunctionAddress(), signatureIndex, signature);
        }

        @Override
        FieldElement createElement(AttributedString as, int elementRow, int elementColumn, int signatureIndex) {
            return new FunctionCallingConventionFieldElement(as, elementRow, elementColumn, signatureIndex);
        }
    }

    class FunctionNameFieldElement
    extends FunctionSignatureFieldElement {
        FunctionNameFieldElement(AttributedString as, int row, int column, int functionSigIndex) {
            super(as, row, column, functionSigIndex);
        }

        @Override
        ProgramLocation getProgramLocation(FunctionProxy functionProxy, String signature, int rowInField, int columnInRow) {
            Function function = functionProxy.getObject();
            int signatureIndex = this.getCharacterIndexForDataLocation(rowInField, columnInRow) + this.functionSigIndex;
            return new FunctionNameFieldLocation(function.getProgram(), functionProxy.getLocationAddress(), functionProxy.getFunctionAddress(), signatureIndex, signature, function.getName(FunctionSignatureFieldFactory.this.displayFunctionScope));
        }

        @Override
        FieldElement createElement(AttributedString as, int elementRow, int columnInRow, int signatureIndex) {
            return new FunctionNameFieldElement(as, elementRow, columnInRow, signatureIndex);
        }
    }

    class FunctionStartParametersFieldElement
    extends FunctionSignatureFieldElement {
        FunctionStartParametersFieldElement(AttributedString as, int elementRow, int columnInRow, int functionSigIndex) {
            super(as, elementRow, columnInRow, functionSigIndex);
        }

        @Override
        ProgramLocation getProgramLocation(FunctionProxy functionProxy, String signature, int rowInField, int columnInRow) {
            Function function = functionProxy.getObject();
            int signatureIndex = this.getCharacterIndexForDataLocation(rowInField, columnInRow) + this.functionSigIndex;
            return new FunctionStartParametersFieldLocation(function.getProgram(), functionProxy.getLocationAddress(), functionProxy.getFunctionAddress(), signatureIndex, signature);
        }

        @Override
        FieldElement createElement(AttributedString as, int elementRow, int columnInRow, int signatureIndex) {
            return new FunctionNameFieldElement(as, elementRow, columnInRow, signatureIndex);
        }
    }

    class FunctionParameterFieldElement
    extends FunctionSignatureFieldElement {
        protected final int parameterOrdinal;

        FunctionParameterFieldElement(AttributedString as, int row, int column, int functionSigIndex, int parameterOrdinal) {
            super(as, row, column, functionSigIndex);
            this.parameterOrdinal = parameterOrdinal;
        }

        @Override
        ProgramLocation getProgramLocation(FunctionProxy functionProxy, String signature, int rowInField, int columnInRow) {
            Function function = functionProxy.getObject();
            int signatureIndex = this.getCharacterIndexForDataLocation(rowInField, columnInRow) + this.functionSigIndex;
            return new FunctionParameterFieldLocation(function.getProgram(), functionProxy.getLocationAddress(), functionProxy.getFunctionAddress(), signatureIndex, signature, function.getParameter(this.parameterOrdinal));
        }

        @Override
        FieldElement createElement(AttributedString as, int elementRow, int columnInRow, int signatureIndex) {
            return new FunctionParameterFieldElement(as, elementRow, columnInRow, signatureIndex, this.parameterOrdinal);
        }
    }

    class FunctionParameterNameFieldElement
    extends FunctionParameterFieldElement {
        FunctionParameterNameFieldElement(AttributedString as, int row, int column, int functionSigIndex, int parameterOrdinal) {
            super(as, row, column, functionSigIndex, parameterOrdinal);
        }

        @Override
        ProgramLocation getProgramLocation(FunctionProxy functionProxy, String signature, int rowInField, int columnInRow) {
            Function function = functionProxy.getObject();
            int signatureIndex = this.getCharacterIndexForDataLocation(rowInField, columnInRow) + this.functionSigIndex;
            return new FunctionParameterNameFieldLocation(function.getProgram(), functionProxy.getLocationAddress(), functionProxy.getFunctionAddress(), signatureIndex, signature, function.getParameter(this.parameterOrdinal));
        }

        @Override
        FieldElement createElement(AttributedString as, int elementRow, int columnInRow, int signatureIndex) {
            return new FunctionParameterNameFieldElement(as, elementRow, columnInRow, signatureIndex, this.parameterOrdinal);
        }
    }

    class FunctionSignatureFieldElement
    extends AbstractTextFieldElement {
        int functionSigIndex;

        FunctionSignatureFieldElement(AttributedString as, int row, int column, int functionSigIndex) {
            super(as, row, column);
            this.functionSigIndex = functionSigIndex;
        }

        ProgramLocation getProgramLocation(FunctionProxy functionProxy, String signature, int fieldRow, int fieldColumn) {
            int offsetIndex = this.getCharacterIndexForDataLocation(fieldRow, fieldColumn);
            if (offsetIndex < 0) {
                return null;
            }
            int signatureIndex = offsetIndex + this.functionSigIndex;
            Function function = functionProxy.getObject();
            return new FunctionSignatureFieldLocation(function.getProgram(), functionProxy.getLocationAddress(), functionProxy.getFunctionAddress(), signatureIndex, signature);
        }

        FieldElement createElement(AttributedString as, int elementRow, int elementColumn, int signatureIndex) {
            return new FunctionSignatureFieldElement(as, elementRow, elementColumn, signatureIndex);
        }

        int getOffsetInFieldElement(int signatureIndex) {
            int offset = signatureIndex - this.functionSigIndex;
            if (offset >= 0 && offset <= this.length()) {
                return offset;
            }
            return -1;
        }

        public FieldElement substring(int start, int end) {
            AttributedString as = this.attributedString.substring(start, end);
            if (as == this.attributedString) {
                return this;
            }
            return this.createElement(as, this.row, this.column, this.functionSigIndex + start);
        }

        public FieldElement replaceAll(char[] targets, char replacement) {
            return this.createElement(this.attributedString.replaceAll(targets, replacement), this.row, this.column, this.functionSigIndex);
        }
    }

    class FunctionEndParametersFieldElement
    extends FunctionSignatureFieldElement {
        FunctionEndParametersFieldElement(AttributedString as, int row, int column, int functionSigIndex) {
            super(as, row, column, functionSigIndex);
        }

        @Override
        ProgramLocation getProgramLocation(FunctionProxy functionProxy, String signature, int rowInField, int columnInRow) {
            Function function = functionProxy.getObject();
            int signatureIndex = this.getCharacterIndexForDataLocation(rowInField, columnInRow) + this.functionSigIndex;
            return new FunctionEndParametersFieldLocation(function.getProgram(), functionProxy.getLocationAddress(), functionProxy.getFunctionAddress(), signatureIndex, signature);
        }

        @Override
        FieldElement createElement(AttributedString as, int elementRow, int columnInRow, int signatureIndex) {
            return new FunctionNameFieldElement(as, elementRow, columnInRow, signatureIndex);
        }
    }
}

