/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.pcode;

import ghidra.app.plugin.processors.sleigh.SleighLanguage;
import ghidra.app.util.pcode.Appender;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.lang.Language;
import ghidra.program.model.lang.Register;
import ghidra.program.model.pcode.PcodeOp;
import ghidra.util.Msg;

public abstract class AbstractAppender<T>
implements Appender<T> {
    protected final Language language;
    protected final boolean indent;

    public AbstractAppender(Language language, boolean indent) {
        this.language = language;
        this.indent = indent;
    }

    @Override
    public Language getLanguage() {
        return this.language;
    }

    @Override
    public void appendAddressWordOffcut(long wordOffset, long offcut) {
        this.appendString(this.stringifyWordOffcut(wordOffset, offcut));
    }

    @Override
    public void appendCharacter(char c) {
        if (c == '=') {
            this.appendString(" = ");
        } else {
            this.appendString(Character.toString(c));
        }
    }

    @Override
    public void appendIndent() {
        if (this.indent) {
            this.appendCharacter(' ');
            this.appendCharacter(' ');
        }
    }

    @Override
    public void appendLabel(String label) {
        this.appendString(label);
    }

    @Override
    public void appendLineLabelRef(long label) {
        this.appendString(this.stringifyLineLabel(label));
    }

    @Override
    public void appendMnemonic(int opcode) {
        this.appendString(this.stringifyOpMnemonic(opcode));
    }

    @Override
    public void appendRawVarnode(AddressSpace space, long offset, long size) {
        this.appendString(this.stringifyRawVarnode(space, offset, size));
    }

    @Override
    public void appendRegister(Register register) {
        this.appendString(this.stringifyRegister(register));
    }

    @Override
    public void appendScalar(long value) {
        this.appendString(this.stringifyScalarValue(value));
    }

    @Override
    public void appendSpace(AddressSpace space) {
        this.appendString(this.stringifySpace(space));
    }

    protected void appendString(String string) {
        throw new AssertionError((Object)"Either this shouldn't happen, or you should accept the string");
    }

    @Override
    public void appendUnique(long offset) {
        this.appendString(this.stringifyUnique(offset));
    }

    @Override
    public void appendUserop(int id) {
        this.appendString(this.stringifyUserop(this.language, id));
    }

    protected String stringifyLineLabel(long label) {
        return "<" + label + ">";
    }

    protected String stringifyOpMnemonic(int opcode) {
        return PcodeOp.getMnemonic((int)opcode);
    }

    protected String stringifyRawVarnode(AddressSpace space, long offset, long size) {
        return "(" + space.getName() + ", 0x" + Long.toHexString(offset) + ", " + size + ")";
    }

    protected String stringifyRegister(Register register) {
        return register.getName();
    }

    protected String stringifyScalarValue(long value) {
        if (value >= -64L && value <= 64L) {
            return Long.toString(value);
        }
        return "0x" + Long.toHexString(value);
    }

    protected String stringifySpace(AddressSpace space) {
        if (space == null) {
            return "unknown";
        }
        return space.getName();
    }

    protected String stringifyUnique(long offset) {
        return "$U" + Long.toHexString(offset);
    }

    protected String stringifyUseropUnchecked(Language language, int id) {
        if (!(language instanceof SleighLanguage)) {
            throw new RuntimeException("Expected Sleigh language for CALLOTHER op");
        }
        return ((SleighLanguage)language).getUserDefinedOpName(id);
    }

    protected String stringifyUserop(Language language, int id) {
        String pseudoOp = this.stringifyUseropUnchecked(language, id);
        if (pseudoOp == null) {
            Msg.error((Object)this, (Object)("Pseudo-op index not found: " + id));
            pseudoOp = "unknown";
        }
        return pseudoOp;
    }

    protected String stringifyWordOffcut(long wordOffset, long offcut) {
        String str = "0x" + Long.toHexString(wordOffset);
        if (offcut != 0L) {
            str = str + "." + offcut;
        }
        return str;
    }
}

