/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.opinion;

import generic.jar.ResourceFile;
import ghidra.app.util.PseudoDisassembler;
import ghidra.app.util.PseudoFlowProcessor;
import ghidra.app.util.PseudoInstruction;
import ghidra.app.util.opinion.LibraryExportedSymbol;
import ghidra.app.util.opinion.LibraryHints;
import ghidra.app.util.opinion.LibraryLookupTable;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.MemoryBlock;
import ghidra.program.model.scalar.Scalar;
import ghidra.program.model.symbol.ExternalReference;
import ghidra.program.model.symbol.FlowType;
import ghidra.program.model.symbol.Reference;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.model.symbol.SymbolIterator;
import ghidra.program.model.symbol.SymbolTable;
import ghidra.program.model.symbol.SymbolUtilities;
import ghidra.util.Msg;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import ghidra.util.xml.GenericXMLOutputter;
import ghidra.util.xml.XmlUtilities;
import ghidra.xml.XmlElement;
import ghidra.xml.XmlPullParser;
import ghidra.xml.XmlPullParserFactory;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jdom.Attribute;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import util.CollectionUtils;

class LibrarySymbolTable {
    private static final SimpleDateFormat TIMESTAMP_FORMAT = new SimpleDateFormat("EEE MMM dd hh:mm:ss zzz yyyy");
    private static final int NONE = 0;
    private static final int LIBRARY = 1;
    private static final int EXPORTS = 2;
    private static final int ORDINAL = 3;
    private String tableName;
    private int size;
    private String path;
    private String date;
    private String version;
    private int tempPurge;
    private String fowardLibrary = null;
    private String fowardSymbol = null;
    private HashMap<String, LibraryExportedSymbol> symMap = new HashMap();
    private ArrayList<LibraryExportedSymbol> exportList = new ArrayList();
    private HashMap<Integer, LibraryExportedSymbol> ordMap = new HashMap();
    private Set<String> forwards = new HashSet<String>();
    private static final ErrorHandler ERROR_HANDLER = new ErrorHandler(){

        @Override
        public void error(SAXParseException exception) throws SAXException {
            Msg.warn(LibraryLookupTable.class, (Object)"error", (Throwable)exception);
        }

        @Override
        public void fatalError(SAXParseException exception) throws SAXException {
            Msg.warn(LibraryLookupTable.class, (Object)"fatal error", (Throwable)exception);
        }

        @Override
        public void warning(SAXParseException exception) throws SAXException {
            Msg.warn(LibraryLookupTable.class, (Object)"warning", (Throwable)exception);
        }
    };

    LibrarySymbolTable(String tableName, int size) {
        this.tableName = tableName.toLowerCase();
        this.size = size;
        this.version = "unknown";
        this.tempPurge = size <= 32 ? -1 : 0;
    }

    LibrarySymbolTable(ResourceFile libraryFile, int size) throws IOException {
        this.read(libraryFile, size);
    }

    LibrarySymbolTable(Program library, TaskMonitor monitor) throws CancelledException {
        this.tableName = new File(library.getExecutablePath()).getName().toLowerCase();
        this.size = library.getLanguage().getLanguageDescription().getSize();
        LibraryHints hints = LibraryHints.getLibraryHints(this.tableName, this.size);
        SymbolTable symTab = library.getSymbolTable();
        SymbolIterator iter = symTab.getSymbolIterator("Ordinal_*", true);
        while (iter.hasNext()) {
            Function func;
            String ordinalName;
            int ordinal;
            monitor.checkCanceled();
            Symbol sym = iter.next();
            if (!sym.isGlobal() || !sym.isExternalEntryPoint() || (ordinal = SymbolUtilities.getOrdinalValue((String)sym.getName())) == -1) continue;
            String realName = ordinalName = sym.getName();
            Address symAddr = sym.getAddress();
            Symbol[] symbolsAt = symTab.getSymbols(symAddr);
            for (int i = 0; i < symbolsAt.length; ++i) {
                if (!symbolsAt[i].getName().equals(ordinalName)) continue;
                if (i <= 0 || symbolsAt[i - 1].getName().startsWith("Ordinal_")) break;
                realName = symbolsAt[i - 1].getName();
                break;
            }
            this.fowardLibrary = null;
            this.fowardSymbol = null;
            this.tempPurge = -1;
            String comment = "";
            Attribute cmtAttr = hints.getAttributeHint(ordinal, realName, "COMMENT");
            if (cmtAttr != null) {
                comment = cmtAttr.getValue();
            }
            if ((func = library.getFunctionManager().getFunctionAt(symAddr)) != null) {
                this.tempPurge = func.getStackPurgeSize();
            }
            if (this.tempPurge == -1 || this.tempPurge > 128 || this.tempPurge < -128) {
                MemoryBlock block;
                Reference[] refs;
                Data data = library.getListing().getDefinedDataAt(symAddr);
                if (data != null && (refs = library.getReferenceManager().getReferencesFrom(symAddr)) != null && refs.length > 0 && refs[0].isExternalReference()) {
                    ExternalReference exRef = (ExternalReference)refs[0];
                    this.fowardLibrary = exRef.getLibraryName();
                    this.fowardSymbol = exRef.getLabel();
                }
                if ((this.fowardLibrary == null || this.fowardLibrary.length() <= 0) && (block = library.getMemory().getBlock(symAddr)) != null && block.isExecute()) {
                    this.pseudoDisassemble(library, symAddr);
                }
            }
            boolean noReturn = false;
            Attribute noReturnHint = hints.getAttributeHint(ordinal, realName, "NO_RETURN");
            if (noReturnHint != null && "y".equals(noReturnHint.getValue())) {
                noReturn = true;
            }
            if (this.fowardLibrary != null && this.fowardLibrary.length() > 0) {
                this.forwards.add(this.fowardLibrary);
            }
            LibraryExportedSymbol expSym = new LibraryExportedSymbol(this.tableName, this.size, ordinal, realName, this.fowardLibrary, this.fowardSymbol, this.tempPurge, noReturn, comment);
            this.exportList.add(expSym);
            this.ordMap.put(ordinal, expSym);
            this.symMap.put(realName, expSym);
        }
    }

    String getCacheKey() {
        return LibrarySymbolTable.getCacheKey(this.tableName, this.size);
    }

    static String getCacheKey(String dllName, int size) {
        return LibraryLookupTable.stripPossibleExtensionFromFilename(dllName).toLowerCase() + ":" + size;
    }

    private void pseudoDisassemble(Program library, Address addr) {
        PseudoDisassembler pdis = new PseudoDisassembler(library);
        pdis.followSubFlows(addr, 4000, new PseudoFlowProcessor(){

            public boolean followFlows(PseudoInstruction instr) {
                return true;
            }

            public boolean process(PseudoInstruction instr) {
                Data data;
                Reference[] refs;
                String mnemonicStr;
                if (instr == null) {
                    return false;
                }
                FlowType ftype = instr.getFlowType();
                if (ftype.isTerminal() && ("ret".equals(mnemonicStr = instr.getMnemonicString().toLowerCase()) || "retf".equals(mnemonicStr))) {
                    LibrarySymbolTable.this.tempPurge = 0;
                    Scalar scalar = instr.getScalar(0);
                    if (scalar != null) {
                        LibrarySymbolTable.this.tempPurge = (int)scalar.getSignedValue();
                        LibrarySymbolTable.this.fowardLibrary = null;
                        LibrarySymbolTable.this.fowardSymbol = null;
                        return false;
                    }
                }
                if (ftype.isJump() && ftype.isComputed() && (refs = instr.getReferencesFrom()).length > 0 && (data = instr.getProgram().getListing().getDefinedDataAt(refs[0].getToAddress())) != null && (refs = instr.getProgram().getReferenceManager().getReferencesFrom(data.getMinAddress())) != null && refs.length > 0 && refs[0].isExternalReference()) {
                    ExternalReference exRef = (ExternalReference)refs[0];
                    LibrarySymbolTable.this.fowardLibrary = exRef.getLibraryName();
                    LibrarySymbolTable.this.fowardSymbol = exRef.getLabel();
                }
                return true;
            }
        });
    }

    public void applyOrdinalFile(ResourceFile ordinalExportsFile, boolean addMissingOrdinals) {
        try (BufferedReader in = new BufferedReader(new InputStreamReader(ordinalExportsFile.getInputStream()));){
            String inString;
            int ordinalColumnEndIndex = -1;
            int nameColumnStartIndex = -1;
            int mode = 0;
            while ((inString = in.readLine()) != null) {
                int index;
                int ordinal;
                if (mode == 0 && inString.trim().startsWith("ordinal")) {
                    int ordinalColumnStartIndex = inString.indexOf("ordinal");
                    if (ordinalColumnStartIndex < 0) continue;
                    ordinalColumnEndIndex = ordinalColumnStartIndex + 7;
                    nameColumnStartIndex = inString.indexOf("name");
                    if (nameColumnStartIndex < 1) {
                        Msg.error((Object)this, (Object)("Failed to parse ordinal symbol file: " + ordinalExportsFile));
                        break;
                    }
                    mode = 3;
                    continue;
                }
                if (mode != 3 || (inString = this.stripComment(inString)).length() < nameColumnStartIndex) continue;
                String ordinalStr = inString.substring(0, ordinalColumnEndIndex).trim();
                try {
                    ordinal = Integer.parseInt(ordinalStr);
                }
                catch (NumberFormatException exc) {
                    break;
                }
                String nameStr = inString.substring(nameColumnStartIndex).trim();
                if (nameStr.length() == 0) {
                    break;
                }
                if (nameStr.startsWith("[NONAME]")) {
                    nameStr = nameStr.substring(8).trim();
                }
                if ((index = nameStr.indexOf(32)) > 0) {
                    nameStr = nameStr.substring(0, index);
                }
                if (nameStr.length() == 0) continue;
                LibraryExportedSymbol sym = this.ordMap.get(ordinal);
                if (sym != null) {
                    this.symMap.remove(sym.getName());
                    sym.setName(nameStr);
                    continue;
                }
                if (!addMissingOrdinals) continue;
                sym = new LibraryExportedSymbol(this.tableName, this.size, ordinal, nameStr, null, null, this.tempPurge, false, null);
                this.symMap.put(nameStr, sym);
                this.ordMap.put(ordinal, sym);
            }
        }
        catch (FileNotFoundException e) {
            return;
        }
        catch (IOException e) {
            Msg.error((Object)this, (Object)("Unexpected Exception: " + e.getMessage()), (Throwable)e);
        }
    }

    private String stripComment(String str) {
        int index = str.indexOf(59);
        return index < 0 ? str : str.substring(0, index);
    }

    List<String> getForwards() {
        return new ArrayList<String>(this.forwards);
    }

    LibraryExportedSymbol getSymbol(int ordinal) {
        return this.ordMap.get(ordinal);
    }

    LibraryExportedSymbol getSymbol(String symbol) {
        return this.symMap.get(symbol);
    }

    String getVersion() {
        return this.version;
    }

    String getPath() {
        return this.path;
    }

    String getDate() {
        return this.date;
    }

    private void read(ResourceFile file, int size) throws IOException {
        this.size = size;
        this.symMap = new HashMap();
        this.exportList = new ArrayList();
        InputStream is = file.getInputStream();
        SAXBuilder sax = XmlUtilities.createSecureSAXBuilder((boolean)false, (boolean)false);
        try {
            Document doc = sax.build(is);
            Element root = doc.getRootElement();
            this.tableName = root.getAttributeValue("NAME");
            if (this.tableName == null) {
                throw new IOException("Missing NAME attribute: " + file);
            }
            this.tableName = this.tableName.toLowerCase();
            this.path = root.getAttributeValue("PATH");
            this.date = root.getAttributeValue("DATE");
            this.version = root.getAttributeValue("VERSION");
            List children = CollectionUtils.asList((List)root.getChildren(), Element.class);
            for (Element export : children) {
                boolean noReturn;
                int ordinal = Integer.parseInt(export.getAttributeValue("ORDINAL"));
                String name = export.getAttributeValue("NAME");
                int purge = Integer.parseInt(export.getAttributeValue("PURGE"));
                String comment = export.getAttributeValue("COMMENT");
                String fowardLibName = export.getAttributeValue("FOWARDLIBRARY");
                String fowardSymName = export.getAttributeValue("FOWARDSYMBOL");
                String noReturnStr = export.getAttributeValue("NO_RETURN");
                boolean bl = noReturn = noReturnStr != null && "y".equals(noReturnStr);
                if (fowardLibName != null && fowardLibName.length() > 0 && !fowardLibName.equals(this.tableName)) {
                    this.forwards.add(fowardLibName);
                }
                LibraryExportedSymbol sym = new LibraryExportedSymbol(this.tableName, size, ordinal, name, fowardLibName, fowardSymName, purge, noReturn, comment);
                this.exportList.add(sym);
                this.symMap.put(name, sym);
                this.ordMap.put(new Integer(ordinal), sym);
            }
        }
        catch (JDOMException e) {
            throw new IOException(e);
        }
        is.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void write(File output, File input, String lversion) throws IOException {
        Element root = new Element("LIBRARY");
        root.setAttribute("NAME", this.tableName);
        root.setAttribute("PATH", input.getAbsolutePath());
        long lastModifiedSeconds = input.lastModified() / 1000L * 1000L;
        root.setAttribute("DATE", TIMESTAMP_FORMAT.format(new Date(lastModifiedSeconds)));
        root.setAttribute("VERSION", lversion);
        for (LibraryExportedSymbol sym : this.exportList) {
            Element export = new Element("EXPORT");
            export.setAttribute("ORDINAL", "" + sym.getOrdinal());
            export.setAttribute("NAME", sym.getName() == null ? "" : sym.getName());
            export.setAttribute("PURGE", "" + sym.getPurge());
            export.setAttribute("COMMENT", sym.getComment() == null ? "" : sym.getComment());
            if (sym.hasNoReturn()) {
                export.setAttribute("NO_RETURN", "y");
            }
            if (sym.isFowardEntry()) {
                export.setAttribute("FOWARDLIBRARY", sym.getFowardLibraryName() == null ? "" : sym.getFowardLibraryName());
                export.setAttribute("FOWARDSYMBOL", sym.getFowardSymbolName() == null ? "" : sym.getFowardSymbolName());
            }
            root.addContent((Content)export);
        }
        try (FileOutputStream fos = new FileOutputStream(output);){
            Document doc = new Document(root);
            GenericXMLOutputter xmlout = new GenericXMLOutputter();
            xmlout.output(doc, (OutputStream)fos);
        }
    }

    void setVersion(String version) {
        this.version = version;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean hasFileAndPathAndTimeStampMatch(ResourceFile exportsFile, File libraryFile) throws ParseException, SAXException, IOException {
        if (exportsFile == null || !exportsFile.exists()) {
            return false;
        }
        XmlPullParser parser = XmlPullParserFactory.create((ResourceFile)exportsFile, (ErrorHandler)ERROR_HANDLER, (boolean)false);
        try {
            XmlElement start = parser.start(new String[]{"LIBRARY"});
            String path = start.getAttribute("PATH");
            String dateString = start.getAttribute("DATE");
            Date date = TIMESTAMP_FORMAT.parse(dateString);
            long lastModifiedSeconds = libraryFile.lastModified() / 1000L * 1000L;
            boolean bl = date.equals(new Date(lastModifiedSeconds)) && path.equalsIgnoreCase(libraryFile.getAbsolutePath());
            return bl;
        }
        finally {
            parser.dispose();
        }
    }
}

