/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pe.debug;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.format.pe.debug.OMFSrcModuleFile;
import ghidra.util.Conv;
import java.io.IOException;
import java.util.ArrayList;

public class OMFSrcModule {
    private short cFile;
    private short cSeg;
    private int[] baseSrcFile;
    private int[] starts;
    private int[] ends;
    private short[] segs;
    private ArrayList<OMFSrcModuleFile> moduleFileList = new ArrayList();

    OMFSrcModule(BinaryReader reader, int ptr) throws IOException {
        int i;
        int index = ptr;
        this.cFile = reader.readShort(index);
        this.cSeg = reader.readShort(index += 2);
        index += 2;
        this.baseSrcFile = new int[Conv.shortToInt((short)this.cFile)];
        for (i = 0; i < Conv.shortToInt((short)this.cFile); ++i) {
            this.baseSrcFile[i] = reader.readInt(index);
            index += 4;
        }
        this.starts = new int[Conv.shortToInt((short)this.cSeg)];
        this.ends = new int[Conv.shortToInt((short)this.cSeg)];
        for (i = 0; i < Conv.shortToInt((short)this.cSeg); ++i) {
            this.starts[i] = reader.readInt(index);
            this.ends[i] = reader.readInt(index += 4);
            index += 4;
        }
        this.segs = new short[Conv.shortToInt((short)this.cSeg)];
        for (i = 0; i < Conv.shortToInt((short)this.cSeg); ++i) {
            this.segs[i] = reader.readShort(index);
            index += 2;
        }
        for (i = 0; i < Conv.shortToInt((short)this.cFile); ++i) {
            this.moduleFileList.add(new OMFSrcModuleFile(reader, ptr + this.baseSrcFile[i]));
        }
    }

    public OMFSrcModuleFile[] getOMFSrcModuleFiles() {
        OMFSrcModuleFile[] arr = new OMFSrcModuleFile[this.moduleFileList.size()];
        this.moduleFileList.toArray(arr);
        return arr;
    }

    public int[] getBaseSrcFile() {
        return this.baseSrcFile;
    }

    public short getFileCount() {
        return this.cFile;
    }

    public short getSegmentCount() {
        return this.cSeg;
    }

    public int[] getEnds() {
        return this.ends;
    }

    public short[] getSegments() {
        return this.segs;
    }

    public int[] getStarts() {
        return this.starts;
    }
}

