/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pe;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.format.pe.BoundImportDescriptor;
import ghidra.app.util.bin.format.pe.BoundImportForwarderRef;
import ghidra.app.util.bin.format.pe.DataDirectory;
import ghidra.app.util.bin.format.pe.NTHeader;
import ghidra.app.util.bin.format.pe.PeUtils;
import ghidra.app.util.bin.format.pe.PortableExecutable;
import ghidra.app.util.importer.MessageLog;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.program.model.listing.Program;
import ghidra.program.model.util.CodeUnitInsertionException;
import ghidra.util.DataConverter;
import ghidra.util.Msg;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;

public class BoundImportDataDirectory
extends DataDirectory {
    private static final String NAME = "IMAGE_DIRECTORY_ENTRY_BOUND_IMPORT";
    private BoundImportDescriptor[] descriptors;
    private LinkedHashMap<String, Short> nameHash;

    BoundImportDataDirectory(NTHeader ntHeader, BinaryReader reader) throws IOException {
        this.processDataDirectory(ntHeader, reader);
        if (this.descriptors == null) {
            this.descriptors = new BoundImportDescriptor[0];
        }
    }

    @Override
    public DataType toDataType() throws DuplicateNameException, IOException {
        StructureDataType struct = new StructureDataType(NAME, 0);
        for (BoundImportDescriptor descriptor : this.descriptors) {
            struct.add(descriptor.toDataType());
        }
        struct.setCategoryPath(new CategoryPath("/PE"));
        return struct;
    }

    public BoundImportDescriptor[] getBoundImportDescriptors() {
        return this.descriptors;
    }

    @Override
    public void markup(Program program, boolean isBinary, TaskMonitor monitor, MessageLog log, NTHeader ntHeader) throws DuplicateNameException, CodeUnitInsertionException {
        monitor.setMessage(program.getName() + ": bound import(s)...");
        Address addr = PeUtils.getMarkupAddress(program, isBinary, ntHeader, this.virtualAddress);
        if (!program.getMemory().contains(addr)) {
            return;
        }
        this.createDirectoryBookmark(program, addr);
        AddressSpace space = program.getAddressFactory().getDefaultAddressSpace();
        for (BoundImportDescriptor descriptor : this.descriptors) {
            if (monitor.isCancelled()) {
                return;
            }
            DataType dt = descriptor.toDataType();
            PeUtils.createData(program, addr, dt, log);
            addr = addr.add((long)dt.getLength());
            long namePtr = descriptor.getOffsetModuleName() + this.virtualAddress;
            Address nameAddr = space.getAddress(this.va(namePtr, isBinary));
            this.createTerminatedString(program, nameAddr, false, log);
        }
        BoundImportDescriptor terminator = new BoundImportDescriptor();
        PeUtils.createData(program, addr, terminator.toDataType(), log);
    }

    @Override
    public String getDirectoryName() {
        return NAME;
    }

    @Override
    public boolean parse() throws IOException {
        this.nameHash = new LinkedHashMap();
        int rva = this.getVirtualAddress();
        int ptr = this.getVirtualAddress();
        if (rva <= 0) {
            if (rva < 0) {
                Msg.error((Object)this, (Object)("Invalid RVA " + rva));
            }
            return false;
        }
        ArrayList<BoundImportDescriptor> descriptorsList = new ArrayList<BoundImportDescriptor>();
        while (true) {
            if (ptr < 0) {
                Msg.error((Object)this, (Object)("Invalid file index " + ptr));
                break;
            }
            BoundImportDescriptor bid = new BoundImportDescriptor(this.reader, ptr, rva);
            if (bid.getTimeDateStamp() == 0 || bid.getNumberOfModuleForwarderRefs() < 0) break;
            descriptorsList.add(bid);
            ptr += 8;
            ptr += bid.getNumberOfModuleForwarderRefs() * 8;
        }
        this.descriptors = new BoundImportDescriptor[descriptorsList.size()];
        descriptorsList.toArray(this.descriptors);
        this.buildNameHash();
        return true;
    }

    @Override
    int rvaToPointer() {
        return this.virtualAddress;
    }

    @Override
    public void writeBytes(RandomAccessFile raf, DataConverter dc, PortableExecutable template) throws IOException {
        if (this.size == 0) {
            return;
        }
        raf.seek(this.rvaToPointer());
        for (BoundImportDescriptor descriptor : this.descriptors) {
            raf.write(dc.getBytes(descriptor.getTimeDateStamp()));
            raf.write(dc.getBytes(descriptor.getOffsetModuleName()));
            raf.write(dc.getBytes(descriptor.getNumberOfModuleForwarderRefs()));
            for (int j = 0; j < descriptor.getNumberOfModuleForwarderRefs(); ++j) {
                BoundImportForwarderRef forwarder = descriptor.getBoundImportForwarderRef(j);
                raf.write(dc.getBytes(forwarder.getTimeDateStamp()));
                raf.write(dc.getBytes(forwarder.getOffsetModuleName()));
                raf.write(dc.getBytes(forwarder.getReserved()));
            }
        }
        int zeroInt = 0;
        short zeroShort = 0;
        raf.write(dc.getBytes(zeroInt));
        raf.write(dc.getBytes(zeroShort));
        raf.write(dc.getBytes(zeroShort));
        Iterator<String> iter = this.nameHash.keySet().iterator();
        short prevOffset = 0;
        while (iter.hasNext()) {
            String name = iter.next();
            Short currOffset = this.nameHash.get(name);
            if (currOffset < prevOffset) {
                throw new IllegalArgumentException();
            }
            prevOffset = currOffset;
            raf.write(name.getBytes());
            raf.write(0);
        }
    }

    void updatePointers(int offset) {
        this.virtualAddress += offset;
    }

    public void addDescriptor(BoundImportDescriptor bid) {
        BoundImportDescriptor[] tmp = new BoundImportDescriptor[this.descriptors.length + 1];
        System.arraycopy(this.descriptors, 0, tmp, 0, this.descriptors.length);
        tmp[tmp.length - 1] = bid;
        this.descriptors = tmp;
        this.size += 8;
        this.size += bid.getNumberOfModuleForwarderRefs() * 8;
        this.size += bid.getModuleName().length() + 1;
        this.buildNameHash();
    }

    private void buildNameHash() {
        this.nameHash.clear();
        int pos = (this.descriptors.length + 1) * 8;
        for (BoundImportDescriptor descriptor : this.descriptors) {
            pos += descriptor.getNumberOfModuleForwarderRefs() * 8;
        }
        for (BoundImportDescriptor descriptor : this.descriptors) {
            Short offset = this.nameHash.get(descriptor.getModuleName());
            if (offset != null) {
                descriptor.setOffsetModuleName(offset);
            } else {
                String moduleName = descriptor.getModuleName();
                if (moduleName != null && moduleName.length() > 0) {
                    this.nameHash.put(moduleName, new Short((short)pos));
                    descriptor.setOffsetModuleName((short)pos);
                    pos += descriptor.getModuleName().length() + 1;
                }
            }
            for (int j = 0; j < descriptor.getNumberOfModuleForwarderRefs(); ++j) {
                BoundImportForwarderRef forwarder = descriptor.getBoundImportForwarderRef(j);
                if (forwarder == null) continue;
                offset = this.nameHash.get(forwarder.getModuleName());
                if (offset != null) {
                    forwarder.setOffsetModuleName(offset);
                    continue;
                }
                String moduleName = forwarder.getModuleName();
                if (moduleName == null || moduleName.length() <= 0) continue;
                this.nameHash.put(moduleName, new Short((short)pos));
                forwarder.setOffsetModuleName((short)pos);
                pos += forwarder.getModuleName().length() + 1;
            }
        }
    }
}

