/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pe;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.ByteArrayConverter;
import ghidra.app.util.bin.StructConverter;
import ghidra.program.model.data.ArrayDataType;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.DataConverter;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class BaseRelocation
implements StructConverter,
ByteArrayConverter {
    public static final String NAME = "IMAGE_BASE_RELOCATION";
    public static final int IMAGE_SIZEOF_BASE_RELOCATION = 8;
    public static final int IMAGE_REL_BASED_NOOP = 0;
    public static final int IMAGE_REL_BASED_ABSOLUTE = 0;
    public static final int IMAGE_REL_BASED_HIGH = 1;
    public static final int IMAGE_REL_BASED_LOW = 2;
    public static final int IMAGE_REL_BASED_HIGHLOW = 3;
    public static final int IMAGE_REL_BASED_HIGHADJ = 4;
    public static final int IMAGE_REL_BASED_MIPS_JMPADDR = 5;
    public static final int IMAGE_REL_BASED_SECTION = 6;
    public static final int IMAGE_REL_BASED_REL32 = 7;
    public static final int IMAGE_REL_BASED_MIPS_JMPADDR16 = 9;
    public static final int IMAGE_REL_BASED_IA64_IMM64 = 9;
    public static final int IMAGE_REL_BASED_DIR64 = 10;
    public static final int IMAGE_REL_BASED_HIGH3ADJ = 11;
    public static final String[] TYPE_STRINGS = new String[]{"ABSOLUTE", "HIGH", "LOW", "HIGHLOW", "HIGHADJ", "MIPS_JMPADDR", "???6", "???7", "???8", "IA64_IMM64", "DIR64"};
    private int virtualAddress;
    private int sizeOfBlock;
    private List<TypeOffset> typeOffsetList = new ArrayList<TypeOffset>();

    BaseRelocation(BinaryReader reader, int index) throws IOException {
        this.virtualAddress = reader.readInt(index);
        this.sizeOfBlock = reader.readInt(index += 4);
        index += 4;
        if (this.virtualAddress < 0) {
            return;
        }
        if (this.sizeOfBlock < 0 || this.sizeOfBlock > 65536) {
            return;
        }
        int len = (this.sizeOfBlock - 8) / 2;
        for (int i = 0; i < len; ++i) {
            short typeOffset = reader.readShort(index);
            index += 2;
            this.typeOffsetList.add(new TypeOffset(typeOffset));
        }
    }

    BaseRelocation(int virtualAddress) {
        this.virtualAddress = virtualAddress;
        this.sizeOfBlock = 8;
    }

    public void addRelocation(int type, int offset) {
        this.typeOffsetList.add(new TypeOffset(type, offset));
        this.sizeOfBlock += 2;
    }

    public int getVirtualAddress() {
        return this.virtualAddress;
    }

    public int getSizeOfBlock() {
        return this.sizeOfBlock;
    }

    public int getCount() {
        return this.typeOffsetList.size();
    }

    public int getOffset(int index) {
        return this.typeOffsetList.get((int)index).offset;
    }

    public int getType(int index) {
        return this.typeOffsetList.get((int)index).type;
    }

    @Override
    public DataType toDataType() throws DuplicateNameException {
        StructureDataType struct = new StructureDataType(NAME, 0);
        struct.add(DWORD, "VirtualAddress", null);
        struct.add(DWORD, "SizeOfBlock", null);
        struct.add((DataType)new ArrayDataType(WORD, this.typeOffsetList.size(), WORD.getLength()), "TypeOffset", null);
        struct.setCategoryPath(new CategoryPath("/PE"));
        return struct;
    }

    @Override
    public byte[] toBytes(DataConverter dc) {
        byte[] bytes = new byte[this.sizeOfBlock];
        int pos = 0;
        dc.getBytes(this.virtualAddress, bytes, pos);
        dc.getBytes(this.sizeOfBlock, bytes, pos += 4);
        pos += 4;
        for (int i = 0; i < this.typeOffsetList.size(); ++i) {
            short typeOffset = this.typeOffsetList.get((int)i).typeOffset;
            dc.getBytes(typeOffset, bytes, pos);
            pos += 2;
        }
        return bytes;
    }

    private class TypeOffset {
        short typeOffset;
        int type;
        int offset;

        TypeOffset(short typeOffset) {
            this.typeOffset = typeOffset;
            this.type = (typeOffset & 0xF000) >> 12 & 0xF;
            this.offset = typeOffset & 0xFFF;
        }

        TypeOffset(int type, int offset) {
            this.typeOffset = (short)((type & 0xF) << 12 | offset & 0xFFF);
            this.type = type;
            this.offset = offset;
        }
    }
}

