/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.debug;

import db.DBHandle;
import db.DBListener;
import db.Table;
import db.TableStatistics;
import docking.widgets.combobox.GComboBox;
import docking.widgets.label.GDLabel;
import docking.widgets.label.GLabel;
import docking.widgets.table.GTable;
import ghidra.app.plugin.debug.dbtable.DbLargeTableModel;
import ghidra.app.plugin.debug.dbtable.DbSmallTableModel;
import ghidra.app.plugin.debug.dbtable.LongRenderer;
import ghidra.util.Msg;
import ghidra.util.layout.PairLayout;
import ghidra.util.task.SwingUpdateManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Hashtable;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;

class DbViewerComponent
extends JPanel {
    private static Table[] NO_TABLES = new Table[0];
    private static Comparator<Table> TABLE_NAME_COMPARATOR = new Comparator<Table>(){

        @Override
        public int compare(Table o1, Table o2) {
            return o1.getName().compareTo(o2.getName());
        }
    };
    private DBHandle dbh;
    private DBListener dbListener;
    private JPanel southPanel;
    private JLabel dbLabel;
    private JComboBox<TableItem> combo;
    private Table[] tables = NO_TABLES;
    private Hashtable<String, TableStatistics[]> tableStats = new Hashtable();
    private SwingUpdateManager updateMgr;

    DbViewerComponent() {
        super(new BorderLayout());
        JPanel northPanel = new JPanel(new FlowLayout(0));
        JPanel subNorthPanel = new JPanel((LayoutManager)new PairLayout(4, 10));
        subNorthPanel.add((Component)new GLabel("Database:"));
        this.dbLabel = new GDLabel();
        subNorthPanel.add(this.dbLabel);
        subNorthPanel.add((Component)new GLabel("Tables:"));
        this.combo = new GComboBox();
        this.combo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DbViewerComponent.this.refreshTable();
            }
        });
        subNorthPanel.add(this.combo);
        northPanel.add(subNorthPanel);
        this.add((Component)northPanel, "North");
        this.updateMgr = new SwingUpdateManager(100, 2000, new Runnable(){

            @Override
            public void run() {
                DbViewerComponent.this.refresh();
            }
        });
    }

    synchronized void closeDatabase() {
        if (this.dbh != null) {
            this.combo.removeAllItems();
            this.dbLabel.setText("");
            if (this.southPanel != null) {
                this.remove(this.southPanel);
                this.southPanel = null;
            }
            this.tables = NO_TABLES;
            this.tableStats.clear();
            this.dbh = null;
            this.dbListener = null;
            this.revalidate();
        }
    }

    synchronized void openDatabase(String name, DBHandle handle) {
        this.closeDatabase();
        this.dbh = handle;
        this.dbLabel.setText(name);
        this.updateTableChoices(null);
        this.dbListener = this.getNewDBListener();
        handle.addListener(this.dbListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void refresh() {
        if (this.dbh == null) {
            return;
        }
        DBHandle dBHandle = this.dbh;
        synchronized (dBHandle) {
            this.updateTableChoices((TableItem)this.combo.getSelectedItem());
            this.updateTable();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void refreshTable() {
        if (this.dbh == null) {
            if (this.southPanel != null) {
                this.remove(this.southPanel);
                this.southPanel = null;
            }
            return;
        }
        DBHandle dBHandle = this.dbh;
        synchronized (dBHandle) {
            this.updateTable();
        }
    }

    synchronized void dispose() {
        this.updateMgr.dispose();
        this.closeDatabase();
    }

    private TableStatistics[] getStats(Table table) {
        TableStatistics[] stats = this.tableStats.get(table.getName());
        if (stats == null) {
            try {
                stats = table.getAllStatistics();
                for (int i = 2; i < stats.length; ++i) {
                    stats[1].bufferCount += stats[i].bufferCount;
                    stats[1].chainedBufferCnt += stats[i].chainedBufferCnt;
                    stats[1].interiorNodeCnt += stats[i].interiorNodeCnt;
                    stats[1].recordNodeCnt += stats[i].recordNodeCnt;
                    stats[1].size += stats[i].size;
                }
                this.tableStats.put(table.getName(), stats);
            }
            catch (IOException e) {
                Msg.debug((Object)this, (Object)"Unexpected exception", (Throwable)e);
            }
        }
        return stats;
    }

    private void updateTableChoices(TableItem selectedTable) {
        this.tables = NO_TABLES;
        this.combo.removeAllItems();
        this.tableStats.clear();
        if (this.dbh != null) {
            this.tables = this.dbh.getTables();
            Arrays.sort(this.tables, TABLE_NAME_COMPARATOR);
        }
        int selIndex = -1;
        for (int i = 0; i < this.tables.length; ++i) {
            this.combo.addItem(new TableItem(this.tables[i]));
            if (selectedTable == null || !this.tables[i].getName().equals(selectedTable.name)) continue;
            selIndex = i;
        }
        if (selIndex >= 0) {
            this.combo.setSelectedIndex(selIndex);
        }
    }

    private void updateTable() {
        TableItem t;
        if (this.southPanel != null) {
            this.remove(this.southPanel);
            this.southPanel = null;
        }
        if ((t = (TableItem)this.combo.getSelectedItem()) != null) {
            this.southPanel = this.createSouthPanel(t.table);
            this.add((Component)this.southPanel, "Center");
        }
        this.revalidate();
    }

    private JPanel createSouthPanel(Table table) {
        JPanel panel = new JPanel(new BorderLayout());
        Object model = null;
        GTable gTable = new GTable();
        model = table.getRecordCount() <= 10000 ? new DbSmallTableModel(table) : new DbLargeTableModel(table);
        gTable.setModel((TableModel)model);
        gTable.setDefaultRenderer(Long.class, (TableCellRenderer)((Object)new LongRenderer()));
        JScrollPane scroll = new JScrollPane((Component)gTable);
        panel.add((Component)scroll, "Center");
        TableStatistics[] stats = this.getStats(table);
        String recCnt = "Records: " + Integer.toString(table.getRecordCount());
        Object intNodeCnt = "";
        Object recNodeCnt = "";
        Object chainBufCnt = "";
        Object size = "";
        if (stats != null) {
            intNodeCnt = "Interior Nodes: " + Integer.toString(stats[0].interiorNodeCnt);
            recNodeCnt = "Record Nodes: " + Integer.toString(stats[0].recordNodeCnt);
            chainBufCnt = "Chained Buffers: " + Integer.toString(stats[0].chainedBufferCnt);
            size = "Size (KB): " + Integer.toString(stats[0].size / 1024);
            if (stats.length > 1) {
                intNodeCnt = (String)intNodeCnt + " / " + Integer.toString(stats[1].interiorNodeCnt);
                recNodeCnt = (String)recNodeCnt + " / " + Integer.toString(stats[1].recordNodeCnt);
                chainBufCnt = (String)chainBufCnt + " / " + Integer.toString(stats[1].chainedBufferCnt);
                size = (String)size + " / " + Integer.toString(stats[1].size / 1024);
            }
        }
        panel.add((Component)new GLabel(recCnt + "   " + (String)intNodeCnt + "   " + (String)recNodeCnt + "   " + (String)chainBufCnt + "   " + (String)size), "South");
        return panel;
    }

    private DBListener getNewDBListener() {
        return new InternalDBListener();
    }

    private static class TableItem {
        String name;
        Table table;

        TableItem(Table table) {
            this.table = table;
            this.name = table.getName();
        }

        public String toString() {
            return this.name + " (" + this.table.getRecordCount() + ")";
        }
    }

    private class InternalDBListener
    implements DBListener {
        private InternalDBListener() {
        }

        public void dbClosed(DBHandle handle) {
            if (handle == DbViewerComponent.this.dbh) {
                DbViewerComponent.this.closeDatabase();
            }
        }

        public void dbRestored(DBHandle handle) {
            if (handle == DbViewerComponent.this.dbh) {
                DbViewerComponent.this.updateMgr.updateLater();
            }
        }

        public void tableAdded(DBHandle handle, Table table) {
            if (handle == DbViewerComponent.this.dbh) {
                DbViewerComponent.this.updateMgr.updateLater();
            }
        }

        public void tableDeleted(DBHandle handle, Table table) {
            if (handle == DbViewerComponent.this.dbh) {
                DbViewerComponent.this.updateMgr.updateLater();
            }
        }
    }
}

