/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.reloc;

import ghidra.app.plugin.core.reloc.RelocationTableModel;
import ghidra.app.plugin.core.reloc.RelocationTablePlugin;
import ghidra.app.services.GoToService;
import ghidra.framework.plugintool.ComponentProviderAdapter;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.ServiceProvider;
import ghidra.program.model.listing.Program;
import ghidra.util.HelpLocation;
import ghidra.util.table.GhidraTable;
import ghidra.util.table.GhidraTableFilterPanel;
import ghidra.util.table.GhidraThreadedTablePanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.ToolTipManager;

class RelocationProvider
extends ComponentProviderAdapter {
    private GhidraTable table;
    private RelocationTableModel tableModel;
    private RelocationTablePlugin plugin;
    private JPanel mainPanel;
    private Program currentProgram;
    private GhidraTableFilterPanel<RelocationTableModel.RelocationRowObject> tableFilterPanel;
    private GhidraThreadedTablePanel<RelocationTableModel.RelocationRowObject> threadedPanel;

    RelocationProvider(RelocationTablePlugin plugin) {
        super(plugin.getTool(), "Relocation Table", plugin.getName());
        this.plugin = plugin;
        this.mainPanel = this.buildMainPanel();
        this.setHelpLocation(new HelpLocation(plugin.getName(), "Relocation_Table"));
        this.addToTool();
    }

    public JComponent getComponent() {
        return this.mainPanel;
    }

    public void componentShown() {
        this.tableModel.setProgram(this.currentProgram);
    }

    public void componentHidden() {
        this.tableModel.setProgram(null);
    }

    private JPanel buildMainPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        PluginTool serviceProvider = this.plugin.getTool();
        this.tableModel = new RelocationTableModel((ServiceProvider)serviceProvider, this.currentProgram, null);
        this.tableModel.addTableModelListener(e -> {
            int rowCount = this.tableModel.getRowCount();
            this.setSubTitle(rowCount + " rows");
        });
        this.threadedPanel = new GhidraThreadedTablePanel<RelocationTableModel.RelocationRowObject>(this.tableModel);
        this.table = this.threadedPanel.getTable();
        GoToService goToService = (GoToService)serviceProvider.getService(GoToService.class);
        this.table.installNavigation(goToService, goToService.getDefaultNavigatable());
        this.table.setPreferredScrollableViewportSize(new Dimension(300, 200));
        this.table.setSelectionMode(2);
        this.table.setAutoResizeMode(1);
        this.table.getSelectionModel().addListSelectionListener(e -> this.contextChanged());
        ToolTipManager.sharedInstance().registerComponent((JComponent)((Object)this.table));
        panel.add((Component)((Object)this.threadedPanel), "Center");
        this.tableFilterPanel = new GhidraTableFilterPanel((JTable)((Object)this.table), this.tableModel);
        panel.add((Component)((Object)this.tableFilterPanel), "South");
        return panel;
    }

    void setProgram(Program program) {
        this.currentProgram = program;
        if (this.isVisible()) {
            this.tableModel.setProgram(this.currentProgram);
        }
    }

    GhidraTable getTable() {
        return this.table;
    }

    void dispose() {
        this.setProgram(null);
        this.removeFromTool();
        this.threadedPanel.dispose();
        this.tableFilterPanel.dispose();
    }
}

