/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.navigation;

import ghidra.framework.options.OptionsChangeListener;
import ghidra.framework.options.ToolOptions;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.util.OptionsService;
import ghidra.util.HelpLocation;

public class NavigationOptions
implements OptionsChangeListener {
    static final String NAVIGATION_TOPIC = "Navigation";
    static final String NAVIGATION_OPTIONS = "Navigation";
    static final String NAVIGATION_RANGE_OPTION = "Range Navigation";
    static final String NAVIGATION_RANGE_DESCRIPTION = "Determines how navigation of ranges (i.e., selection ranges and highlight ranges) takes place.  By default, navigating to ranges will place the cursor at the top of the next range.  You may use this option to navigate to both the top and the bottom of each range being navigated.";
    static final String EXTERNAL_NAVIGATION_OPTION = "External Navigation";
    static final String EXTERNAL_NAVIGATION_DESCRIPTION = "Determines the behavior for navigation to external symbols and references. By default, navigating to an external will attempt to navigate within the current program to the first linkage reference (pointer or thunk).  Alternatively, if an external program has been associated with an import Library, then that program will be opened and positioned to the selected external location if found.";
    static final String FOLLOW_INDIRECTION_NAVIGATION_OPTION = "Follow Indirection";
    static final String FOLLOW_INDIRECTION_NAVIGATION_DESCRIPTION = "Determines the behavior for navigation on indirect flow references. By default, this option is disabled providing navigation to the referenced pointer data.  If enabled, the pointer will be followed to its referenced destination if contained within the program's memory.";
    static final String ASSUME_CURRENT_ADDRESS_SPACE = "Prefer Current Address Space";
    private static final String ASSUME_CURRENT_ADDRESS_SPACE_DESCRIPTION = "Determines if the 'Go To' action prefers the current address space when entering address offsets. For example, if your program has multiple address spaces such as 'RAM' or 'DATA' and you  enter 1000 into the 'Go To' field, you could mean RAM:1000 or DATA:1000.  If this option is on, then it will go to the address with the address space that matches the current cursor location.  Otherwise, it will show a list of possible addresses for the given offset. The default is on for this option.";
    private final String RESTRICT_GOTO_CURRENT_TAB = "'Go To' in Current Program Only";
    private static final String RESTRICT_GOTO_CURRENT_TAB_DESCRIPTION = "Determines if the 'Go To' service will only search for and navigate to locations in the current program. If this option is off and the search location is not found in the current program, the 'Go To' action will search other open programs, possibly resulting in the listing view switching to a different open program tab. By default, this option is on, thereby guaranteeing that the listing view will not change to a different program when performing a 'Go To' action.";
    private boolean gotoTopAndBottom;
    private boolean gotoExternalProgram;
    private boolean followIndirectReferences;
    private ToolOptions options;
    private boolean preferCurrentAddressSpace;
    private boolean restrictGotoToCurrentProgram;

    public NavigationOptions(PluginTool tool) {
        this(tool.getOptions("Navigation"));
    }

    public NavigationOptions(OptionsService optionsService) {
        this(optionsService.getOptions("Navigation"));
    }

    private NavigationOptions(ToolOptions options) {
        this.options = options;
        HelpLocation help = new HelpLocation("Navigation", "Navigation_Options");
        options.registerOption(NAVIGATION_RANGE_OPTION, (Object)RangeNavigationEnum.TopOfRangeOnly, help, NAVIGATION_RANGE_DESCRIPTION);
        RangeNavigationEnum rangeNavigationOption = (RangeNavigationEnum)options.getEnum(NAVIGATION_RANGE_OPTION, (Enum)RangeNavigationEnum.TopOfRangeOnly);
        this.gotoTopAndBottom = rangeNavigationOption == RangeNavigationEnum.TopAndBottomOfRange;
        options.registerOption(EXTERNAL_NAVIGATION_OPTION, (Object)ExternalNavigationEnum.NavigateToLinkage, help, EXTERNAL_NAVIGATION_DESCRIPTION);
        ExternalNavigationEnum externalNavigationOption = (ExternalNavigationEnum)options.getEnum(EXTERNAL_NAVIGATION_OPTION, (Enum)ExternalNavigationEnum.NavigateToLinkage);
        this.gotoExternalProgram = externalNavigationOption == ExternalNavigationEnum.NavigateToExternalProgram;
        options.registerOption(FOLLOW_INDIRECTION_NAVIGATION_OPTION, (Object)false, help, FOLLOW_INDIRECTION_NAVIGATION_DESCRIPTION);
        this.followIndirectReferences = options.getBoolean(FOLLOW_INDIRECTION_NAVIGATION_OPTION, false);
        options.registerOption(ASSUME_CURRENT_ADDRESS_SPACE, (Object)true, help, ASSUME_CURRENT_ADDRESS_SPACE_DESCRIPTION);
        this.preferCurrentAddressSpace = options.getBoolean(ASSUME_CURRENT_ADDRESS_SPACE, true);
        options.registerOption("'Go To' in Current Program Only", (Object)true, help, RESTRICT_GOTO_CURRENT_TAB_DESCRIPTION);
        this.restrictGotoToCurrentProgram = options.getBoolean("'Go To' in Current Program Only", true);
        options.addOptionsChangeListener((OptionsChangeListener)this);
    }

    public void dispose() {
        this.options.removeOptionsChangeListener((OptionsChangeListener)this);
    }

    public void optionsChanged(ToolOptions toolOptions, String optionName, Object oldValue, Object newValue) {
        if (NAVIGATION_RANGE_OPTION.equals(optionName)) {
            RangeNavigationEnum rangeNavigationOption = (RangeNavigationEnum)((Object)newValue);
            this.gotoTopAndBottom = rangeNavigationOption == RangeNavigationEnum.TopAndBottomOfRange;
        } else if (EXTERNAL_NAVIGATION_OPTION.equals(optionName)) {
            ExternalNavigationEnum externalNavigationOption = (ExternalNavigationEnum)((Object)newValue);
            this.gotoExternalProgram = externalNavigationOption == ExternalNavigationEnum.NavigateToExternalProgram;
        } else if (FOLLOW_INDIRECTION_NAVIGATION_OPTION.equals(optionName)) {
            this.followIndirectReferences = (Boolean)newValue;
        } else if (ASSUME_CURRENT_ADDRESS_SPACE.equals(optionName)) {
            this.preferCurrentAddressSpace = (Boolean)newValue;
        } else if ("'Go To' in Current Program Only".contentEquals(optionName)) {
            this.restrictGotoToCurrentProgram = (Boolean)newValue;
        }
    }

    public boolean isGotoTopAndBottomOfRangeEnabled() {
        return this.gotoTopAndBottom;
    }

    public boolean isGotoExternalProgramEnabled() {
        return this.gotoExternalProgram;
    }

    public boolean isFollowIndirectionEnabled() {
        return this.followIndirectReferences;
    }

    public boolean preferCurrentAddressSpace() {
        return this.preferCurrentAddressSpace;
    }

    public boolean isGoToRestrictedToCurrentProgram() {
        return this.restrictGotoToCurrentProgram;
    }

    public static enum RangeNavigationEnum {
        TopOfRangeOnly("Top of Range Only"),
        TopAndBottomOfRange("Top and Bottom of Range");

        private String label;

        private RangeNavigationEnum(String label) {
            this.label = label;
        }

        public String toString() {
            return this.label;
        }
    }

    public static enum ExternalNavigationEnum {
        NavigateToLinkage("Navigate to Linkage"),
        NavigateToExternalProgram("Navigate to External Program");

        private String label;

        private ExternalNavigationEnum(String label) {
            this.label = label;
        }

        public String toString() {
            return this.label;
        }
    }
}

