/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.function.editor;

import docking.DialogComponentProvider;
import docking.DockingWindowManager;
import ghidra.app.plugin.core.function.editor.FunctionEditorModel;
import ghidra.app.plugin.core.function.editor.FunctionVariableData;
import ghidra.app.plugin.core.function.editor.ParameterTableModel;
import ghidra.app.plugin.core.function.editor.StorageAddressEditorDialog;
import ghidra.program.model.listing.VariableStorage;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import javax.swing.AbstractCellEditor;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.table.TableCellEditor;

class StorageTableCellEditor
extends AbstractCellEditor
implements TableCellEditor {
    private VariableStorage storage;
    private FunctionEditorModel model;

    public StorageTableCellEditor(FunctionEditorModel model) {
        this.model = model;
    }

    @Override
    public Object getCellEditorValue() {
        return this.storage;
    }

    @Override
    public boolean isCellEditable(EventObject e) {
        if (e instanceof MouseEvent) {
            return ((MouseEvent)e).getClickCount() > 1;
        }
        return true;
    }

    @Override
    public Component getTableCellEditorComponent(final JTable table, Object value, boolean isSelected, int row, int column) {
        String stringValue = value == null ? "" : value.toString();
        JTextField field = new JTextField(stringValue);
        field.setBackground(Color.yellow);
        field.setEditable(false);
        ParameterTableModel tableModel = (ParameterTableModel)((Object)table.getModel());
        FunctionVariableData rowData = (FunctionVariableData)tableModel.getRowObject(row);
        final StorageAddressEditorDialog dialog = new StorageAddressEditorDialog(this.model.getProgram(), this.model.getDataTypeManagerService(), (VariableStorage)value, rowData);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                TableCellEditor cellEditor;
                DockingWindowManager.showDialog((Component)table, (DialogComponentProvider)dialog);
                if (!dialog.wasCancelled()) {
                    StorageTableCellEditor.this.storage = dialog.getStorage();
                }
                if ((cellEditor = table.getCellEditor()) == null) {
                    return;
                }
                if (StorageTableCellEditor.this.storage == null) {
                    cellEditor.cancelCellEditing();
                } else {
                    cellEditor.stopCellEditing();
                }
            }
        });
        return field;
    }
}

