/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.function;

import ghidra.app.cmd.function.CreateThunkFunctionCmd;
import ghidra.app.plugin.core.analysis.AutoAnalysisManager;
import ghidra.app.services.AbstractAnalyzer;
import ghidra.app.services.AnalysisPriority;
import ghidra.app.services.AnalyzerType;
import ghidra.app.util.importer.MessageLog;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressIterator;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Instruction;
import ghidra.program.model.listing.Listing;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.Reference;
import ghidra.program.model.symbol.ReferenceManager;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.model.symbol.SymbolIterator;
import ghidra.program.model.symbol.SymbolType;
import ghidra.util.task.TaskMonitor;

public class FunctionAnalyzer
extends AbstractAnalyzer {
    private static final String FIND_FUNCTION_STARTS_MSG = "Find Function Starts : ";
    private static final String NAME = "Subroutine References";
    private static final String DESCRIPTION = "Create Function definitions for code that is called.";
    private static final int NOTIFICATION_INTERVAL = 256;
    protected boolean createOnlyThunks = false;
    protected String analysisMessage = "Find Function Starts : ";

    public FunctionAnalyzer() {
        super(NAME, DESCRIPTION, AnalyzerType.INSTRUCTION_ANALYZER);
        this.setPriority(AnalysisPriority.CODE_ANALYSIS.before());
        this.setDefaultEnablement(true);
    }

    @Override
    public boolean added(Program program, AddressSetView set, TaskMonitor monitor, MessageLog log) {
        ReferenceManager mgr = program.getReferenceManager();
        Listing listing = program.getListing();
        AddressSet funcStarts = new AddressSet();
        int count = 0;
        long initial_count = set.getNumAddresses();
        monitor.initialize(initial_count);
        AddressSet leftSet = new AddressSet(set);
        AddressIterator iter = mgr.getReferenceSourceIterator(set, true);
        while (!monitor.isCancelled() && iter.hasNext()) {
            Reference[] refs;
            Instruction instr;
            Address addr = iter.next();
            if (++count > 256) {
                leftSet.deleteRange(leftSet.getMinAddress(), addr);
                monitor.setProgress(initial_count - leftSet.getNumAddresses());
                monitor.setMessage(this.analysisMessage + addr);
                count = 0;
            }
            if ((instr = listing.getInstructionAt(addr)) == null || !instr.getFlowType().isCall()) continue;
            for (Reference ref : refs = mgr.getFlowReferencesFrom(addr)) {
                if (!ref.getReferenceType().isCall()) continue;
                Address entryAddr = ref.getToAddress();
                if (this.fallthroughCall(program, ref)) continue;
                funcStarts.addRange(entryAddr, entryAddr);
            }
        }
        SymbolIterator symIter = program.getSymbolTable().getSymbols((AddressSetView)funcStarts, SymbolType.FUNCTION, true);
        AddressSet funcEntryPoints = new AddressSet();
        while (symIter.hasNext()) {
            Symbol funcSymbol = symIter.next();
            if (this.isPlaceHolderFunctionThatShouldBeFixed(program, listing, funcSymbol)) continue;
            funcEntryPoints.addRange(funcSymbol.getAddress(), funcSymbol.getAddress());
        }
        funcStarts.delete((AddressSetView)funcEntryPoints);
        if (this.createOnlyThunks && !funcStarts.isEmpty()) {
            AddressSet thunkStarts = new AddressSet();
            AddressIterator iterator = funcStarts.getAddresses(true);
            while (iterator.hasNext()) {
                Address entry = iterator.next();
                Address thunkedAddr = CreateThunkFunctionCmd.getThunkedAddr(program, entry, true);
                if (thunkedAddr == null) continue;
                thunkStarts.add(entry);
            }
            funcStarts = thunkStarts;
        }
        if (!funcStarts.isEmpty()) {
            AutoAnalysisManager amgr = AutoAnalysisManager.getAnalysisManager(program);
            amgr.createFunction((AddressSetView)funcStarts, false);
        }
        return true;
    }

    private boolean isPlaceHolderFunctionThatShouldBeFixed(Program program, Listing listing, Symbol funcSymbol) {
        Function func = program.getFunctionManager().getFunctionAt(funcSymbol.getAddress());
        if (func == null) {
            return false;
        }
        if (func.getBody().getNumAddresses() > 1L) {
            return false;
        }
        Instruction instr = listing.getInstructionAt(func.getEntryPoint());
        if (instr == null) {
            return false;
        }
        return instr.getLength() > 1 || !instr.getFlowType().isTerminal();
    }

    private boolean fallthroughCall(Program program, Reference ref) {
        Address from = ref.getFromAddress();
        Instruction instr = program.getListing().getInstructionAt(from);
        if (instr == null) {
            return false;
        }
        return instr.getFallThrough() == ref.getToAddress();
    }
}

